import java.io.*; 
import java.net.*; 

class UDPServidor
{ 
  public static void main(String args[]) throws Exception 
  { 
    DatagramSocket socketServidor = new DatagramSocket(9876); 

    byte[] recibirDatos = new byte[1024]; 
    byte[] enviarDatos  = new byte[1024]; 

    while(true) 
    { 
      DatagramPacket recibirPaquete = 
      new DatagramPacket(recibirDatos, recibirDatos.length); 

      System.out.println("El servidor esta esperando recibir una frase por el socket UDP."); 
      socketServidor.receive(recibirPaquete); 

      String frase =
        new String(recibirPaquete.getData(), 0, recibirPaquete.getLength());

      System.out.println("Ha llegado por el socket UDP la frase: " + frase); 

      InetAddress direccionIP = recibirPaquete.getAddress(); 

      int puerto = recibirPaquete.getPort(); 

      String fraseMayusculas = frase.toUpperCase(); 

      enviarDatos = fraseMayusculas.getBytes(); 

      DatagramPacket sendPacket = new DatagramPacket(
        enviarDatos, enviarDatos.length, direccionIP, puerto); 

      socketServidor.send(sendPacket); 
      System.out.println("El servidor ha enviado por el socket UDP la frase: " + fraseMayusculas); 
    } 
  } 
}  
