/*------------------------- PROBLEMA 3--------------------------------------------------------------
Se desea diseñar un sistema de riego que pueda funcionar de forma automática y manual. El funcionamiento manual hace que al activarse un pulsador se abra la válvula de salida del agua durante 1 hora. El funcionamiento automático se basa en un sensor de humedad que es consultado cada 8 horas. Dicho sensor proporciona niveles de humedad de 0 a 255 codificados mediante 8 bits.  El riego se activará si el valor detectado es inferior a 30.

El sistema diseñado se basará en el Atmega328P a 1Mhz. El pulsador (que no posee resistencia de pull-up) se conectará al pin 0 del puerto C. La señal que permite abrir la válvula de riego se conectará al pin 1 del puerto C. Los 8 bits que proporcionan el valor de la humedad se conectan al puerto B.

El tiempo será contabilizado mediante una subrutina de interrupción que cada vez que transcurre 1 segundo incrementará los registros R25-R24 (ADIW). Para comprobar que han transcurrido 1 u  8 horas se comparará con 3600 y 28.800 respectivamente (deberán utilizar CP y CPC y realizar la comparación en dos veces ya que son números que deben codificarse en 16 bits). Los registros R25-R24 deben reiniciarse al poner en marcha el riego y cada vez que el sensor de humedad es consultado.
El programa debe instalar adecuadamente las interrupciones del timer y contener las siguientes partes:
a) Rutina de configuración de entrada salida. Que establezca los valores adecuados de los registros asociados a los temporizadores y puertos utilizados.
b) Rutina de interrupción. Dentro de la misma debe programarse el incremento de los registros R25-R24
c) Programa principal. Se basará en el valor del pulsador o del sensor de humedad para poner en marcha el riego. Pondrá a cero en los momentos adecuados R25-R24. Consultará R25-R24 para determinar si debe parar el riego o consultar el sensor de humedad.

Se deben de comentar y justificar adecuadamente el código   
--------------------------------------------------------------------------------------------------- */

/*******************************************************************************************

Funcionamiento MANUAL
           - Si se presiona el Pulsador, se abre la Válvula durante 1h
	   - PC0 (se necesita resistencia de PULL-UP interna)
	   	Se entiende que un 0 es pulsación y un 1 no pulsación
 

	---------
Pulsador|       |   A la válvula
------->|       |---------------->
	|       |     
        ---------

Funcionamiento AUTOMÁTICO
           - Se consulta el Sens Humedad cada 8h
	   - Si Sens Humedad <30 , se abre la válvula
	   - Sens Hum conectados al PB[7-0]
 

	---------
Sens Hum|       |   A la válvula
------->|       |---------------->
	|       |     
        ---------

Para ambos funcionamientos

	    -La señal que va a la válvula de riego se conecta a PC1
	    -Elegimos un 1 para abrir la válvula y un 0 para cerrarla

********************************************************************************************/



	.include "m328pdef.inc"


	.def temp=r16
	.def ContH=r25
	.def ContL=r24


	.cseg

		.org	0
		jmp		Reset
		.org	$16	
		jmp		IntTimer1
		



/******************************************************************************
	PROGRAMA PRINCIPAL
pseudocódigo


	ConfiguraES()
	Cont<-0
	mientras(1)
		Si (PC0 == 0)
			Cont <-0
			PC1 <- 1  ;Abre válvula
			mientras (Cont < 3600)
			fin mientras
			Cont <-0
			PC1 <-0   ;Cierra válvula
		fsi

		Si (Cont >28800)
			si (PB < 30)
				PC1<-1 ;Abre válvula
			sino
				PC1<-0 ;Cierra válvula	
			fsi	
			Cont <-0
		fsi

	fin mientras

******************************************************************************/

Reset:	rcall  ConfiguraES
		clr    ContH
		clr    ContL

Programa:

manual:	sbic	pinc,0		;si(PC0==0)
		rjmp	automatico
		
		clr		ContH
		clr		ContL		;	Cont<-0
		
		sbi		PORTC,1		;	PC1<-1

mient1:	cpi		ContH,high(3600);	mientras(Cont<3600)
		brne	mient1
		cpi		ContL,low(3600);
		brcs	mient1		;	fin mientras
		
		clr		ContH
		clr		ContL		;	Cont<-0

		cbi		PORTC,1		;	PC1<-0
							;fsi


automatico:	
		cpi		ContH,high(28800);Si (Cont >28800)
		brne	Programa
		cpi		ContL,low(28800);
		brcs	Programa

		in		temp,PINB	
		cpi		temp,30
		brcc	sino		;	si (PB < 30)

		sbi		PORTC,1		;		PC1<-1 ;Abre válvula
		rjmp	finauto
	sino:					;	sino
		cbi		PORTC,1		;		PC1<-0 ;Cierra válvula	
							;	fsi	
	finauto:	
		clr 	ContH		;	Cont <-0
		clr		ContL	
							;fsi

		rjmp	Programa
				




/******************************************************************************
		CONFIGURACIÓN DE LA ENTRADA SALIDA

	-Configuración de los puertos
		DDRB (Registro de dirección del PORTB) Todo entrada
		DDRC [0] Entrada
		DDRC [1] Salida
	Configuración del TIMER1
		; Suponemos el modo de funcionamiento CTC y para éste,
		; debemos encontrar el valor de P y N que satisfaga
		; la siguiente ecuación
		;  
		;	Tint =  Tclk x  P  x N
		;
		; Donde Tclk = Periodo de la señal de relo = 1/Fclk
		; P = Prescaler (1,2,8, 64, 256, 1024)
		; N = contenido del registro OCR1A (entero de 16 bits)
		;
		; Por tanto:
		;        1s =  1us x P x N 
		;
	 	; Esta relación se cumple para P=64 y N = 15625
		
		NO OLVIDAR ESCRIBIR PRIMERO EN LA PARTE ALTA DEL REGISTRO OCCR1A
		Registros usados
		-OCCR1AH, OCCR1AL
		-TCCRIB
			-----------------------------------------------------
			| 0  |  0  |  0  |  0  | WGM12 | CS12 | CS11 | CS10 |
			-----------------------------------------------------
				WGM12 =>  1: Modo CTC ; 0: Modo Normal
				CS12:0 => Selección del Prescaler
						   --------------------------------
						   | 0  0  0  |  Parada	          |
						   | 0  0  1  |  clk	          |
						   | 0  1  0  |  clk/8            |
						   | 0  1  1  |  clk/64           |
						   | 1  0  0  |  clk/256          |
						   | 1  0  1  |  clk/1024         |
						   | 1  1  0  |  T1 flanco bajada |
						   | 1  1  1  |  T1 flanco subida |
						   --------------------------------
		- TCNT1H,TCNT1L
		- TIMSK1
			----------------------------------------------------------
			| -  |  -  |  0  |  -  |  -  |  -  |  0  | OCIE1 | TOIE1 |
			----------------------------------------------------------	
				OCIE1: Output compare interrupt enable
						0: Disable
						1: Enable
				TOIE1: Timer overflow interrupt enable
						0: Disable
						1: Enable



	Subr  ConfigEs
		DDRB <- 0 ;Configura todo el PORTB como entrada
		DDRC[0] <- 0; Configura el PC0 como entrada
		DDRC[1] <- 1; Configura el PC1 como salida
		OCCR1A <- 15625
		TCCR1B <- 00001011b = 11 = $B
		TCNT1 <- 0
		TIMSK1[1] <-1
		I <- 1
	Fin   ConfigEs

******************************************************************************/


ConfiguraEs:	
		ldi	temp,0
	 	out	DDRB,temp	;DDRB <-0
	
		cbi	DDRC,0		;DDRC[0]<-0
		
		sbi	DDRC,1		;DDRC[1]<-1

		ldi	temp,high(15625)
		sts	OCR1AH,temp	
		ldi	temp,low(15625)
		sts	OCR1AL,temp	;OCCR1A<-15625 Primero en la parte alta

		ldi	temp,0b00001011
		sts	TCCR1B,temp	;TCCR1B<-11

		ldi	temp,0
		sts	TCNT1H,temp
		sts	TCNT1L,temp	;TCNT1H<-0 Primero se escribe enla parte alta
	
		ldi	temp,2
		sts	timsk1,temp	;timsk1[1]<-1

		sei			;I<-1

		ret	


/**************************************************
	Rutina de interrupción

	Pseudocódigo:
		subint IntTimer1
			STACK <- SREG
			Cont <- Cont+1
			SREG <- STACK
		fin IntTimer1

**************************************************/

IntTimer1:
		in	temp,sreg
		push	temp

		adiw 	ContH:ContL,1	;Cont <-Cont+1

		pop	temp
		out	sreg,temp
		reti


