
/*
	Autor: Alberto J. Molina
	ltima modificacin: 1-6-11
*/
;***********************************
;  En una posicin de memoria DATO existe un nmero binario entero positivo N. Se pretende obtener el valor SUMA=N+(N-1)+(N-2)+ ... +2+1 que se guarda en una direccin de la SRAM.
;  a)Obtenga una subrutina en ensamblador que calcule SUMA siendo tanto los datos como el resultado de tamo byte. Suponga que no existe desbordamiento.
;  b)Repita el apartado anterior si los datos son de tamao Word
;  c)Indique las modificaciones a realizar en los apartados anteriores si se quiere contemplar el desbordamiento.
; 
;  Para evitar el desbordamiento en a) se deber utilizar datos de tamao palabra
;  Para evitar el desboramiento en b) se deber utilizar datos de tamao palabra larga

	.include "m328pdef.inc"


	#define ApartadoB	;Ponga esta lnea en // si desea ver la solucin para el apartado A


	.EQU N = 0x0102		;Para depuracin
	.CSEG




Main:	


// Inicializamos el contenido de DATO (para depuracin)
#ifdef	ApartadoB
		ldi   r16,low(N)
		sts	  DATO,r16
		ldi	  r16,high(N)
		sts	  DATO+1,r16
#else
		ldi	  r16,N
		sts	  DATO,r16	
#endif
// Fin de inicializacin del contenido de DATO


		rcall SucArit
fin:	rjmp  fin


/****************************************************************

	subr SucAritByte
		R1 <- 0
		R18 <- DATO
		hacer
			R1 <- R1 + R18
			R18<- R18 -1
		mientras (R18>0)
		SUMA <- R1
	fin subr

	subr SucAritWord
		R1:R0 <- 0
		R25:R24 <- DATO
		hacer
			R1:R0 <- R1:R0 + R25:R24
			R25:R24<- R25:R24 -1
		mientras (R25:R24 >0)
		SUMA <- R1:R0
	fin subr

*******************************************************************/




SucArit:
#ifdef	ApartadoB
		clr	  r1			; R1 es la parte ms significativa del RES
		clr	  r0			; R0 es la parte menos significativa del RES
		lds	  r24,DATO		; R25:R24 pueden trabajar como registro de 16 bits
		lds	  r25,DATO+1	; 		
Bucle:  add	  r0,r24		; R0<-R0 + R24
		adc	  r1,r25		; R1<-R1 + R25 + C(acarreo generado en la suma anterior)
		sbiw  r25:r24,1		; Resta 1
		brne  Bucle			; Determinamos si llega a 0
		sts   SUMA,r0		; Guardamos el resultado en SUMA. No olvidar notacin LITTLE-ENDIAN
		sts   SUMA+1,r1		
#else		
		clr	  r1			;Almacenamos Suma de forma temporal
		lds	  r18,DATO	    ;Cargamos Dato en r18
Bucle:	add	  r1,r18		;Suma<- Suma + Dato
		subi  r18,1			
		brne  Bucle
		sts	  SUMA,r1
#endif
		ret




	.DSEG
	.ORG $100
#ifdef 	ApartadoB
DATO: .BYTE 2
SUMA: .BYTE 2
#else
DATO: .BYTE 1	
SUMA: .BYTE 1
#endif
