/*
	Autor: Alberto J. Molina
	ltima modificacin: 1-6-11
*//*
	Repita el ejercicio anterior para las siguiente estructura en la que
 	se ha eliminado los latches. Adems la alimentacin de los displays 
	dispone de unos transistores conectados, a travs de resistencias, con 
	salidas del microcontrolador. Esto implica que cuando la salida del 
	microcontrolador est a 1, el transistor se activa permitiendo el flujo 
	de corriente hacia el display correspondiente, mientras que si la salida 
	est a 0 el transistor se desactiva provocando el corte de suministro al
	display, por lo que sus diodos se apagan.

*/


/*
En este caso, se proceder a disear una rutina de interrupcin que genere 
la secuencia de refresco y represente cada dgito  a partir del nmero N 
(tambin BCD, ver problema anterior), almacenado en un registro determinado. 

				-----------------
		Nmero  |0 .. 9 | 0 .. 9|
				-----------------
					MS      LS

Obsrvese que, ahora, los displays son del tipo nodo comn, por tanto, el 
cdigo 7 segmentos de cada dgito BCD es la versin complementada del problema 
anterior (si se asume que las conexiones entre cada segmento a...h y 
los bits del puerto B, son las mismas PB0 a, PB1 b, ...PB6 h). Dos pines del puerto D, PD1, y PD0, 
portarn la secuencia de refresco que tendr una periodicidad de 100Hz 
(T = 10ms), con objeto de reducir molestos parpadeos. 

La interrupcin del timer debe ser programada y con un periodo de 5ms 
(suponemos que la frecuencia de reloj es de 1MHz). Cada vez que se ejecute, 
se proceder a activar un nuevo dgito y a colocar su cdigo 7 segmentos en 
el puerto B.	
*/


	.include "m328pdef.inc"

	.equ	CERO = ~0b00111111
	.equ	UNO  = ~0b00000110
	.equ	DOS  = ~0b01011011
	.equ	TRES = ~0b01001111
	.equ	CUATRO=~0b01100110
	.equ	CINCO= ~0b01101101
	.equ	SEIS=  ~0b01111100
	.equ	SIETE= ~0b00000111
	.equ	OCHO=  ~0b01111111
	.equ	NUEVE= ~0b01100111
	
	.equ	DIGITO0 = 0
	.equ	DIGITO1 = 1


	.def	temporal = r16
	.def	N = r17
	.def	cer= r18
	.def	aux = r19

	.cseg

		.org	0
		jmp		Reset
		.org	$16	
		jmp		IntTimer1
		


Reset:	rcall  Inicializacion		;Para depuracin
		rcall  ConfiguraES
Programa:
	

Fin:	rjmp	Fin	


/**********************************************************************
	Rutina Representa
		
	
	PSEUDOCDIGO
			
		subr Representa
			si (aux[0] == 0)
				Temp <- DigitoLS(N)	
				Z <-  Tabla7seg + Temp	
				R0 <- ( Z )
				PORTB <- R0
				PORTD[1:0] = 0B01;
			sino
				Temp <- DigitoMS(N)
				Z <- Tabla7seg + Temp
				R0 <- ( Z )
				PORTB <- R0
				PORTD[1:0] = 0B10;
			fsi
		end Representa

***********************************************************************/
Representa:									;	subr Representa
		mov		temporal,aux
		lsr		temporal					;		si (aux[0] == 0)
		brcs	RepDigitoI
RepDigitoD:
		mov		temporal,N	
		andi	temporal,$F					;			Temp <- DigitoLS(N)	
		ldi		zl, low(2*Tabla7Seg)		;				Primero cargamos Z con la direccin de la tabla
		ldi		zh, high(2*Tabla7Seg)		;				y luego se le aade Temp. Obsrve el uso de la
		add		zl,temporal					;				cer para el clculo de la suma.
		adc		zh,cer						;			Z <-  Tabla7seg + Temp	
		lpm									;			R0 <- ( Z )
		out		portb,r0					;			PORTB <- R0
		cbi		portd,DIGITO1				;			PORTD[1:0] = 0B10;
		sbi		portd,DIGITO0
		ret									;		sino
RepDigitoI:
		mov		temporal,N					
		swap	temporal
		andi	temporal,$F					;			Temp <- DigitoMS(N)
		ldi		zl, low(2*Tabla7Seg)
		ldi		zh, high(2*Tabla7Seg)
		add		zl,temporal
		adc		zh,cer						;			Z <-  Tabla7seg + Temp	
		lpm
		out		portb,r0					;			R0 <- ( Z )
		sbi		portd,DIGITO1				;			PORTB <- R0
		cbi		portd,DIGITO0				;			PORTD[1:0] = 0B01;
		ret									;	end Representa


/*****************************************************************
RUTINA DE CONFIGURACIN DE la ES 
	Configuracin del TIMER1
		;Con una frecuencia de 1Mhz, Prescaler 1, modo CTC y 
		;Ocr1a = 5000 obtenemos que el timer se pone a 0 cada 
		; 5000 x 1 us x 1 = 5ms  
		NO OLVIDAR ESCRIBIR PRIMERO EN LA PARTE ALTA 5000 = $1388
		Registros usados:
		-OCCR1AH, OCCR1AL
		-TCCRIB
			-----------------------------------------------------
			| 0  |  0  |  0  |  0  | WGM12 | CS12 | CS11 | CS10 |
			-----------------------------------------------------
				WGM12 =>  1: Modo CTC ; 0: Modo Normal
				CS12:0 => Seleccin del Prescaler
						   --------------------------------
						   | 0  0  0  |  Parada	          |
						   | 0  0  1  |  clk	          |
						   | 0  1  0  |  clk/8            |
						   | 0  1  1  |  clk/64           |
						   | 1  0  0  |  clk/256          |
						   | 1  0  1  |  clk/1024         |
						   | 1  1  0  |  T1 flanco bajada |
						   | 1  1  1  |  T1 flanco subida |
						   --------------------------------
		- TCNT1H,TCNT1L
		- TIMSK1
			----------------------------------------------------------
			| -  |  -  |  0  |  -  |  -  |  -  |  0  | OCIE1 | TOIE1 |
			----------------------------------------------------------	
				OCIE1: Output compare interrupt enable
						0: Disable
						1: Enable
				TOIE1: Timer overflow interrupt enable
						0: Disable
						1: Enable
	-Configuracin de los puertos
		DDRB (Registro de direccin del PORTB) Todo salida
		DDRD [1:0] Salidas de activacin de los displays

	PSEUDOCDIGO:
	sub ConfiguraES
		DDRB <- $FF		;Puerto B como salida
		DDRD <- $3      ;Pines 1 y 0 del puerto D como salidas
		OCR1A <- 5000	;Lmite de comparacin en 5000   
		TCCR1B <- 9 	;Prescaler 1 y modo CTC
		TCNT1 <- 0		;Contador a 0
		TIMSK1 <- 2		;Habilitacin de la interrupcin por comparacin
		I <- 1			;Habilitar interrupcin global
		AUX <- 0		;Inicializa la variable Aux
		CERO <- 0 		;Variable a 0
	fin ConfiguraES
******************************************************************/

ConfiguraES:

		ldi		temporal,$ff
		out		ddrb,temporal	;Puerto B como salida

		ldi		temporal, $3
		out		ddrd,temporal	;Puertos D[1:0] como salidas

		ldi		temporal, $13
		sts		ocr1ah,temporal
		ldi		temporal, $88
		sts		ocr1al,temporal	;ocr1a = 5000

		ldi		temporal, 0b00001001 ; PPrescaler a 1 y modo CTC
	;	ldi		temporal, 0b00001001 ; Para depuracin Prescaler a 1 y modo CTC
		sts		tccr1b,temporal

	
	
		ldi		temporal,0
		sts		tcnt1h,temporal
		sts		tcnt1l,temporal		;Tcnt1 = 0


		ldi		temporal,2
		sts		timsk1,temporal	;Habilita interrupcin del timer

		sei			;Habilita la generacin de interrupciones.


		clr		aux		;Inicializar variables
		clr		cer

		ret		


/**************************************************
	Rutina de interrupcin

	Pseudocdigo:
		subint IntTimer1
			STACK <- SREG
			Representa()
			Aux <-  Aux +1
			SREG <- STACK
		end IntTimer1

**************************************************/

IntTimer1:							; subint IntTimer1
		in		temporal,sreg		;	STACK <- SREG
		push	temporal
		rcall	Representa			;	Representa()

FinInt: inc		aux					;	Aux <- Aux+1
		pop		temporal			;	SREG <- STACK
		out		sreg,temporal		
		reti						; end IntTimer1


;******************************************************

Inicializacion:
		ldi		N, $23		;Mete en BCD el nmero 23
		ret



;***********************************************************

Tabla7Seg: .db CERO,UNO,DOS,TRES,CUATRO,CINCO,SEIS,SIETE,OCHO,NUEVE




