/*
  Autor: Alberto J. Molina
  Última modificación: 10-5-16

Se desea diseñar un sistema basado en el ATMega328P trabajando con un reloj a la
frecuencia de 1 Mhz. El micro recibe los datos de un sensor de temperatura que
 tiene conectado en los pines del puerto B, dichos datos están codificados 
mediante dos dígitos BCD, por lo que se utilizarán todos los pines del puerto. 
Se debe visualizar el valor de la temperatura cada 10sg. La visualización se 
realizará mediante 8 diodos LED conectados a los pines del puerto C en binario. 
a) Escriba la rutina de E/S que configura adecuadamente puertos y temporizador. 
El temporizador se manejará por interrupciones, se configurará para que genere
 una interrupción cada segundo.
b) Escriba el programa principal. Dicho programa llamará a las subrutinas 
ConfiguraES y Representa en el caso de que hayan transcurrido los 10sg, lo que 
detectatrá tras la consulta de la variable contador.
c) Escriba la rutina de interrupción. Esta rutina se encargará de incrementar 
adecuadamente la variable contador que nos permitirá saber cuando han
 transcurrido los 10sg.

  ___________________________________________________________________-
*/



	.include "m328pdef.inc"


	.def	temporal=r16
	.def 	contador=r17
	.def	inp = r18
	.def	res = r19
	.def	diez = r20

/*Vectores de interrupción y de reset*/

	.org	0
	jmp	Reset
	.org	$16	
	jmp	IntTimer1

/******************************************************************
Pseudocódigo del programa principal
	ConfiguraES();
	contador<-0
	hacer
		si (contador == 10)
			contador<-0;
			in <- pinb;
			res <- BCD2bin(in);
			portc<-res;	
		fsi

	mientras(1);	


Subrutina BCD2bin
	res <- inp[7:4] x 10
	res <- res + inp[3:0]
fin	BCD2bin

La suburutina hay que desarrollarla algo más para poder implementarla 
en ensamblador.

          7   6   5   4     3   2   1   0
	-----------------------------------
inp	|      BCD1     ||      BCD0      |
	-----------------------------------

Para realizar la operación: res <- inp[7:4] x 10 + inp[3:0]
primero veamos como generar el primer sumando: inp[7:4] x 10

	diez <-10
	res <- inp
	res[7:4]<->res[3:0]    ;Cambiamos el orden 

          7   6   5   4     3   2   1   0
	-----------------------------------
res	|      BCD0     ||      BCD1      |
	-----------------------------------

	res <- res & $0f   	;Ponemos a 0 los cuatro bits más significativos

          7   6   5   4     3   2   1   0
	-----------------------------------
res	| 0   0   0   0 ||      BCD1      |
	-----------------------------------

	Ahora multiplicamos (como máximo el resutlado es 90)

	r1:r0 <- res x diez

	Como tanto res y diez tiene cuatro bits, el producto tiene sólo
	8 bits útiles que se guardan en el registro r0. El registro r1
	es 0

	res <-r0

	Ahora sumamos el número BCD0 que está en inp, pero para ello
	primero tenemos que eliminar sus cuatro bits más significativos.

	inp <- inp & $0F

	res <- res + inp
********************************************************************/

Reset:	
	rcall  	ConfiguraES	;ConfiguraES();
	clr	contador	;contador<-0
bucle:				;hacer
	cpi	contador,10	;	si (contador == 10)
	brne	bucle
	clr	contador	;		contador<-0;
	in	inp,pinb	;		inp <- pinb;
	call	BCD2bin		;		res <- BCD2bin(inp);
	out	res,portc	;		portc<-res;	
				;	fsi
	jmp	bucle		;mientras(1);	

BCD2bin:			;Subrutina BCD2bin
	ldi 	diez,10		;	diez<-10
	mov	res,inp		;	res <-inp
	swap	res		;	res[7:4]<->res[3:0]
	andi	res,$0f		;	res <- res & $0F
	mul	res,diez	;	r1:r0 <- res x diez
	mov	res,r0		;	res <- r0
	andi	inp,$0f		;	inp <- inp & $0F
	add	res,inp		;	res <- res + inp
	ret			;fin	BCD2bin
		
Programa:
	

Fin:	rjmp	Fin			;FIN



/*****************************************************************
RUTINA DE CONFIGURACIÓN DEL TIMER1
		;Con una frecuencia de 1Mhz, Prescaler 64, modo CTC y 
		;Ocr1a = 15625 obtenemos que el timer se pone a 0 cada 
		; 15625 x 64 us x 1 = 1s  
		NO OLVIDAR ESCRIBIR PRIMERO EN LA PARTE ALTA 5000 = $1388
		Registros usados:
		-OCCR1AH, OCCR1AL
		-TCCRIB
			-----------------------------------------------------
			| 0  |  0  |  0  |  0  | WGM12 | CS12 | CS11 | CS10 |
			-----------------------------------------------------
				WGM12 =>  1: Modo CTC ; 0: Modo Normal
				CS12:0 => Selección del Prescaler
						   --------------------------------
						   | 0  0  0  |  Parada	          |
						   | 0  0  1  |  clk	          |
						   | 0  1  0  |  clk/8            |
						   | 0  1  1  |  clk/64           |
						   | 1  0  0  |  clk/256          |
						   | 1  0  1  |  clk/1024         |
						   | 1  1  0  |  T1 flanco bajada |
						   | 1  1  1  |  T1 flanco subida |
						   --------------------------------
		- TCNT1H,TCNT1L
		- TIMSK1
			----------------------------------------------------------
			| -  |  -  |  0  |  -  |  -  |  -  |  0  | OCIE1 | TOIE1 |
			----------------------------------------------------------	
				OCIE1: Output compare interrupt enable
						0: Disable
						1: Enable
				TOIE1: Timer overflow interrupt enable
						0: Disable
						1: Enable

	PSEUDOCÓDIGO:
	sub ConfiguraES
		DDRB <- $0	;Puerto B como entrada
		DDRC <- $ff	;Puerto C como salida
		OCR1A <- 15625	;Límite de comparación
		TCCR1B <- b 	;Prescaler 64 y modo CTC
		TCNT1 <- 0		;Contador a 0
		TIMSK1 <- 2		;Habilitación de la interrupción por comparación
		I <- 1			;Habilitar interrupción global
		
	fin ConfiguraES
******************************************************************/

ConfiguraES:
		ldi		temporal,0
		out		ddrb,temporal
		ldi		temporal,$ff
		out		ddrc,temporal

		ldi		temporal, high(15625)
		sts		ocr1ah,temporal
		ldi		temporal, low(15625)
		sts		ocr1al,temporal

		ldi		temporal, 0b00001011 ; PPrescaler a 64 y modo CTC
		sts		tccr1b,temporal
		ldi		temporal,0
		sts		tcnt1h,temporal
		sts		tcnt1l,temporal	;Tcnt1 = 0

		ldi		temporal,2
		sts		timsk1,temporal	;Habilita interrupción del timer

		sei		;Habilita la generación de interrupciones.



		ret		



;****************************************************************
/*
	RUTINA DE INTERRUPCIÓN
		Tan sólo guarda el registro en pila y lo restaura
		No tiene otra tarea asociada
																 */
;****************************************************************

IntTimer1:	in	temporal,sreg
		push	temporal

FinInt:		inc	contador

		pop	temporal
		out	sreg,temporal		
		reti



/***************************************************************
NOTA IMPORTANTE: Para la simulación con AVRSTUDIO no olvidéis
cambiar el dispositivo a simular dentro del entorno.
	
	Menú Debug->Select Platform and Device
****************************************************************/
