/*------------------------------------------------------------------------------
;Autor: Alberto J. Molina
;Última modificación: 8-5-16
;
;Para ahuyentar a los pájaros que se posan en la barandilla del balcón, se ha
;ideado un molinillo electrónico que permite rotar sus aspas cuando su entrada M
; está a 1 lógico. El funcionamiento del molinillo debe ser como se describe a 
;continuación:
;
;Si es de noche, el molinillo deberá estar parado.
;
;Si es de día, el molinillo deberá mover sus aspas durante 15 segundos, y después,
;durante otros 15 segundos, deberán estar quietas. Dicho ciclo se repite hasta la 
;noche.
;
;Para controlar el funcionamiento del molinillo, se utilizará un Atmega328p y un 
;sensor de día/noche, que se conecta al pin PB0. El sensor día/noche emite un 1 
;cuando es de día y un 0 cuando es de noche. Por otro lado, la salida PB1 del 
;microcontrolador, se conecta a la entrada M del molinillo.  Elabore:
;
;a) Una subrutina que permita la configuración de los pines de entrada/salida del 
;microcontrolador. 
;
;b) Una subrutina que permita configurar el timer para que genere interrupciones 
;cada 1s, sabiendo que la frecuencia de reloj del Atmega328p es de fclk = 1Mhz.
;
;c) Una rutina de interrupción, debidamente instalada, que produzca el incremento 
;de una variable Tiempo que se encuentra en el registro R16.
;
;d) El programa principal que permita el funcionamiento descrito en el enunciado y 
;proporcione la estructura general del fichero .asm
;
;------------------------------------------------------------------------------
*/





/*************************************************************
	Incluimos un fichero de cabecera u otro dependiendo de si
	se ha definido el símbolo atmega328pa o no.
***************************************************************/
	.include "m328pdef.inc"


	.def 	tiempo = r16
	.def	temporal=r17
	.def	mill_on=r18


/*************************************************************/
/*  Vectores de reset e interrupción 			     */
/*************************************************************/

		.org	0
		jmp		Reset
		.org	$16	
		jmp		IntTimer1
			


/***********************************************************
Pseudocódigo del programa principal

	ConfiguraES();
	ConfiguraTimer();  
	tiempo <- 0; 
	mill_on <- 0; //Variable para saber si el molinillo está activo o no
	hacer	      //Bucle infinito
		si ( PB[0] == 1)   //Si es de dia
			si (tiempo >=15)
				mill_on <- !mill_on;
				tiempo <-0;
			fsi	
		sino
			mill_on <-0
		fsi
		PB[1] <- mill_on
	mientras(1)

NOTA: La variable tiempo se incrementa cada segundo por la rutina de 
interrupción.
************************************************************/



Reset:	
		rcall  ConfiguraES	;Configuramos la ES
		rcall  ConfiguraTimer   ;Configuramos el Timer
		
		clr	tiempo		;tiempo <- 0 
		clr 	mill_on		;mill_on <-0
		cbi    portb,0 ; desactivar molinillo
	loop:				;hacer	      //Bucle infinito
		sbis 	pinb,0		;si ( PB[0] == 1) ver si es de día
		jmp	noche
		cpi	tiempo,15	;	si (tiempo >=15)
		brcc	loop
		not	mill_on		;		mill_on <- !mill_on;
		clr	tiempo		;		tiempo <-0;
			
		sbrs 	mill_on,0
		rjmp    poner0
		sbi	portb,1
		jmp	loop
	poner0:	cbi	potb,0		;PB[1] <- mill_on
		jmp	loop		;mientras(1)
	noche: clr tiempo
		rjmp loop
	
/*
NOTA: La variable mill_on puede tener los valores 000....00 o 1.....111
A la hora de hacer la asignación PB[1] <- mill_on, sólo nos interesa mover
el bit 1 de mill_on
*/

/*****************************************************************
RUTINA DE CONFIGURACIÓN DEL TIMER1
		;Con una frecuencia de 1Mhz, Prescaler 64, modo CTC y 
		;Ocr1a = 15624 obtenemos que el timer se pone a 0 cada 
		; 15625 x 1 us x 16 = 1s  
		NO OLVIDAR ESCRIBIR PRIMERO EN LA PARTE ALTA 
		Registros usados:
		-OCCR1AH, OCCR1AL
		-TCCRIB
			-----------------------------------------------------
			| 0  |  0  |  0  |  0  | WGM12 | CS12 | CS11 | CS10 |
			-----------------------------------------------------
				WGM12 =>  1: Modo CTC ; 0: Modo Normal
				CS12:0 => Selección del Prescaler
						   --------------------------------
						   | 0  0  0  |  Parada	          |
						   | 0  0  1  |  clk	          |
						   | 0  1  0  |  clk/8            |
						   | 0  1  1  |  clk/64           |
						   | 1  0  0  |  clk/256          |
						   | 1  0  1  |  clk/1024         |
						   | 1  1  0  |  T1 flanco bajada |
						   | 1  1  1  |  T1 flanco subida |
						   --------------------------------
		- TCNT1H,TCNT1L
		- TIMSK1
			----------------------------------------------------------
			| -  |  -  |  0  |  -  |  -  |  -  |  0  | OCIE1 | TOIE1 |
			----------------------------------------------------------	
				OCIE1: Output compare interrupt enable
						0: Disable
						1: Enable
				TOIE1: Timer overflow interrupt enable
						0: Disable
						1: Enable

	PSEUDOCÓDIGO:
	sub ConfiguraTimer
		OCR1A <- 15624	;Límite de comparación en 15625   
		TCCR1B <- 11 	;Prescaler 64 y modo CTC
		TCNT1 <- 0		;Contador a 0
		TIMSK1 <- 2		;Habilitación de la interrupción por comparación
		I <- 1			;Habilitar interrupción global
		
	fin ConfiguraTimer
******************************************************************/

ConfiguraTimer: 
		ldi temporal, high(15624)	;OCR1A <- 15624	
		sts occr1ah,temporal
		ldi temporal, low(15624)
		sts occr1al,temporal
		ldi temporal,11			;TCCR1B<-11
		sts tccr1b,temporal
		ldi temporal,0
		sts tcnt1h,temporal
		sts tcnt1l,temporal		;TCNT1 <- 0
		ldi temporal,2
		sts timsk1,temporal		;TIMSK1 <- 2
		sei				;I <- 1
		ret			



/******************************************************************
SUBRUTINA DE CONFIGURACIÓN DE LOS PUERTOS: ConfiguraES
	Se debe configurar el puerto PB0 como entrada y el PB1 como salida
	Inicialmente desactivaremos el molinillo.

sub ConfiguraES
	DDRB<-2;   
	PORTB[1] <-0;
fin ConfiguraES


******************************************************************/

ConfiguraES:	sbi DDRB,1; DDRB<-2;
		cbi DDRB,0; Innecesario porque inicialmente están todos a 0
	   
		cbi PORTB,1; PORTB[1]<-0
		ret

/********************************************************************
	RUTINA DE INTERRUPCIÓN

	Sub IntTimer1
		STACK <- sreg
		tiempo <- tiempo+1
		sreg <- STACK

	fin IntTimer1
																 ************************************************************************/

IntTimer1:					;Sub IntTimer1
		in	temporal,sreg
		push	temporal		;	STACK <- sreg

FinInt:		inc 	tiempo			;	tiempo <- tiempo+1

		pop		temporal	
		out		sreg,temporal	;	sreg <- STACK	
		reti				;fin IntTimer1




