/*
	Autor: Alberto J. Molina
	ltima modificacin: 1-6-11
*/

/*
	En los pines PB7-0 de un microcontrolador AT9mega328p se han conectado 
	diodos luminosos cuyos ctodos estn a tierra y en el pin PD4 se ha 
	conectado el extremo de un pulsador mecnico (cuyo otro extremo se
 	encuentra tirado a tierra) junto con una resistencia de pull-up. 
 	Se desea realizar un programa que permita mostrar a travs de los 
 	diodos el nmero de pulsaciones que se generan en el pulsador. 
 	Qu modificaciones habra que llevar a cabo si no existiese resistencia
  	de pull-up externa?.

*/

	.include "m328pdef.inc"


	#define	ACTIVAPULLUP   ;Poner en comentario si no se desea activar pullup


	.def	temporal = r16
	.def	ContPulsos = r17


	.cseg



Reset:	rcall 	ConfiguraES			; ConfiguraES()
		clr		ContPulsos			; ContPulsos <-0

/****************************************************
		PROGRAMA para detectar y representar
		el nmero de pulsaciones
*****************************************************/

Programa:							;hacer
		sbic	pind,4				; mientras( PD[4] ==1) 
		rjmp	Programa			; fin mientras
		inc		ContPulsos			; ContPulsos <- ContPulsos+1
		rcall	Representa			; Representa()
LiberaTecla:
		sbis	pind,4				; mientras (PD[4] ==0)
		rjmp	LiberaTecla			; fin mientras
		rjmp	Programa			;mientras( VERDADERO)


/*****************************************************************
		SUBRUTINA Representa
******************************************************************/
Representa:
		out		portb,ContPulsos	; Portb<- ContPulsos
		ret

/******************************************************
	Subrutina CONFIGURAES

		DDRD[4]<-0	;PD4 como entrada
		PORTD[4]<- (0)1 ; Si no se necesita PULLUP (s se necesita PULLUP)
		DDRB<- $FF	;PORTB como salida

	fin CONFIGURAES

*******************************************************/

ConfiguraES:
		cbi		ddrd,4					;Configura PD4 como entrada

	#ifdef	ACTIVAPULLUP
		sbi		portd,4
	#else
		cbi		portd,4
	#endif
		ldi		temporal,$ff
		out		ddrb,temporal
		
		ret










