/*
  Autor: Alberto J. Molina
  ltima modificacin: 3-2-11

  Configure el ATmega328pa para que genere interrupciones
  cada 5ms aproximadamente, sabiendo que este microcontrolador dispone de
  un oscilador de cuarzo de 1Mhz. Qu modificaciones deberamos realizar 
  para el Atmega48pa?.

  ___________________________________________________________________-
*/



/*******************************************************

	La siguiente sentencia define el smbolo atmega328p
	Si se desea que el cdigo sirva para el microcontrolador
	Atmega328, se deber quitar las barras de comentario que le
	preceden, en caso contrario el cdigo ser para el Atmega48
*******************************************************/

//	#define atmega328p 




	
	#ifdef atmega328p
		.include "m328pdef.inc"
	#else
		.include "m48pdef.inc"
	#endif	
/*************************************************************
	Incluimos un fichero de cabecera u otro dependiendo de si
	se ha definido el smbolo atmega328pa o no.
***************************************************************/



		.def	temporal=r16


/*************************************************************
	Existen dos diferencias fundamentales para la programacin
	de interrupciones en el ATMEGA48P o el ATMEGA328P

	1) Para el primer dispositivo, el vector de interrupcin es 
	el $B en lugar del $16

	2) Para el primer dispositivo, la instruccin de salto es
	RJMP, mientras que para el segundo JMP

	No olvidemos el vector de RESET en la direccin 0
**************************************************************/		

	#ifdef atmega328p
		.org	0
		jmp		Reset
		.org	$16	
		jmp		IntTimer1
	#else
		.org	0
		rjmp	Reset
		.org	$B
		rjmp	IntTimer1	
	#endif	
			



Reset:	
		rcall  ConfiguraES	;Configuramos la ES

Programa:
	

Fin:	rjmp	Fin			;FIN



/*****************************************************************
RUTINA DE CONFIGURACIN DEL TIMER1
		;Con una frecuencia de 1Mhz, Prescaler 1, modo CTC y 
		;Ocr1a = 5000 obtenemos que el timer se pone a 0 cada 
		; 5000 x 1 us x 1 = 5ms  
		NO OLVIDAR ESCRIBIR PRIMERO EN LA PARTE ALTA 5000 = $1388
		Registros usados:
		-OCCR1AH, OCCR1AL
		-TCCRIB
			-----------------------------------------------------
			| 0  |  0  |  0  |  0  | WGM12 | CS12 | CS11 | CS10 |
			-----------------------------------------------------
				WGM12 =>  1: Modo CTC ; 0: Modo Normal
				CS12:0 => Seleccin del Prescaler
						   --------------------------------
						   | 0  0  0  |  Parada	          |
						   | 0  0  1  |  clk	          |
						   | 0  1  0  |  clk/8            |
						   | 0  1  1  |  clk/64           |
						   | 1  0  0  |  clk/256          |
						   | 1  0  1  |  clk/1024         |
						   | 1  1  0  |  T1 flanco bajada |
						   | 1  1  1  |  T1 flanco subida |
						   --------------------------------
		- TCNT1H,TCNT1L
		- TIMSK1
			----------------------------------------------------------
			| -  |  -  |  0  |  -  |  -  |  -  |  0  | OCIE1 | TOIE1 |
			----------------------------------------------------------	
				OCIE1: Output compare interrupt enable
						0: Disable
						1: Enable
				TOIE1: Timer overflow interrupt enable
						0: Disable
						1: Enable

	PSEUDOCDIGO:
	sub ConfiguraES
		DDRB <- $FF		;Puerto B como salida
		DDRD <- $3      ;Pines 1 y 0 del puerto D como salidas
		OCR1A <- 5000	;Lmite de comparacin en 5000   
		TCCR1B <- 9 	;Prescaler 1 y modo CTC
		TCNT1 <- 0		;Contador a 0
		TIMSK1 <- 2		;Habilitacin de la interrupcin por comparacin
		I <- 1			;Habilitar interrupcin global
		
	fin ConfiguraES
******************************************************************/

ConfiguraES:
		ldi		temporal, $13
		sts		ocr1ah,temporal
		ldi		temporal, $88
		sts		ocr1al,temporal	;ocr1a = 5000

		ldi		temporal, 0b00001001 ; PPrescaler a 1 y modo CTC
	;	ldi		temporal, 0b00001001 ; Para depuracin Prescaler a 1 y modo CTC
		sts		tccr1b,temporal

		
	
		ldi		temporal,0
		sts		tcnt1h,temporal
		sts		tcnt1l,temporal	;Tcnt1 = 0


		ldi		temporal,2
		sts		timsk1,temporal	;Habilita interrupcin del timer

		sei						;Habilita la generacin de interrupciones.



		ret		



/*
	Autor: Alberto J. Molina
	ltima modificacin: 1-6-11
*/

;****************************************************************
/*
	RUTINA DE INTERRUPCIN
		Tan slo guarda el registro en pila y lo restaura
		No tiene otra tarea asociada
																 */
;****************************************************************

IntTimer1:	
		in		temporal,sreg
		push	temporal

FinInt:

		pop		temporal
		out		sreg,temporal		
		reti



/***************************************************************
NOTA IMPORTANTE: Para la simulacin con AVRSTUDIO no olvidis
cambiar el dispositivo a simular dentro del entorno.
	
	Men Debug->Select Platform and Device
****************************************************************/
