
/*
	Autor: Alberto J. Molina
	ltima modificacin: 1-6-11
*/


;A partir de la direccin $100 se han almacenado, consecutivamente, 
;16 bytes de datos. Se pide la realizacin de un programa que obtenga 
;el nmero de bits a 1 lgico que se encuentran en dichos 16 bytes, 
;y lo almacene en el registro R16. Como paso previo a la realizacin 
;del programa, se debe realizar una subrutina que permita obtener el 
;nmero de bits a 1 existentes en el registro R1, y almacenar el 
;resultado en el registro R2. El programa principal debe usar, 
;obligatoriamente, dicha subrutina. 
;
;
;

/**************************************************************
			PSEUDOCODIGO


	X<- Tabla
	i<-0
	Suma <- 0
	hacer
		temp<- (X)
		X<- X+1
		Suma <- Suma + Contar1s(temp)
		i<- i+1
	mientras ( i< 16)


	subrutina Contar1s 

		j<- 0
		contador<-0
		hacer
			si(temp[0]==0)
				contador<-contador+1
			fsi
			temp>>=1
			j<- j+1
		mientras(j<8)

	end subrutina


*************************************************************/

	.include "m328pdef.inc"

	.equ Tam=16

	.def Suma = r2
	.def contador=r3

	.def i=r16
	.def j=r17
	.def temp=r18

	.cseg

Main:	rcall	IniciaTabla   ;Para depuracin


/******************************************

	PROGRAMA PRINCIPAL


*******************************************/

Programa: 
		clr		Suma			;	Suma<-0
		clr		i				;	i<-0
		ldi		xl,low(Tabla)	;
		ldi		xh,high(Tabla)	;	X<- Tabla
Bucle:	ld		temp,X+			;	hacer
								;		temp <- (X) ; X<-X+1
		rcall	Contar1s		;		contador <- Contar1s(temp)
		add		Suma,contador	;		Suma <- Suma + contador
		inc		i				;		i<-i+1
		cpi		i,Tam			;		
		brne	Bucle			;	mientras(i<16)
		sts		Resultado,Suma	;	Resultado<- Suma
		
Fin:	rjmp	fin				;	fin

/*********************************************
	Subrutina Contar1s
*********************************************/

Contar1s:						;	sub Contar1s
		clr		j				;		j<-0
		clr		contador		;		contador<-0
BucleContar1s:					;		hacer
		lsr		temp			;					(el desplazamiento introduce un bit en C)
		brcc	SigueContar1s	;			si(temp[j]==1)
		inc		contador		;				contador<-contador+1
SigueContar1s:					;			fsi
		inc		j				;			j<-j+1
		cpi		j,8				;
		brne	BucleContar1s	;		mientras(j<8)
		ret						;	fin Contar1s

;**********************************************
; Para depuracin
IniciaTabla:
	ldi		zl,low(2*TablaI)
	ldi		zh,high(2*TablaI)
	ldi		xl,low(Tabla)
	ldi		xh,high(Tabla)
	clr		i
BuITabla:
	lpm		r0,z+
	st		x+,r0
	inc		i
	cpi		i,Tam
	brne	BuITabla
	ret	

	.dseg
	.org $100
Tabla:	.byte Tam
Resultado: .byte 1
	


	.cseg
TablaI:  .db $99, $10, $20, $40, 0, $10, $ff, 0,$f,0,0,0,0,0,0,0
