;Apartado a)
;Realice una subrutina para el ATmega328P llamada PRODUCTO, que tome como 
;entrada un número positivo de 8 bits en R0 y otro número positivo de 32 bits en
;R19:R18:R17:R16 y realice el producto de ambos números devolviéndolo en los 
;registros R19:R18:R17:R16. Al terminar, la subrutina no debe alterar el valor de R0 
;ni tampoco el valor de cualquier otro registro de propósito general que haya 
;necesitado usar. Se recomienda que emplee el algoritmo de sumas sucesivas para hacer 
;la multiplicación y que no tenga en cuenta problemas de desbordamiento. 
;
;
; Pseudocódigo
;
; Subrutina PRODUCTO 
;	PILA <- temp
;	PILA <- Res   ; Res debe ser 32 bits
;	
;	Res <- 0
	temp<-R0
;	mientras  temp!=0
;		Res<- Res+ (R19:R18:R17:R16)
;		temp<-temp-1
;	fin mientras
;	
;	 (R19:R18:R17:R16) <- Res
;
;	Res<-PILA
	temp<-PILA
;
; Fin PRODUCTO
;
;

	.def Res0 =r1;
	.def Res1 =r2;
	.def Res2 =r3;
	.def Res3 =r4;

	.def temp = r16;

PRODUCTO:	
		push Res0	
		push Res1
		push Res2
		push Res3	;PILA <- Res
	
		push temp	;temp
		mov temp,r0	;temp<-r0

		clr Res0
		clr Res1
		clr Res2
		clr Res3	;Res<-0


	mient: 	cpi temp,0	;mientras R0!=0
		breq finmient
				
		add Res0,r16
		adc Res1,r17
		adc Res2,r18
		adc Res3,r19	;Res <- Res + (R19:...R16)		

		dec temp	;temp<-temp-1
		jmp mient

finmient:  mov r16,Res0
		mov r17,Res1
		mov r18,Res2
		mov r19,Res3    ;(R19:R18:R17:R16) <- Res

		pop temp	;temp<-PILA

		pop Res3
		pop Res2
		pop Res1
		pop Res0    	;Res<-PILA

	
		

		ret



;b) Realice una subrutina para el Atmega328P llamada FACTORIAL que tomando como entrada un número en R0, positivo, menor que 13, calcule su factorial y lo devuelva en los registros R19:R18:R17:R16. Tenga en cuenta que 12! es 12*11*...*2*1 = 479001600, que es un número que necesita 4 bytes para ser almacenado. Al terminar, la subrutina no debe alterar el valor de R0 ni tampoco el valor de cualquier otro registro de propósito general que haya necesitado usar. Se recomienda que la subrutina FACTORIAL haga uso de la subrutina PRODUCTO para realizar las multiplicaciones que necesita hacer para hallar el factorial de R0.


; Pseudocódigo
;
; Subrutina FACTORIAL 
;	PILA <- temp
;	PILA <- R0
;
;	Res <- 1    ;Res debe ser R19:....R16 32 bits en total
;	temp<-r0
;	mientras temp>1
;		Res <- PRODUCTO(Res, R0 )
;		temp<-temp-1
;		R0 <- temp
;	fin mientras
;	R0 <- PILA			
;	temp<-PILA
;
; Fin FACTORIAL
;
;
FACTORIAL:	push temp
		push R0	
		
		ldi Res0,1
		clr Res1
		clr Res2
		clr Res3

		mov temp,r0

	mient2: cpi temp,2
		brlo finmient2
		call PRODUCTO	
		dec temp
		mov r0,temp
		jmp mient2
	finmient2:
	

		pop  R0
		pop  temp
		ret












