// Diseño:		votador
// Archivo:		votador-f.v
// Descripción: Simulación con banco de pruebas (test bench)
// Autor:		Jorge Juan <jjchico@gmail.com>
// Fecha:		10-11-2009

////////////////////////////////////////////////////////////////////////////////
//          curso_verilog.v - Curso práctico de iniciación a Verilog          //
//                                                                            //
// Copyright 2009,2010 Jorge Juan <jjchico@gmail.com>                         //
//                                                                            //
// Este archivo es parte de curso_verilog.v. curso_verilog.v es software      //
// libre: puede redistribuirlo y/o modificarlo bajo los términos de la        //
// Licencia General Pública de GNU publicada por la Fundación de Software     //
// Libre, tanto su versión 3 como, opcionalmente, cualquier otra versión      //
// posterior.                                                                 //
//                                                                            //
// Debe haber recibido una copia de la Licencia General Pública de GNU junto  //
// con curso_verilog.v. Si no es así, véase <http://www.gnu.org/licenses/>.   //
//                                                                            //
//                          **** **** **** ****                               //
//                                                                            //
// This file is part of curso_verilog.v. curso_verilog.v is free software:    //
// you can redistribute it and/or modify it under the terms of the GNU        //
// General Public License as published by the Free Software Foundation,       //
// either version 3 of the License, or (at your option) any later version.    //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with curso_verilog.v.  If not, see <http://www.gnu.org/licenses/>.   //
////////////////////////////////////////////////////////////////////////////////

/*
   Lección 2-2: Simulación con banco de pruebas

   En este archivo realizaremos el mismo circuito votador pero mediante una
   descripción funcional. Más adelante compararemos el resultado de simular
   esta descripción con la descripción procedimental en votador.v.

   En general, una descripción funcional es más cercana a la implementación
   final, es más facilmente sintetizable y permite una simulación más
   eficiente, pero requiere un trabajo previo por parte del diseñador, por lo
   que suele emplearse para casos sencillos o para aquellos problemas que de
   forma natural presentan una descripción funcional sencilla.
*/

// Definimos la escala de tiempo para el simulador
`timescale 1ns / 1ps

/* Llamamos a este módulo "votador_f" para distinguirlo de la versión
 * procedimental llamada "votador" */
module votador_f(
	output v,
	input a,
	input b,
	input c
	);

	/* Describimos la función mediante una estructura "assign". Incluimos un
	 * retraso de 2ns para obtener resultados de simulación más realistas. A
	 * la vista de la expresión es fácil observar que la salida del circuito
	 * valdrá "1" cuando dos entradas cuales quiera sean "1". */
	assign #2 v = a&b | a&c | b&c;

endmodule	// votador_f

/*
   EJERCICIO

   1. Comprueba que el archivo no tiene errores copilándolo con:
	$ iverilog votador-f.v

   La lección sigue en el archivo votador_tb-2.v.
*/
