// Diseño:		alarma
// Archivo:		alarma.v
// Descripción:	Alarma sencilla para un automovil
// Autor:		Jorge Juan <jjchico@gmail.com>
// Fecha:		09/11/2009

////////////////////////////////////////////////////////////////////////////////
//          curso_verilog.v - Curso práctico de iniciación a Verilog          //
//                                                                            //
// Copyright 2009,2010 Jorge Juan <jjchico@gmail.com>                         //
//                                                                            //
// Este archivo es parte de curso_verilog.v. curso_verilog.v es software      //
// libre: puede redistribuirlo y/o modificarlo bajo los términos de la        //
// Licencia General Pública de GNU publicada por la Fundación de Software     //
// Libre, tanto su versión 3 como, opcionalmente, cualquier otra versión      //
// posterior.                                                                 //
//                                                                            //
// Debe haber recibido una copia de la Licencia General Pública de GNU junto  //
// con curso_verilog.v. Si no es así, véase <http://www.gnu.org/licenses/>.   //
//                                                                            //
//                          **** **** **** ****                               //
//                                                                            //
// This file is part of curso_verilog.v. curso_verilog.v is free software:    //
// you can redistribute it and/or modify it under the terms of the GNU        //
// General Public License as published by the Free Software Foundation,       //
// either version 3 of the License, or (at your option) any later version.    //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with curso_verilog.v.  If not, see <http://www.gnu.org/licenses/>.   //
////////////////////////////////////////////////////////////////////////////////

/*
   Lección 3-3: Ejemplos combinacionales. Alarma de automovil.

   Este archivo contiene una posible solución al siguiente problema:
	
   Diseñe un circuito de alarma de coche de dos puertas de tal forma que 
   suene la alarma cuando:
     * Las puertas estén cerradas, el motor apagado y se abra el maletero.
     * El motor esté encendido, las puertas cerradas y el maletero abierto.
     * El freno de mano quitado, el motor encendido y algunas de las puertas
       abiertas.
   Añada una entrada que permita desactivar la alarma.

   El archivo alarma_tb.v contiene el banco de pruebas para el test de este
   diseño.
	
   En esta lección se practican, entre otros, los siguientes conceptos:
	
     - Asignaciones continuas implícitas
     - Lista de sensibilidad "@*"
     - Señales de múltiples bits (vectores)
     - Generación de patrones de test mediante un contador
*/

`timescale 1ns / 1ps

/* Definimos el módulo con una entrada para cada elemento que puede afectar
 * al estado de la alarma */
module alarma(
	input c,	// control de la alarma. 0-desconectada, 1-conectada
	input p1,	// primera puerta. 0-cerrada, 1-abierta
	input p2,	// segunda puerta
	input t,	// estado del motor. 0-apagado, 1-encendido
	input m,	// estado del maletero. 0-cerrado, 1-abierto
	input f,	// estado del freno de mano. 0-quitado, 1-puesto
	output a	// estado de la alarma. 0-no suena, 1-suena
	);

	/* Declaramos la salida como "reg" ya que se va a generar en un bloque
	 * always. */
	reg a;

	/* Definimos una señal auxiliar que indica cuando alguna de las puertas
	 * está abierta. Esto facilita el procedimiento posterior. La 
	 * asignación se hace enn la misma definición, por lo que es una
	 * asignación continua implícita (assign). */
	wire p = p1 | p2;	// p=0: todas las puertas cerradas
				// p=1: alguna puerta abierta

	/* La función se describe de forma procedimental en un bloque "always".
	 * La construcción "@*" indica que se incluyan todas las variables
	 * presentes en el bloque en la lista de sensibilidad con objeto de
	 * obtener una implementación combinacional. De esta forma se evitan
	 * errores en caso de olvidar incluir alguna variable. En este caso es
	 * equivalente a "@(c,p,t,m,f)". */
	always @*
	begin
		a = 0;	// valor por defecto de a
		if (c)	// c=1. Alarma conectada
			if (!p && !t && m)	// primera condición
				a = 1;
			else if (t && !p && m)	// segunda condición
				a = 1;
			else if (!f && t && p)	// tercera condición
				a = 1;
		else	// c=0. Alarma desconectada
			a = 0;
	end

endmodule	// alarma

/*
   La lección continúa en el archivo alarma_tb.v
*/
