// Diseño:  ejemplos
// Archivo:  ejemplos.v
// Descripción: Varios ejemplos combinacionales en Verilog
// Autor:  Jorge Juan <jjchico@gmail.com>
// Fecha:  09/11/2009

////////////////////////////////////////////////////////////////////////////////
//          curso_verilog.v - Curso práctico de iniciación a Verilog          //
//                                                                            //
// Copyright 2009,2010 Jorge Juan <jjchico@gmail.com>                         //
//                                                                            //
// Este archivo es parte de curso_verilog.v. curso_verilog.v es software      //
// libre: puede redistribuirlo y/o modificarlo bajo los términos de la        //
// Licencia General Pública de GNU publicada por la Fundación de Software     //
// Libre, tanto su versión 3 como, opcionalmente, cualquier otra versión      //
// posterior.                                                                 //
//                                                                            //
// Debe haber recibido una copia de la Licencia General Pública de GNU junto  //
// con curso_verilog.v. Si no es así, véase <http://www.gnu.org/licenses/>.   //
//                                                                            //
//                          **** **** **** ****                               //
//                                                                            //
// This file is part of curso_verilog.v. curso_verilog.v is free software:    //
// you can redistribute it and/or modify it under the terms of the GNU        //
// General Public License as published by the Free Software Foundation,       //
// either version 3 of the License, or (at your option) any later version.    //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with curso_verilog.v.  If not, see <http://www.gnu.org/licenses/>.   //
////////////////////////////////////////////////////////////////////////////////

/*
   Unidad 3: Ejemplos combinacionales

   En esta unidad veremos algunos ejemplos de resolución de problemas y
   aplicaciones de Verilog con circuitos combinacionales. Con los ejemplos
   se introducirán algunos conceptos nuevos de Verilog y algunas alternativas
   a las formas de descripción y realización de bancos de pruebas vistos en
   lecciones anteriores.

   Lección 3-1 (florencio.v): implementación mediante un procedimiento (always)
   de una función combinacional compleja. La obtención de una descripción
   funcional es mucho menos intuitiva, por lo que se muestra la utilidad de
   los lenguajes de descripción de hardware para facilitar el proceso de
   diseño.

   Lección 3-2 (azar.v): diseño y simulación de un circuito simple con azares.
   Permite comprobar cómo la introducción de retrasos puede producir
   resultados transitorios no esperados en los circuitos combinacionales.

   Lección 3-3 (alarma.v): diseño de un sencillo sistema de alarma para un
   automovil.
*/

module ejemplos_combinacionales();

	initial
		$display("Ejemplos combinacionales.");

endmodule
