// Diseño:  subsistemas
// Archivo:  unidad_04.v
// Descripción: Ejemplos de subsistemas combinacionales en Verilog
// Autor:  Jorge Juan <jjchico@gmail.com>
// Fecha:  27/11/2009

////////////////////////////////////////////////////////////////////////////////
//          curso_verilog.v - Curso práctico de iniciación a Verilog          //
//                                                                            //
// Copyright 2009,2010 Jorge Juan <jjchico@gmail.com>                         //
//                                                                            //
// Este archivo es parte de curso_verilog.v. curso_verilog.v es software      //
// libre: puede redistribuirlo y/o modificarlo bajo los términos de la        //
// Licencia General Pública de GNU publicada por la Fundación de Software     //
// Libre, tanto su versión 3 como, opcionalmente, cualquier otra versión      //
// posterior.                                                                 //
//                                                                            //
// Debe haber recibido una copia de la Licencia General Pública de GNU junto  //
// con curso_verilog.v. Si no es así, véase <http://www.gnu.org/licenses/>.   //
//                                                                            //
//                          **** **** **** ****                               //
//                                                                            //
// This file is part of curso_verilog.v. curso_verilog.v is free software:    //
// you can redistribute it and/or modify it under the terms of the GNU        //
// General Public License as published by the Free Software Foundation,       //
// either version 3 of the License, or (at your option) any later version.    //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with curso_verilog.v.  If not, see <http://www.gnu.org/licenses/>.   //
////////////////////////////////////////////////////////////////////////////////

/*
   Unidad 4: Subsistemas combinacionales

   Las herramientas de síntesis automática de circuitos digitales emplean
   algoritmos para inferir los elementos de circuito más adecuados
   (decodificadores, multiplexores, comparadores, etc.) a la hora de
   implementar la funcionalidad descrita en un lenguaje de descripción de
   hardware. Para que el proceso sea eficiente, el diseñador debe poner
   especial atención en hacer descripciones simples y compatibles con los
   algoritmos de síntesis. Las descripciones tienen estas características se
   denominan "descripciones sintetizables".

   Se pueden enumerar multitud de criterios y recomendaciones con objeto de que
   una descripción sea sintetizable, pero todos ellos pueden resumirse en la
   siguiente frase:

     Si el diseñador no es capaz de intuir cómo hacer la síntesis de una
     determinada descripción, la herramienta de síntesis, probablemente,
     tampoco.

   Durante el proceso de síntesis, las herramientas informan de los elementos
   que van a emplear para implementar una descripción.

   Esta unidad consta de tres lecciones:

   Lección 4-1 (subsistemas.v): contiene ejemplos de diseño de diferentes
   subsistemas y un banco de pruebas para cada uno de ellos.

   Lección 4-2 (bcd-7.v): contiene la especificación de un convertidor de 
   código BCD a 7 segmentos, el cual debe diseñarse como ejercicio.

   Lección 4-3 (analisis.v): contiene un ejercicio en el que se debe describir
   y simular en Verilog un circuito suministrado como esquema.
*/

module subsistemas_combinacionales();

	initial
		$display("Subsistemas combinacionales.");

endmodule

