// Diseño:		arbitrador
// Archivo:		arbiter_tb.v
// Descripción:		Arbitrador. Ejemplo de máquina de estados
// Autor:		Jorge Juan <jjchico@gmail.com>
// Fecha:		04/06/2010

////////////////////////////////////////////////////////////////////////////////
//          curso_verilog.v - Curso práctico de iniciación a Verilog          //
//                                                                            //
// Copyright 2009,2010 Jorge Juan <jjchico@gmail.com>                         //
//                                                                            //
// Este archivo es parte de curso_verilog.v. curso_verilog.v es software      //
// libre: puede redistribuirlo y/o modificarlo bajo los términos de la        //
// Licencia General Pública de GNU publicada por la Fundación de Software     //
// Libre, tanto su versión 3 como, opcionalmente, cualquier otra versión      //
// posterior.                                                                 //
//                                                                            //
// Debe haber recibido una copia de la Licencia General Pública de GNU junto  //
// con curso_verilog.v. Si no es así, véase <http://www.gnu.org/licenses/>.   //
//                                                                            //
//                          **** **** **** ****                               //
//                                                                            //
// This file is part of curso_verilog.v. curso_verilog.v is free software:    //
// you can redistribute it and/or modify it under the terms of the GNU        //
// General Public License as published by the Free Software Foundation,       //
// either version 3 of the License, or (at your option) any later version.    //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with curso_verilog.v.  If not, see <http://www.gnu.org/licenses/>.   //
////////////////////////////////////////////////////////////////////////////////

/*
   Lección 6-3: Máquinas de estados finitos. Detector de secuencia.

   Banco de pruebas para módulos en secuencia.v. El banco de pruebas
   proporciona una secuencia idéntica a las implementaciones Mealy y Moore
   del detector de secuencia con objeto de poder comparar la salida generada
   por cada tipo de máquina.
*/

`timescale 1ns / 1ps

// Banco de pruebas

module test();

	reg ck = 0;		// reloj
	reg reset = 0;		// reset
	reg x = 0;		// entrada
	wire z_mealy;		// salida Mealy
	wire z_moore;		// salida Moore

	/* El vector 'in' contiene una secuencia de 32 bits que se suministrará
	 * a la entrada. 'n' es el número de bits de la secuencia que se
	 * aplicarán e 'i' actúa como índice. */
	reg [0:31] in = 32'b00100111_00001110_10010010_01010011;
	integer n = 32;
	integer i = 0;

	// Instanciación de módulos
	seq_mealy uut_mealy (ck, reset, x, z_mealy);
	seq_moore uut_moore (ck, reset, x, z_moore);

	// Generación de ondas
	initial begin
		$dumpfile("test.vcd");
		$dumpvars(0, test);
	end

	// Generador de reloj y secuencia de entrada
	always begin
		#10	/* Con el flanco no activo del reloj se actualiza la
			 * entrada, tomada del vector 'in' */
			ck = 0;
			x = in[i];

		#10	/* Tras el flanco activo se actualiza el índice 'i' y
			 * se comprueba si se ha llegado al final de la
			 * secuencia. */
			ck = 1;
			i = i + 1;
			if (i == n)
				$finish;
	end

	// Reset
	/* Un proceso independite controla la señal 'reset'. Se realiza una
	 * iniciación al principio de la simulación y otra durante la
	 * operación del sistema. */
	initial begin
		#5	reset = 1;
		#15	reset = 0;
		#450	reset = 1;
		#20	reset = 0;
	end
endmodule

/*
   EJERCICIOS

   1. Simula el diseño con:

      $ iverilog secuencia.v secuencia_tb.v

      y visualiza los resultados con:

      $ gtkwave test.vcd

      Represente las señales de entrada y salida y los estados internos de
      las máquinas de Mealy y Moore.

   2. Responde y reflexiona sobre las siguientes cuestiones:

      a) ¿Son idénticas las salidas de la máquina de Mealy y Moore?
      b) ¿Es correcta la operación de la máquina de Mealy?
      c) ¿Es correcta la operación de la máquina de Moore?
      d) Explica las diferencias que se aprecian en las salidas de ambas
         máquinas.

   3. Cambia la secuencia de entrada en 'in' y comprueba la operación de
      ambas máquinas con la nueva secuencia.

   4. ¿Qué pasaría si se borra (se comenta) el bloque que controla la señal
      'reset'? Deduce el resultado y luego simúlalo para comprobarlo. ¿Has
      acertado?
*/
