// Diseño:		Registro universal
// Archivo:		register_tb.v
// Descripción:		Registro universal
// Autor:		Jorge Juan <jjchico@gmail.com>
// Fecha:		11/06/2010

////////////////////////////////////////////////////////////////////////////////
//          curso_verilog.v - Curso práctico de iniciación a Verilog          //
//                                                                            //
// Copyright 2009,2010 Jorge Juan <jjchico@gmail.com>                         //
//                                                                            //
// Este archivo es parte de curso_verilog.v. curso_verilog.v es software      //
// libre: puede redistribuirlo y/o modificarlo bajo los términos de la        //
// Licencia General Pública de GNU publicada por la Fundación de Software     //
// Libre, tanto su versión 3 como, opcionalmente, cualquier otra versión      //
// posterior.                                                                 //
//                                                                            //
// Debe haber recibido una copia de la Licencia General Pública de GNU junto  //
// con curso_verilog.v. Si no es así, véase <http://www.gnu.org/licenses/>.   //
//                                                                            //
//                          **** **** **** ****                               //
//                                                                            //
// This file is part of curso_verilog.v. curso_verilog.v is free software:    //
// you can redistribute it and/or modify it under the terms of the GNU        //
// General Public License as published by the Free Software Foundation,       //
// either version 3 of the License, or (at your option) any later version.    //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with curso_verilog.v.  If not, see <http://www.gnu.org/licenses/>.   //
////////////////////////////////////////////////////////////////////////////////

/*
   Lección 7-2: Contador reversible.

   Este archivo contiene un banco de pruebas para el contador diseñado en
   counter.v.

   En este archivo se introduce el uso de la directiva "repeat" y el control
   temporal (@) para el control de señales en bancos de pruebas.
*/

`timescale 1ns / 1ps

// Banco de pruebas

module test();

	reg ck = 0;		// reloj
	reg cl = 0;		// puesta a cero
	reg en = 0;		// habilitación
	reg ud = 0;		// cuenta hacia arriba (0) o abajo (1)
	wire [3:0] q;		// estado de cuenta
	wire c;			// señal de fin de cuenta

	counter #(4) uut (.ck(ck), .cl(cl), .en(en), .ud(ud), .q(q), .c(c));

	// Salidas y control de la simulación
	initial	begin
		// Generamos formas de onda para visualización posterior
		$dumpfile("test.vcd");
		$dumpvars(0, test);

		/* En esta ocasión no generamos salidas en formato texto */
	end

	// Señal de reloj periódica
	/* El reloj cambia con un perior de 20ns */
	always
		#10 ck = ~ck;

	// Entradas
	initial begin
		@(negedge ck)
		cl = 1;				// puesta a cero
		@(negedge ck)
		cl = 0;				// contamos hacia arriba
		en = 1;				// durante 20 ciclos
		repeat(20) @(negedge ck);
		ud = 1;				// contamos hacia abajo 8 ciclos
		repeat(8) @(negedge ck);
		en = 0;				// puesta a cero
		cl = 1;
		@(negedge ck);
		cl = 0;
		repeat(2) @(negedge ck);
		$finish;
	end

endmodule // test


/*
   EJERCICIOS

   1. Compila y simula los ejemplos con:

      $ iverilog counter.v counter_tb.v
      $ vvp a.out

   2. Visualiza los resultados y comprueba la salida con:

      $ gtkwave test.vcd

   3. Modifica el diseño para incorporar una señal 'load' que carge un estado
      de cuenta de una entrada 'x'. La operación de carga debe terner más
      prioridad que las operaciones de cuenta pero menos que la puesta a cero.

   4. Modifique el diseño original para obtener un contador módulo 10 (de 0 a 9).
      Debes poner cuidado con las señales de fin de cuenta.
*/
