// Diseño:		votador5
// Archivo:		votador5.v
// Descripción: Votador 5 entradas
// Autor:		Jorge Juan <jjchico@gmail.com>
// Fecha:		13-11-2009

//	curso_verilog.v - Curso práctico de iniciación a Verilog
//
//	Copyright 2009 Jorge Juan <jjchico@gmail.com>
//
//	Este archivo es parte de curso_verilog.v.
//	
//	curso_verilog.v es software libre: puede redistribuirlo y/o modificarlo
//	bajo los términos de la Licencia General Pública de GNU publicada por
//	la Fundación de Software Libre, tanto su versión 3 como, opcionalmente,
//	cualquier otra versión posterior.
//	
//	curso_verilog.v se distribuye con el propósito de que sea útil, pero SIN
//	NINGUNA GARANTÍA, incluyendo la garantía implícita de COMERCIABILIDAD o
//	de ADECUACIÓN A UN PROPÓSITO EN PARTICULAR. Véase la Licencia General
//	Pública de GNU para más detalles.
//	
//	Debe haber recibido una copia de la Licencia General Pública de GNU junto
//	con curso_verilog.v. Si no es así, véase <http://www.gnu.org/licenses/>.
//	
//	**** **** **** ****
//
//	This file is part of curso_verilog.v.
//
//	curso_verilog.v is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	curso_verilog.v is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with curso_verilog.v.  If not, see <http://www.gnu.org/licenses/>.

/*
	Solución al ejercicio 4_11. Diseñar un circuito votador de 5 entradas.

	La salida del circuit es 1 si 3 o más entradas son 1.
*/

`timescale 1ns/1ps

module votador5(
	output v,
	input a,
	input b,
	input c,
	input d,
	input e
	);
	
	reg v;
	
	always @(a or b or c or d or e)
		case({a,b})
			2'b00:
				v = c & d & e;			// los 3 restantes son 1
			2'b01, 2'b10:
				v = c&d | c&e | d&e;	// 2 cuales quiera restantes son 1
			default: // 2'b11
				v = c | d | e;			// cualquiera restante es 1
		endcase

endmodule // votador5
