// Diseño:		votador5
// Archivo:		votador5_tb.v
// Descripción: Votador 5 entradas. Banco de pruebas
// Autor:		Jorge Juan <jjchico@gmail.com>
// Fecha:		13-11-2009

//	curso_verilog.v - Curso práctico de iniciación a Verilog
//
//	Copyright 2009 Jorge Juan <jjchico@gmail.com>
//
//	Este archivo es parte de curso_verilog.v.
//	
//	curso_verilog.v es software libre: puede redistribuirlo y/o modificarlo
//	bajo los términos de la Licencia General Pública de GNU publicada por
//	la Fundación de Software Libre, tanto su versión 3 como, opcionalmente,
//	cualquier otra versión posterior.
//	
//	curso_verilog.v se distribuye con el propósito de que sea útil, pero SIN
//	NINGUNA GARANTÍA, incluyendo la garantía implícita de COMERCIABILIDAD o
//	de ADECUACIÓN A UN PROPÓSITO EN PARTICULAR. Véase la Licencia General
//	Pública de GNU para más detalles.
//	
//	Debe haber recibido una copia de la Licencia General Pública de GNU junto
//	con curso_verilog.v. Si no es así, véase <http://www.gnu.org/licenses/>.
//	
//	**** **** **** ****
//
//	This file is part of curso_verilog.v.
//
//	curso_verilog.v is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	curso_verilog.v is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with curso_verilog.v.  If not, see <http://www.gnu.org/licenses/>.

/*
	Solución al ejercicio 4_11. Diseñar un circuito votador de 5 entradas.

	Banco de pruebas
*/

`timescale 1ns/1ps

`define DTIME 5

module test();

	wire v;
	reg [4:0] a;
	
	votador5 uut (v, a[0], a[1], a[2], a[3], a[4]);
	
	initial
	begin
		a = 5'd0;
		
		$dumpfile("test.vcd");
		$dumpvars(0, test);
		$monitor("%b %b", a, v);
		
		#(32 * `DTIME) $finish;
	end
	
	always
		#(`DTIME) a = a + 1;

endmodule // test	
