/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.sl;

import jade.content.abs.AbsAgentAction;
import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsConcept;
import jade.content.abs.AbsContentElement;
import jade.content.abs.AbsContentElementList;
import jade.content.abs.AbsIRE;
import jade.content.abs.AbsObjectImpl;
import jade.content.abs.AbsPredicate;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsTerm;
import jade.content.abs.AbsVariable;
import jade.content.lang.Codec;
import jade.content.lang.sl.ExtendedSLParserConstants;
import jade.content.lang.sl.ExtendedSLParserTokenManager;
import jade.content.lang.sl.ParseException;
import jade.content.lang.sl.SLCodec;
import jade.content.lang.sl.SimpleCharStream;
import jade.content.lang.sl.Token;
import jade.content.lang.sl.TokenMgrError;
import jade.content.onto.Ontology;
import jade.core.CaseInsensitiveString;
import jade.lang.acl.ISO8601;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Vector;

class ExtendedSLParser
implements ExtendedSLParserConstants {
    private static final String META_EXCEPTION_MESSAGE = "Meta SL expressions are not allowed";
    private boolean metaAllowed = true;
    Ontology curOntology = null;
    int slType = 3;
    public ExtendedSLParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[23];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    private String unescape(String s) {
        StringBuffer result = new StringBuffer(s.length());
        for (int i = 1; i < s.length() - 1; ++i) {
            if (s.charAt(i) == '\\' && s.charAt(i + 1) == '\"') {
                result.append("\"");
                ++i;
                continue;
            }
            result.append(s.charAt(i));
        }
        return result.toString();
    }

    private AbsTerm toAbsAgentAction(AbsTerm t) {
        if (t instanceof AbsConcept && !(t instanceof AbsAgentAction)) {
            AbsAgentAction act = new AbsAgentAction(t.getTypeName());
            String[] slotNames = t.getNames();
            if (slotNames != null) {
                for (int i = 0; i < slotNames.length; ++i) {
                    act.set(slotNames[i], (AbsTerm)t.getAbsObject(slotNames[i]));
                }
            }
            return act;
        }
        return t;
    }

    void setSLType(int slType) {
        this.slType = slType;
    }

    void reinit(Ontology o, String content) {
        this.curOntology = o;
        if (content == null) {
            content = new String();
        }
        this.ReInit(new StringReader(content));
    }

    AbsContentElement parse(Ontology o, String content) throws ParseException, TokenMgrError {
        this.reinit(o, content);
        AbsContentElementList tuple = this.Content();
        if (tuple.size() > 1) {
            return tuple;
        }
        return tuple.get(0);
    }

    public static void main(String[] args) {
        ExtendedSLParser theParser = null;
        try {
            theParser = new ExtendedSLParser(System.in);
            theParser.setSLType(Integer.parseInt(args[0]));
        }
        catch (Exception e) {
            System.out.println("usage: ExtendedSLParser SLLevel\n  where SLLevel can be 0 for SL0, 1 for SL1, 2 for SL2, 3 or more for full SL");
            System.exit(0);
        }
        if (theParser.slType < 3) {
            System.out.println("SL-" + theParser.slType + " Parser Started ...");
        } else {
            System.out.println("Full-SL Parser Started ...");
        }
        SLCodec codec = new SLCodec();
        while (true) {
            System.out.println("insert an SL expression to parse: ");
            try {
                AbsContentElementList result = theParser.Content();
                String resultEncoded = codec.encode(result);
                System.out.println("\n\n RESULT of ExtendedSLParser.Content()=\n" + resultEncoded);
                AbsContentElement result2 = codec.decode(resultEncoded);
                System.out.println("\n\n RESULT of SLCodec.decode(SLCodec.encode(ExtendedSLParser.Content()))=\n" + codec.encode(result2));
                System.out.println("\n\n");
                continue;
            }
            catch (Exception pe) {
                pe.printStackTrace();
                System.exit(0);
                continue;
            }
            break;
        }
    }

    public final AbsContentElementList Content() throws ParseException {
        AbsContentElementList tuple = new AbsContentElementList();
        this.LBrace();
        block3: while (true) {
            AbsContentElement val = this.ContentExpression();
            tuple.add(val);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 14: 
                case 15: 
                case 20: 
                case 25: 
                case 36: 
                case 37: 
                case 38: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[0] = this.jj_gen;
        this.RBrace();
        return tuple;
    }

    public final void LBrace() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void RBrace() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final AbsContentElement ContentExpression() throws ParseException {
        AbsContentElement val = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 36: 
            case 37: {
                String s = this.String();
                val = new AbsPredicate(s);
                break;
            }
            case 5: 
            case 25: {
                this.LBrace();
                val = this.ContentExpression_NoBrace();
                this.RBrace();
                break;
            }
            case 20: 
            case 38: {
                String s = this.MetaSymbol();
                AbsPredicate val1 = new AbsPredicate(s);
                val1.setIsMetaFormula(true);
                val = val1;
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        val.setIsAContentExpression(true);
        return val;
    }

    public final AbsContentElement ContentExpression_NoBrace() throws ParseException {
        AbsObjectImpl val = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                val = this.IdentifyingExpression_NoBrace();
                break;
            }
            case 27: 
            case 32: {
                val = this.ActionExpression_NoBrace();
                break;
            }
            case 14: 
            case 15: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                val = this.Wff_NoBrace();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final AbsIRE IdentifyingExpression_NoBrace() throws ParseException {
        AbsIRE ire = null;
        Token t = this.jj_consume_token(28);
        if (this.slType < 2) {
            throw new ParseException("NotFullSL_IdentifyExpression_NotParsable_UseAtLeastSL2");
        }
        AbsTerm term = this.Term();
        AbsPredicate prop = this.Wff();
        ire = new AbsIRE(t.image);
        ire.setTerm(term);
        ire.setProposition(prop);
        return ire;
    }

    public final AbsVariable Variable() throws ParseException {
        AbsVariable val = null;
        Token v = this.jj_consume_token(7);
        val = new AbsVariable();
        val.setName(v.image.substring(1));
        return val;
    }

    public final AbsTerm Term() throws ParseException {
        AbsTerm val = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                val = this.Variable();
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 36: 
            case 37: {
                val = this.Constant();
                break;
            }
            case 5: 
            case 25: {
                this.LBrace();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: 
                    case 15: 
                    case 30: 
                    case 36: 
                    case 37: {
                        val = this.FunctionalTerm_NoBrace();
                        break;
                    }
                    case 27: 
                    case 32: {
                        val = this.ActionExpression_NoBrace();
                        break;
                    }
                    case 28: {
                        val = this.IdentifyingExpression_NoBrace();
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.RBrace();
                break;
            }
            case 20: 
            case 38: {
                String s = this.MetaSymbol();
                AbsVariable val1 = new AbsVariable();
                val1.setName(s);
                val1.setIsMetaTerm(true);
                val = val1;
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final AbsPrimitive Constant() throws ParseException {
        AbsPrimitive val = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 36: 
            case 37: {
                String s = this.String();
                if (CaseInsensitiveString.equalsIgnoreCase(s, "true")) {
                    val = AbsPrimitive.wrap(true);
                    break;
                }
                if (CaseInsensitiveString.equalsIgnoreCase(s, "false")) {
                    val = AbsPrimitive.wrap(false);
                    break;
                }
                if (CaseInsensitiveString.equalsIgnoreCase(s, "\"true\"") || CaseInsensitiveString.equalsIgnoreCase(s, "\"false\"")) {
                    s = this.unescape(s);
                }
                val = AbsPrimitive.wrap(s);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                val = this.Number();
                break;
            }
            case 18: {
                Token t = this.jj_consume_token(18);
                try {
                    Date d = ISO8601.toDate(t.image);
                    val = AbsPrimitive.wrap(d);
                }
                catch (Exception e) {
                    val = AbsPrimitive.wrap(t.image);
                }
                break;
            }
            case 19: {
                Token t = this.jj_consume_token(19);
                val = AbsPrimitive.wrap(t.image.getBytes());
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final AbsConcept FunctionalTerm_NoBrace() throws ParseException {
        AbsConcept val = null;
        block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                Token t = this.jj_consume_token(30);
                AbsTerm term1 = this.Term();
                AbsTerm term2 = this.Term();
                val = new AbsConcept(t.image);
                try {
                    String[] slotNames = this.curOntology.getSchema(t.image).getNames();
                    val.set(slotNames[0], term1);
                    val.set(slotNames[1], term2);
                }
                catch (Exception e) {
                    val.set(Codec.UNNAMEDPREFIX + "0", term1);
                    val.set(Codec.UNNAMEDPREFIX + "1", term2);
                }
                break;
            }
            case 14: 
            case 15: 
            case 36: 
            case 37: {
                String s = this.String();
                if ("set".equalsIgnoreCase(s) || "sequence".equalsIgnoreCase(s)) {
                    val = new AbsAggregate(s);
                } else {
                    try {
                        val = (AbsConcept)this.curOntology.getSchema(s).newInstance();
                    }
                    catch (Exception e) {
                        val = new AbsConcept(s);
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 25: 
                    case 36: 
                    case 37: 
                    case 38: {
                        this.FunctionalTermParameters(val);
                        break block2;
                    }
                }
                this.jj_la1[8] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final void FunctionalTermParameters(AbsConcept val) throws ParseException {
        int slotNumber = 0;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 36: 
            case 37: 
            case 38: {
                String[] slotNames = null;
                try {
                    slotNames = this.curOntology.getSchema(val.getTypeName()).getNames();
                }
                catch (Exception e) {
                    // empty catch block
                }
                block14: while (true) {
                    AbsTerm t = this.Term();
                    try {
                        val.set(slotNames[slotNumber], t);
                    }
                    catch (Exception e) {
                        val.set(Codec.UNNAMEDPREFIX + slotNumber, t);
                    }
                    ++slotNumber;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 25: 
                        case 36: 
                        case 37: 
                        case 38: {
                            continue block14;
                        }
                    }
                    break;
                }
                this.jj_la1[10] = this.jj_gen;
                break;
            }
            case 16: 
            case 17: {
                block15: while (true) {
                    this.Parameter(val);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 16: 
                        case 17: {
                            continue block15;
                        }
                    }
                    break;
                }
                this.jj_la1[11] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Parameter(AbsConcept val) throws ParseException {
        String slotName;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                Token t = this.jj_consume_token(16);
                slotName = t.image.substring(1);
                break;
            }
            case 17: {
                Token t = this.jj_consume_token(17);
                slotName = this.unescape(t.image.substring(1));
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        AbsTerm term = this.Term();
        val.set(slotName, term);
    }

    public final AbsAgentAction ActionExpression_NoBrace() throws ParseException {
        AbsAgentAction val = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                Token t = this.jj_consume_token(27);
                AbsTerm term1 = this.Term();
                AbsTerm term2 = this.Term();
                val = new AbsAgentAction(t.image);
                try {
                    String[] slotNames = this.curOntology.getSchema(t.image).getNames();
                    val.set(slotNames[0], term1);
                    val.set(slotNames[1], this.toAbsAgentAction(term2));
                }
                catch (Exception e) {
                    val.set(Codec.UNNAMEDPREFIX + "0", term1);
                    val.set(Codec.UNNAMEDPREFIX + "1", this.toAbsAgentAction(term2));
                }
                break;
            }
            case 32: {
                Token t = this.jj_consume_token(32);
                if (this.slType < 2) {
                    throw new ParseException("NotFullSL_ActionOperatorExpression_NotParsable");
                }
                AbsTerm term1 = this.ActionExpression();
                AbsTerm term2 = this.ActionExpression();
                val = new AbsAgentAction(t.image);
                try {
                    String[] slotNames = this.curOntology.getSchema(t.image).getNames();
                    val.set(slotNames[0], term1);
                    val.set(slotNames[1], this.toAbsAgentAction(term2));
                }
                catch (Exception e) {
                    val.set(Codec.UNNAMEDPREFIX + "0", term1);
                    val.set(Codec.UNNAMEDPREFIX + "1", this.toAbsAgentAction(term2));
                }
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final AbsTerm ActionExpression() throws ParseException {
        AbsObjectImpl val = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 25: {
                this.LBrace();
                val = this.ActionExpression_NoBrace();
                this.RBrace();
                break;
            }
            case 20: 
            case 38: {
                String s = this.MetaSymbol();
                AbsVariable val1 = new AbsVariable();
                val1.setName(s);
                val1.setIsMetaTerm(true);
                val = val1;
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final AbsPredicate Wff() throws ParseException {
        AbsPredicate val = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 36: 
            case 37: {
                String s = this.String();
                val = new AbsPredicate(s);
                break;
            }
            case 5: 
            case 25: {
                this.LBrace();
                val = this.Wff_NoBrace();
                this.RBrace();
                break;
            }
            case 20: 
            case 38: {
                String s = this.MetaSymbol();
                val = new AbsPredicate(s);
                val.setIsMetaFormula(true);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final AbsPredicate Wff_NoBrace() throws ParseException {
        AbsPredicate val = null;
        String[] slotNames = null;
        block8 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                Token t = this.jj_consume_token(33);
                if (this.slType < 1) {
                    throw new ParseException("NotFullSL_NotExpression_NotParsable_UseAtLeastSL1");
                }
                AbsPredicate arg1 = this.Wff();
                val = new AbsPredicate(t.image);
                try {
                    slotNames = this.curOntology.getSchema(t.image).getNames();
                    val.set(slotNames[0], arg1);
                }
                catch (Exception e) {
                    val.set(Codec.UNNAMEDPREFIX + "0", arg1);
                }
                break;
            }
            case 34: {
                Token t = this.jj_consume_token(34);
                if (this.slType < 1) {
                    throw new ParseException("NotFullSL_BinaryLogicalExpression_NotParsable_UseAtLeastSL1");
                }
                AbsPredicate arg1 = this.Wff();
                AbsPredicate arg2 = this.Wff();
                val = new AbsPredicate(t.image);
                try {
                    slotNames = this.curOntology.getSchema(t.image).getNames();
                    val.set(slotNames[0], arg1);
                    val.set(slotNames[1], arg2);
                }
                catch (Exception e) {
                    val.set(Codec.UNNAMEDPREFIX + "0", arg1);
                    val.set(Codec.UNNAMEDPREFIX + "1", arg2);
                }
                break;
            }
            case 35: {
                Token t = this.jj_consume_token(35);
                if (this.slType < 2) {
                    throw new ParseException("NotFullSL_QuantifierExpression_NotParsable_UseAtLeastSL2");
                }
                AbsVariable var = this.Variable();
                AbsPredicate arg1 = this.Wff();
                val = new AbsPredicate(t.image);
                try {
                    slotNames = this.curOntology.getSchema(t.image).getNames();
                    val.set(slotNames[0], var);
                    val.set(slotNames[1], arg1);
                }
                catch (Exception e) {
                    val.set(Codec.UNNAMEDPREFIX + "0", var);
                    val.set(Codec.UNNAMEDPREFIX + "1", arg1);
                }
                break;
            }
            case 29: {
                Token t = this.jj_consume_token(29);
                if (this.slType < 2) {
                    throw new ParseException("NotFullSL_ModalOperatorExpression_NotParsable_UseAtLeastSL2");
                }
                AbsTerm term = this.Term();
                AbsPredicate arg1 = this.Wff();
                val = new AbsPredicate(t.image);
                try {
                    slotNames = this.curOntology.getSchema(t.image).getNames();
                    val.set(slotNames[0], term);
                    val.set(slotNames[1], arg1);
                }
                catch (Exception e) {
                    val.set(Codec.UNNAMEDPREFIX + "0", term);
                    val.set(Codec.UNNAMEDPREFIX + "1", arg1);
                }
                break;
            }
            case 31: {
                Token t = this.jj_consume_token(31);
                AbsTerm term = this.ActionExpression();
                val = new AbsPredicate(t.image);
                try {
                    slotNames = this.curOntology.getSchema(t.image).getNames();
                    val.set(slotNames[0], term);
                }
                catch (Exception e) {
                    val.set(Codec.UNNAMEDPREFIX + "0", term);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 14: 
                    case 15: 
                    case 20: 
                    case 25: 
                    case 36: 
                    case 37: 
                    case 38: {
                        AbsPredicate arg1 = this.Wff();
                        try {
                            val.set(slotNames[1], arg1);
                        }
                        catch (Exception e) {
                            val.set(Codec.UNNAMEDPREFIX + "1", arg1);
                        }
                        break block8;
                    }
                }
                this.jj_la1[17] = this.jj_gen;
                break;
            }
            case 14: 
            case 15: 
            case 36: 
            case 37: {
                String s = this.String();
                val = new AbsPredicate(s);
                int slotNumber = 0;
                try {
                    slotNames = this.curOntology.getSchema(s).getNames();
                }
                catch (Exception e) {
                    // empty catch block
                }
                block30: while (true) {
                    AbsTerm term = this.Term();
                    try {
                        val.set(slotNames[slotNumber], term);
                    }
                    catch (Exception e) {
                        val.set(Codec.UNNAMEDPREFIX + slotNumber, term);
                    }
                    ++slotNumber;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 25: 
                        case 36: 
                        case 37: 
                        case 38: {
                            continue block30;
                        }
                    }
                    break;
                }
                this.jj_la1[18] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final AbsPrimitive Number() throws ParseException {
        AbsPrimitive val = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                Token t = this.jj_consume_token(8);
                try {
                    val = AbsPrimitive.wrap(Integer.parseInt(t.image));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    val = AbsPrimitive.wrap(t.image);
                }
                break;
            }
            case 9: {
                Token t = this.jj_consume_token(9);
                val = AbsPrimitive.wrap(t.image);
                break;
            }
            case 10: {
                Token t = this.jj_consume_token(10);
                try {
                    String longStr = t.image.substring(0, t.image.length() - 1);
                    val = AbsPrimitive.wrap(Long.parseLong(longStr));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    val = AbsPrimitive.wrap(t.image);
                }
                break;
            }
            case 11: {
                Token t = this.jj_consume_token(11);
                try {
                    double d1 = new Double(t.image);
                    val = AbsPrimitive.wrap(d1);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    val = AbsPrimitive.wrap(t.image);
                }
                break;
            }
            case 12: {
                Token t = this.jj_consume_token(12);
                try {
                    double d2 = new Double(t.image);
                    val = AbsPrimitive.wrap(d2);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    val = AbsPrimitive.wrap(t.image);
                }
                break;
            }
            case 13: {
                Token t = this.jj_consume_token(13);
                try {
                    String floatStr = t.image.substring(0, t.image.length() - 1);
                    val = AbsPrimitive.wrap(new Float(floatStr).floatValue());
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    val = AbsPrimitive.wrap(t.image);
                }
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final String String() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                Token t = this.jj_consume_token(36);
                return t.image;
            }
            case 37: {
                Token t = this.jj_consume_token(37);
                if (CaseInsensitiveString.equalsIgnoreCase(t.image, "\"true\"") || CaseInsensitiveString.equalsIgnoreCase(t.image, "\"false\"")) {
                    return t.image;
                }
                return this.unescape(t.image);
            }
            case 14: {
                Token t = this.jj_consume_token(14);
                return t.image;
            }
            case 15: {
                Token t = this.jj_consume_token(15);
                if (CaseInsensitiveString.equalsIgnoreCase(t.image, "\"true\"") || CaseInsensitiveString.equalsIgnoreCase(t.image, "\"false\"")) {
                    return t.image;
                }
                return this.unescape(t.image);
            }
        }
        this.jj_la1[21] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String MetaSymbol() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                t = this.jj_consume_token(20);
                break;
            }
            case 38: {
                t = this.jj_consume_token(38);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (!this.metaAllowed) {
            throw new ParseException(META_EXCEPTION_MESSAGE);
        }
        return t.image;
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{34652192, 0x2000020, 0x4000040, 34652192, -1207910400, 1476444160, 35454880, 851712, 35651488, 0x4000C000, 35454880, 196608, 35651488, 196608, 0x8000000, 0x2100020, 34652192, 34652192, 35454880, -1610563584, 16128, 49152, 0x100000};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{112, 0, 0, 112, 63, 49, 112, 48, 112, 48, 112, 0, 112, 0, 1, 64, 112, 112, 112, 62, 0, 48, 64};
    }

    public ExtendedSLParser(InputStream stream) {
        this(stream, null);
    }

    public ExtendedSLParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.token_source = new ExtendedSLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ExtendedSLParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ExtendedSLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ExtendedSLParser(ExtendedSLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(ExtendedSLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[39];
        for (i = 0; i < 39; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 23; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 39; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        ExtendedSLParser.jj_la1_0();
        ExtendedSLParser.jj_la1_1();
    }
}

