/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.FrontEnd;
import jade.core.IMTPException;
import jade.core.NotFoundException;
import jade.core.PostponedException;
import jade.imtp.leap.Command;
import jade.imtp.leap.Dispatcher;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.MicroStub;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Properties;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class FrontEndStub
extends MicroStub
implements FrontEnd {
    public FrontEndStub(Dispatcher d) {
        super(d);
    }

    public void createAgent(String name, String className, String[] args) throws IMTPException {
        Command c = new Command(10);
        c.addParam(name);
        c.addParam(className);
        c.addParam(args);
        this.executeRemotely(c, 0L);
    }

    public void killAgent(String name) throws NotFoundException, IMTPException {
        Command c = new Command(11);
        c.addParam(name);
        Command r = this.executeRemotely(c, -1L);
        if (r != null) {
            if (r.getCode() == 2) {
                throw new NotFoundException((String)r.getParamAt(2));
            }
        } else {
            throw new PostponedException();
        }
    }

    public void suspendAgent(String name) throws NotFoundException, IMTPException {
        Command c = new Command(12);
        c.addParam(name);
        Command r = this.executeRemotely(c, -1L);
        if (r != null) {
            if (r.getCode() == 2) {
                throw new NotFoundException((String)r.getParamAt(2));
            }
        } else {
            throw new PostponedException();
        }
    }

    public void resumeAgent(String name) throws NotFoundException, IMTPException {
        Command c = new Command(13);
        c.addParam(name);
        Command r = this.executeRemotely(c, -1L);
        if (r != null) {
            if (r.getCode() == 2) {
                throw new NotFoundException((String)r.getParamAt(2));
            }
        } else {
            throw new PostponedException();
        }
    }

    public void messageIn(ACLMessage msg, String receiver) throws NotFoundException, IMTPException {
        Command c = new Command(14);
        c.addParam(msg);
        c.addParam(receiver);
        Command r = this.executeRemotely(c, -1L);
        if (r != null && r.getCode() == 2) {
            throw new NotFoundException((String)r.getParamAt(2));
        }
    }

    public void exit(boolean self) throws IMTPException {
        Command c = new Command(15);
        c.addParam(new Boolean(self));
        this.executeRemotely(c, 0L);
    }

    public void synch() throws IMTPException {
        Command c = new Command(16);
        this.executeRemotely(c, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List removePendingMessages(MessageTemplate template) {
        Vector vector = this.pendingCommands;
        synchronized (vector) {
            ArrayList messages = new ArrayList();
            ArrayList commands = new ArrayList();
            Enumeration e = this.pendingCommands.elements();
            while (e.hasMoreElements()) {
                ACLMessage msg;
                Command c = (Command)e.nextElement();
                if (c.getCode() != 14 || !template.match(msg = (ACLMessage)c.getParamAt(0))) continue;
                Object[] oo = new Object[]{msg, c.getParamAt(1)};
                messages.add(oo);
                commands.add(c);
            }
            Iterator it = commands.iterator();
            while (it.hasNext()) {
                this.pendingCommands.remove(it.next());
            }
            return messages;
        }
    }

    public static final String encodeCreateMediatorResponse(Properties pp) {
        StringBuffer sb = new StringBuffer();
        FrontEndStub.appendProp(sb, "platform-id", pp);
        FrontEndStub.appendProp(sb, "addresses", pp);
        FrontEndStub.appendProp(sb, "mediator-id", pp);
        FrontEndStub.appendProp(sb, "local-host", pp);
        FrontEndStub.appendProp(sb, "agents", pp, false);
        return sb.toString();
    }

    private static final void appendProp(StringBuffer sb, String key, Properties pp) {
        FrontEndStub.appendProp(sb, key, pp, true);
    }

    private static final void appendProp(StringBuffer sb, String key, Properties pp, boolean appendHash) {
        String strVal;
        Object val = pp.get(key);
        if (val != null && (strVal = val.toString()).length() > 0) {
            sb.append(key);
            sb.append('=');
            sb.append(val);
            if (appendHash) {
                sb.append('#');
            }
        }
    }

    public static final Properties parseCreateMediatorRequest(String s) throws ICPException {
        StringTokenizer st = new StringTokenizer(s, "=#");
        Properties p = new Properties();
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            if (!st.hasMoreTokens()) {
                throw new ICPException("Wrong initialization properties format.");
            }
            p.setProperty(key, st.nextToken());
        }
        return p;
    }
}

