/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.Agent;
import jade.core.CaseInsensitiveString;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.FIPANames;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.states.MsgReceiver;
import jade.proto.states.ReplySender;

public class ProposeResponder
extends FSMBehaviour
implements FIPANames.InteractionProtocol {
    public final String PROPOSE_KEY = "__propose" + this.hashCode();
    public final String RESPONSE_KEY = "__response" + this.hashCode();
    protected static final String RECEIVE_PROPOSE = "Receive-propose";
    protected static final String PREPARE_RESPONSE = "Prepare-response";
    protected static final String SEND_RESPONSE = "Send-response";
    MsgReceiver rec = null;

    public static MessageTemplate createMessageTemplate(String iprotocol) {
        if (CaseInsensitiveString.equalsIgnoreCase("fipa-propose", iprotocol)) {
            return MessageTemplate.and(MessageTemplate.MatchProtocol("fipa-propose"), MessageTemplate.MatchPerformative(11));
        }
        return MessageTemplate.MatchProtocol(iprotocol);
    }

    public ProposeResponder(Agent a, MessageTemplate mt) {
        this(a, mt, new DataStore());
    }

    public ProposeResponder(Agent a, MessageTemplate mt, DataStore store) {
        super(a);
        this.setDataStore(store);
        this.registerDefaultTransition(RECEIVE_PROPOSE, PREPARE_RESPONSE);
        this.registerDefaultTransition(PREPARE_RESPONSE, SEND_RESPONSE);
        this.registerDefaultTransition(SEND_RESPONSE, RECEIVE_PROPOSE);
        OneShotBehaviour b = null;
        this.rec = new MsgReceiver(this.myAgent, mt, -1L, this.getDataStore(), this.PROPOSE_KEY);
        this.registerFirstState(this.rec, RECEIVE_PROPOSE);
        b = new PrepareResponse(this.myAgent);
        b.setDataStore(this.getDataStore());
        this.registerState(b, PREPARE_RESPONSE);
        b = new ReplySender(this.myAgent, this.RESPONSE_KEY, this.PROPOSE_KEY);
        b.setDataStore(this.getDataStore());
        this.registerState(b, SEND_RESPONSE);
    }

    public void reset() {
        super.reset();
        DataStore ds = this.getDataStore();
        ds.remove(this.PROPOSE_KEY);
        ds.remove(this.RESPONSE_KEY);
    }

    public void reset(MessageTemplate mt) {
        this.reset();
        this.rec.reset(mt, -1L, this.getDataStore(), this.PROPOSE_KEY);
    }

    protected ACLMessage prepareResponse(ACLMessage propose) throws NotUnderstoodException, RefuseException {
        return null;
    }

    public void registerPrepareResponse(Behaviour b) {
        this.registerState(b, PREPARE_RESPONSE);
        b.setDataStore(this.getDataStore());
    }

    private ProposeResponder() {
    }

    private static class PrepareResponse
    extends OneShotBehaviour {
        public PrepareResponse(Agent a) {
            super(a);
        }

        private PrepareResponse() {
        }

        public void action() {
            ProposeResponder fsm = (ProposeResponder)this.getParent();
            DataStore ds = this.getDataStore();
            ACLMessage propose = (ACLMessage)ds.get(fsm.PROPOSE_KEY);
            ACLMessage response = null;
            try {
                response = fsm.prepareResponse(propose);
            }
            catch (NotUnderstoodException nue) {
                response = nue.getACLMessage();
            }
            catch (RefuseException re) {
                response = re.getACLMessage();
            }
            ds.put(fsm.RESPONSE_KEY, response);
        }
    }
}

