/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.tools.gui.ACLSLTokenMarker;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;

public class ACLSyntaxDocument
extends PlainDocument {
    protected ACLSLTokenMarker tokenMarker;

    public ACLSLTokenMarker getTokenMarker() {
        return this.tokenMarker;
    }

    public void setTokenMarker(ACLSLTokenMarker tm) {
        this.tokenMarker = tm;
        if (tm == null) {
            return;
        }
        this.tokenMarker.insertLines(0, this.getDefaultRootElement().getElementCount());
        this.tokenizeLines();
    }

    public void tokenizeLines() {
        this.tokenizeLines(0, this.getDefaultRootElement().getElementCount());
    }

    public void tokenizeLines(int start, int len) {
        if (this.tokenMarker == null || !this.tokenMarker.supportsMultilineTokens()) {
            return;
        }
        Segment lineSegment = new Segment();
        Element map = this.getDefaultRootElement();
        len += start;
        try {
            for (int i = start; i < len; ++i) {
                Element lineElement = map.getElement(i);
                int lineStart = lineElement.getStartOffset();
                this.getText(lineStart, lineElement.getEndOffset() - lineStart - 1, lineSegment);
                this.tokenMarker.markTokens(lineSegment, i);
            }
        }
        catch (BadLocationException bl) {
            // empty catch block
        }
    }

    protected void fireInsertUpdate(DocumentEvent evt) {
        DocumentEvent.ElementChange ch;
        if (this.tokenMarker != null && (ch = evt.getChange(this.getDefaultRootElement())) != null) {
            this.tokenMarker.insertLines(ch.getIndex() + 1, ch.getChildrenAdded().length - ch.getChildrenRemoved().length);
        }
        super.fireInsertUpdate(evt);
    }

    protected void fireRemoveUpdate(DocumentEvent evt) {
        DocumentEvent.ElementChange ch;
        if (this.tokenMarker != null && (ch = evt.getChange(this.getDefaultRootElement())) != null) {
            this.tokenMarker.deleteLines(ch.getIndex() + 1, ch.getChildrenRemoved().length - ch.getChildrenAdded().length);
        }
        super.fireRemoveUpdate(evt);
    }
}

