/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.schema.AggregateSchema;
import jade.content.schema.ObjectSchema;
import jade.content.schema.TermSchema;
import jade.util.leap.HashSet;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class AggregateHelper {
    private static final int ACC_ABSTRACT = 1024;
    private static final int ACC_INTERFACE = 512;

    public static ObjectSchema getSchema(Class clazz, TermSchema elementSchema) {
        AggregateSchema schema = null;
        if (java.util.List.class.isAssignableFrom(clazz) || List.class.isAssignableFrom(clazz) || clazz.isArray() && clazz != byte[].class) {
            schema = new AggregateSchema("sequence", elementSchema);
        } else if (Set.class.isAssignableFrom(clazz) || jade.util.leap.Set.class.isAssignableFrom(clazz)) {
            schema = new AggregateSchema("set", elementSchema);
        }
        return schema;
    }

    public static Object adjustAggregateValue(Object srcValue, Class destClass) throws Exception {
        Class<?> srcClass;
        Object destValue = srcValue;
        if (srcValue != null && (srcClass = srcValue.getClass()) != destClass) {
            if (destClass.isArray()) {
                if (Collection.class.isAssignableFrom(srcClass)) {
                    Collection javaCollection = (Collection)srcValue;
                    destValue = AggregateHelper.collectionToArray(javaCollection.iterator(), destClass.getComponentType(), javaCollection.size());
                } else if (jade.util.leap.Collection.class.isAssignableFrom(srcClass)) {
                    jade.util.leap.Collection jadeCollection = (jade.util.leap.Collection)srcValue;
                    destValue = AggregateHelper.collectionToArray(jadeCollection.iterator(), destClass.getComponentType(), jadeCollection.size());
                }
            } else if (Collection.class.isAssignableFrom(destClass)) {
                if (srcClass.isArray()) {
                    Collection javaCollection = AggregateHelper.createConcreteJavaCollection(destClass);
                    int size = Array.getLength(srcValue);
                    for (int index = 0; index < size; ++index) {
                        javaCollection.add(Array.get(srcValue, index));
                    }
                    destValue = javaCollection;
                } else if (jade.util.leap.Collection.class.isAssignableFrom(srcClass)) {
                    Collection javaCollection = AggregateHelper.createConcreteJavaCollection(destClass);
                    jade.util.leap.Collection jadeCollection = (jade.util.leap.Collection)srcValue;
                    Iterator it = jadeCollection.iterator();
                    while (it.hasNext()) {
                        javaCollection.add(it.next());
                    }
                    destValue = javaCollection;
                }
            } else if (jade.util.leap.Collection.class.isAssignableFrom(destClass)) {
                if (srcClass.isArray()) {
                    jade.util.leap.Collection jadeCollection = AggregateHelper.createConcreteJadeCollection(destClass);
                    int size = Array.getLength(srcValue);
                    for (int index = 0; index < size; ++index) {
                        jadeCollection.add(Array.get(srcValue, index));
                    }
                    destValue = jadeCollection;
                } else if (Collection.class.isAssignableFrom(srcClass)) {
                    jade.util.leap.Collection jadeCollection = AggregateHelper.createConcreteJadeCollection(destClass);
                    Collection javaCollection = (Collection)srcValue;
                    java.util.Iterator it = javaCollection.iterator();
                    while (it.hasNext()) {
                        jadeCollection.add(it.next());
                    }
                    destValue = jadeCollection;
                }
            }
        }
        return destValue;
    }

    private static Object collectionToArray(java.util.Iterator it, Class componentTypeClass, int size) {
        int index = 0;
        Object array = Array.newInstance(componentTypeClass, size);
        while (it.hasNext()) {
            Object item = it.next();
            Array.set(array, index, item);
            ++index;
        }
        return array;
    }

    static Collection createConcreteJavaCollection(Class clazz) throws InstantiationException, IllegalAccessException {
        int modifiers = clazz.getModifiers();
        AbstractCollection result = null;
        if ((modifiers & 0x400) == 0 && (modifiers & 0x200) == 0) {
            result = (ArrayList)clazz.newInstance();
        } else if (java.util.List.class.isAssignableFrom(clazz)) {
            result = new ArrayList();
        } else if (Set.class.isAssignableFrom(clazz)) {
            result = new java.util.HashSet();
        }
        return result;
    }

    static jade.util.leap.Collection createConcreteJadeCollection(Class clazz) throws InstantiationException, IllegalAccessException {
        int modifiers = clazz.getModifiers();
        jade.util.leap.Collection result = null;
        if ((modifiers & 0x400) == 0 && (modifiers & 0x200) == 0) {
            result = (jade.util.leap.Collection)clazz.newInstance();
        } else if (List.class.isAssignableFrom(clazz)) {
            result = new jade.util.leap.ArrayList();
        } else if (jade.util.leap.Set.class.isAssignableFrom(clazz)) {
            result = new HashSet();
        }
        return result;
    }
}

