/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.AID;
import jade.core.Agent;
import jade.core.FrontEndContainer;
import jade.core.Profile;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.TickerBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.leap.Properties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ScalabilityTest {
    private static final String CONTENT_SIZE = "s";
    private static final int DEFAULT_CONTENT_SIZE = 1000;
    private static final String TIME_INTERVAL = "t";
    private static final long DEFAULT_TIME_INTERVAL = 1000L;
    private static final long STEPBYSTEP_TIME_INTERVAL = -1L;
    private static final String N_ITERATIONS = "i";
    private static final int DEFAULT_N_ITERATIONS = -1;
    private static final String N_COUPLES = "n";
    private static final int DEFAULT_N_COUPLES = 10;
    private static final String BASE = "base";
    private static final int DEFAULT_BASE = 0;
    private static final String MODE = "mode";
    private static final String FAST_MODE_S = "fast";
    private static final String SLOW_MODE_S = "slow";
    private static final String STEP_BY_STEP_MODE_S = "stepbystep";
    private static final String READY_GO_MODE_S = "readygo";
    private static final int FAST_MODE = 0;
    private static final int SLOW_MODE = 1;
    private static final int STEP_BY_STEP_MODE = 2;
    private static final int READY_GO_MODE = 3;
    private static final String MEASURE = "measure";
    private static final String BITRATE_MEASURE_S = "bitrate";
    private static final String RTT_MEASURE_S = "rtt";
    private static final int BITRATE_MEASURE = 0;
    private static final int RTT_MEASURE = 1;
    private static Object terminatedLock = new Object();
    private static Object readyLock = new Object();
    private static Object semaphore = new Object();
    private static byte[] content;
    private static long timeInterval;
    private static int nIterations;
    private static int nCouples;
    private static int base;
    private static int mode;
    private static int measure;
    private static int readyCnt;
    private static int terminatedCnt;
    private static long totalTime;
    private static long totalTime2;
    private static Object lock;
    private static BufferedReader inputReader;

    public static void main(String[] args) {
        int i;
        Properties pp = ScalabilityTest.parseArguments(args);
        int contentSize = 1000;
        try {
            contentSize = Integer.parseInt(pp.getProperty(CONTENT_SIZE));
        }
        catch (Exception e) {
            // empty catch block
        }
        content = new byte[contentSize];
        timeInterval = 1000L;
        try {
            timeInterval = Long.parseLong(pp.getProperty(TIME_INTERVAL));
        }
        catch (Exception e) {
            // empty catch block
        }
        nIterations = -1;
        try {
            nIterations = Integer.parseInt(pp.getProperty(N_ITERATIONS));
        }
        catch (Exception e) {
            // empty catch block
        }
        base = 0;
        try {
            base = Integer.parseInt(pp.getProperty(BASE));
        }
        catch (Exception e) {
            // empty catch block
        }
        mode = 3;
        try {
            String modeStr = pp.getProperty(MODE);
            if (SLOW_MODE_S.equals(modeStr)) {
                mode = 1;
            } else if (FAST_MODE_S.equals(modeStr)) {
                mode = 0;
            } else if (STEP_BY_STEP_MODE_S.equals(modeStr)) {
                mode = 2;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (mode == 3 || mode == 2) {
            inputReader = new BufferedReader(new InputStreamReader(System.in));
        }
        nCouples = 10;
        try {
            nCouples = Integer.parseInt(pp.getProperty(N_COUPLES));
        }
        catch (Exception e) {
            // empty catch block
        }
        measure = 0;
        try {
            String measureStr = pp.getProperty(MEASURE);
            if (RTT_MEASURE_S.equals(measureStr)) {
                measure = 1;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String prefix = Profile.getDefaultNetworkName();
        block18: for (i = base; i < base + nCouples; ++i) {
            ScalabilityTest.initCouple(pp.getProperty("host"), pp.getProperty("port"), pp.getProperty("connection-manager"), pp.getProperty("mediator-class"), pp.getProperty("max-disconnection-time"), prefix, i);
            switch (mode) {
                case 1: {
                    ScalabilityTest.waitABit();
                    continue block18;
                }
                case 2: {
                    ScalabilityTest.prompt("Couple #" + i + " started. Press enter to continue");
                    continue block18;
                }
                default: {
                    Thread.currentThread();
                    Thread.yield();
                }
            }
        }
        ScalabilityTest.waitUntilReady();
        if (mode == 3) {
            ScalabilityTest.prompt("All " + nCouples + " couples ready. Press enter to go");
        }
        ScalabilityTest.start();
        if (nIterations > 0) {
            System.out.println("Measurement started....");
        }
        if (timeInterval == -1L) {
            i = 0;
            while (true) {
                ScalabilityTest.waitUntilReady();
                ScalabilityTest.prompt("Iteration # " + i + " terminated by all couples. Press enter to go");
                ++i;
                ScalabilityTest.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyReady() {
        Object object = semaphore;
        synchronized (object) {
            Object object2 = readyLock;
            synchronized (object2) {
                ++readyCnt;
                readyLock.notifyAll();
            }
            try {
                semaphore.wait();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitUntilReady() {
        Object object = readyLock;
        synchronized (object) {
            while (readyCnt < nCouples) {
                try {
                    readyLock.wait();
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void start() {
        Object object = semaphore;
        synchronized (object) {
            semaphore.notifyAll();
            readyCnt = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitABit() {
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void prompt(String msg) {
        System.out.println(msg);
        try {
            inputReader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Properties parseArguments(String[] args) {
        Properties props = new Properties();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                String name = args[i].substring(1);
                if (++i >= args.length) {
                    throw new IllegalArgumentException("No value specified for property \"" + name + "\"");
                }
                props.setProperty(name, args[i]);
                continue;
            }
            throw new IllegalArgumentException("Invalid property \"" + args[i] + "\". It does not start with '-'");
        }
        return props;
    }

    private static void initCouple(String host, String port, String connectionManager, String mediatorClass, String maxDiscTime, String prefix, int index) {
        String senderClass = "jade.core.ScalabilityTest$BitrateSenderAgent";
        String receiverClass = "jade.core.ScalabilityTest$BitrateReceiverAgent";
        if (measure == 1) {
            senderClass = "jade.core.ScalabilityTest$RTTSenderAgent";
            receiverClass = "jade.core.ScalabilityTest$RTTReceiverAgent";
        }
        Properties pp = new Properties();
        if (host != null) {
            pp.setProperty("host", host);
        }
        if (port != null) {
            pp.setProperty("port", port);
        }
        if (connectionManager != null) {
            pp.setProperty("connection-manager", connectionManager);
        }
        if (mediatorClass != null) {
            pp.setProperty("mediator-class", mediatorClass);
        }
        if (maxDiscTime != null) {
            pp.setProperty("max-disconnection-time", maxDiscTime);
        }
        String sName = "S-" + prefix + "-" + index;
        pp.setProperty("msisdn", sName);
        String rName = "R-" + prefix + "-" + index;
        String prop = sName + ":" + senderClass + "(" + rName + ")";
        pp.setProperty("agents", prop);
        pp.setProperty("keep-alive-time", "-1");
        FrontEndContainer fes = new FrontEndContainer(pp);
        pp = new Properties();
        if (host != null) {
            pp.setProperty("host", host);
        }
        if (port != null) {
            pp.setProperty("port", port);
        }
        if (connectionManager != null) {
            pp.setProperty("connection-manager", connectionManager);
        }
        if (mediatorClass != null) {
            pp.setProperty("mediator-class", mediatorClass);
        }
        if (maxDiscTime != null) {
            pp.setProperty("max-disconnection-time", maxDiscTime);
        }
        pp.setProperty("msisdn", rName);
        prop = rName + ":" + receiverClass;
        pp.setProperty("agents", prop);
        pp.setProperty("keep-alive-time", "-1");
        FrontEndContainer fer = new FrontEndContainer(pp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyTerminated(long time, long time2) {
        Object object = terminatedLock;
        synchronized (object) {
            totalTime += time;
            totalTime2 += time2;
            if (++terminatedCnt == nCouples) {
                long n = (long)nCouples * (long)nIterations;
                if (measure == 0) {
                    double totBytes = (double)n * (double)content.length;
                    double averageBitrate = totBytes / (double)totalTime;
                    System.out.println("----------------------------------\nTest completed successufully.\nAverage bitrate (Kbyte/s) = " + averageBitrate + "\n----------------------------------");
                } else if (measure == 1) {
                    long averageRoundTripTime = totalTime / n;
                    double avg = averageRoundTripTime;
                    double x = (double)totalTime2 + (double)n * avg * avg - 2.0 * avg * (double)totalTime;
                    double standardDeviation = Math.sqrt(x / (double)n);
                    System.out.println("----------------------------------\nTest completed successufully.\nAverage round trip time = " + averageRoundTripTime + " ms\nStandard deviation = " + standardDeviation + "\n----------------------------------");
                }
                System.exit(0);
            }
        }
    }

    static {
        readyCnt = 0;
        terminatedCnt = 0;
        totalTime = 0L;
        totalTime2 = 0L;
        lock = new Object();
    }

    public static class RTTReceiverAgent
    extends Agent {
        protected void setup() {
            this.addBehaviour(new CyclicBehaviour(this){

                public void action() {
                    ACLMessage msg = this.myAgent.receive();
                    if (msg != null) {
                        ACLMessage reply = msg.createReply();
                        reply.setPerformative(7);
                        reply.setByteSequenceContent(msg.getByteSequenceContent());
                        this.myAgent.send(reply);
                    } else {
                        this.block();
                    }
                }
            });
        }
    }

    public static class RTTSenderAgent
    extends Agent {
        private ACLMessage msg = new ACLMessage(7);
        private AID myReceiver;
        private MessageTemplate myTemplate;
        private long totalCoupleTime = 0L;
        private long totalCoupleTime2 = 0L;
        private boolean terminated = false;
        private int cnt = 0;

        protected void setup() {
            Object[] args = this.getArguments();
            if (args == null || args.length != 1) {
                System.out.println("Missing receiver name !!!!!");
                this.doDelete();
                return;
            }
            this.myReceiver = new AID((String)args[0], false);
            this.msg.addReceiver(this.myReceiver);
            this.msg.setByteSequenceContent(content);
            this.myTemplate = MessageTemplate.MatchSender(this.myReceiver);
            ScalabilityTest.notifyReady();
            if (timeInterval > 0L) {
                this.addBehaviour(new TickerBehaviour(this, timeInterval){

                    public void onTick() {
                        RTTSenderAgent.this.job();
                    }
                });
            } else {
                this.addBehaviour(new CyclicBehaviour(this){

                    public void action() {
                        RTTSenderAgent.this.job();
                    }
                });
            }
        }

        private void job() {
            long start = System.currentTimeMillis();
            this.send(this.msg);
            this.blockingReceive(this.myTemplate);
            long time = System.currentTimeMillis() - start;
            if (!this.terminated) {
                this.totalCoupleTime += time;
                this.totalCoupleTime2 += time * time;
                if (nIterations > 0 && ++this.cnt >= nIterations) {
                    ScalabilityTest.notifyTerminated(this.totalCoupleTime, this.totalCoupleTime2);
                    this.terminated = true;
                }
            }
            if (timeInterval == -1L) {
                ScalabilityTest.notifyReady();
            }
        }
    }

    public static class BitrateReceiverAgent
    extends Agent {
        private boolean firstReceived = false;
        private boolean terminated = false;
        private long startTime;
        private int cnt = 0;

        protected void setup() {
            this.addBehaviour(new CyclicBehaviour(this){

                public void action() {
                    ACLMessage msg = this.myAgent.receive();
                    if (msg != null) {
                        if (!BitrateReceiverAgent.this.firstReceived) {
                            BitrateReceiverAgent.this.firstReceived = true;
                            BitrateReceiverAgent.this.startTime = System.currentTimeMillis();
                        }
                        if (!BitrateReceiverAgent.this.terminated) {
                            if (nIterations > 0 && BitrateReceiverAgent.this.cnt >= nIterations) {
                                long endTime = System.currentTimeMillis();
                                long totalCoupleTime = endTime - BitrateReceiverAgent.this.startTime;
                                long totalCoupleTime2 = totalCoupleTime * totalCoupleTime;
                                ScalabilityTest.notifyTerminated(totalCoupleTime, totalCoupleTime2);
                                BitrateReceiverAgent.this.terminated = true;
                            }
                            BitrateReceiverAgent.this.cnt++;
                        }
                    } else {
                        this.block();
                    }
                }
            });
        }
    }

    public static class BitrateSenderAgent
    extends Agent {
        private ACLMessage msg = new ACLMessage(7);
        private AID myReceiver;

        protected void setup() {
            Object[] args = this.getArguments();
            if (args == null || args.length != 1) {
                System.out.println("Missing receiver name !!!!!");
                this.doDelete();
                return;
            }
            this.myReceiver = new AID((String)args[0], false);
            this.msg.addReceiver(this.myReceiver);
            this.msg.setByteSequenceContent(content);
            System.out.println("Sender " + this.getName() + " ready: my receiver is " + this.myReceiver.getName());
            ScalabilityTest.notifyReady();
            if (timeInterval > 0L) {
                this.addBehaviour(new TickerBehaviour(this, timeInterval){

                    public void onTick() {
                        BitrateSenderAgent.this.job();
                    }
                });
            } else {
                this.addBehaviour(new CyclicBehaviour(this){

                    public void action() {
                        BitrateSenderAgent.this.job();
                    }
                });
            }
        }

        private void job() {
            this.send(this.msg);
            if (timeInterval == -1L) {
                ScalabilityTest.notifyReady();
            }
        }
    }
}

