/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.messaging.TopicRegistration;
import jade.core.messaging.TopicUtility;
import jade.lang.acl.ACLMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

class TopicTable {
    private TTNode root = new TTNode("", null);

    TopicTable() {
    }

    final synchronized void register(AID aid, AID topic) {
        RegistrationInfo info = new RegistrationInfo(aid, topic);
        this.root.register(info);
    }

    final synchronized void deregister(AID aid, AID topic) {
        RegistrationInfo info = new RegistrationInfo(aid, topic);
        this.root.deregister(info);
    }

    final synchronized Collection getInterestedAgents(AID topic, ACLMessage msg) {
        RegistrationInfo info = new RegistrationInfo(null, topic);
        HashSet s = new HashSet();
        this.root.fillInterestedAgents(info, s);
        return s;
    }

    final synchronized List getAllRegistrations() {
        ArrayList l = new ArrayList();
        this.root.fillRegistrations(l);
        return l;
    }

    final synchronized List getRelevantTopics(AID aid) {
        ArrayList l = new ArrayList();
        this.root.fillRelevantTopics(aid, l);
        return l;
    }

    public String toString() {
        List l = this.getAllRegistrations();
        StringBuffer sb = new StringBuffer("TOPIC-TABLE\n");
        for (TopicRegistration tr : l) {
            sb.append(tr).append('\n');
        }
        return sb.toString();
    }

    private class TTNode {
        private String name;
        private List interestedAgents = new LinkedList();
        private List templateInterestedAgents = new LinkedList();
        private Map children = new HashMap();
        private TTNode parent;

        private TTNode(String name, TTNode parent) {
            this.name = name;
            this.parent = parent;
        }

        private final void register(RegistrationInfo info) {
            String nextName = info.nextName();
            if (nextName != null) {
                TTNode childNode = (TTNode)this.children.get(nextName);
                if (childNode == null) {
                    childNode = new TTNode(nextName, this);
                    this.children.put(nextName, childNode);
                }
                childNode.register(info);
            } else if (info.isTemplate()) {
                this.templateInterestedAgents.add(info.getAID());
            } else {
                this.interestedAgents.add(info.getAID());
            }
        }

        private final void deregister(RegistrationInfo info) {
            String nextName = info.nextName();
            if (nextName != null) {
                TTNode childNode = (TTNode)this.children.get(nextName);
                if (childNode != null) {
                    childNode.deregister(info);
                }
            } else {
                if (info.isTemplate()) {
                    this.templateInterestedAgents.remove(info.getAID());
                } else {
                    this.interestedAgents.remove(info.getAID());
                }
                this.removeIfEmpty();
            }
        }

        private final void fillInterestedAgents(RegistrationInfo info, Collection interestedAgents) {
            interestedAgents.addAll(this.templateInterestedAgents);
            String nextName = info.nextName();
            if (nextName != null) {
                TTNode childNode = (TTNode)this.children.get(nextName);
                if (childNode != null) {
                    childNode.fillInterestedAgents(info, interestedAgents);
                }
            } else {
                interestedAgents.addAll(this.interestedAgents);
            }
        }

        private final void fillRegistrations(List allRegistrations) {
            String topicName = this.getTopicName();
            if (this.interestedAgents.size() > 0) {
                AID topic = TopicUtility.createTopic(topicName);
                for (int i = 0; i < this.interestedAgents.size(); ++i) {
                    AID aid = (AID)this.interestedAgents.get(i);
                    allRegistrations.add(new TopicRegistration(aid, topic));
                }
            }
            if (this.templateInterestedAgents.size() > 0) {
                String templateTopicName = topicName.length() > 0 ? topicName + '.' + "*" : "*";
                AID topic = TopicUtility.createTopic(templateTopicName);
                for (int i = 0; i < this.templateInterestedAgents.size(); ++i) {
                    AID aid = (AID)this.templateInterestedAgents.get(i);
                    allRegistrations.add(new TopicRegistration(aid, topic));
                }
            }
            for (TTNode childNode : this.children.values()) {
                childNode.fillRegistrations(allRegistrations);
            }
        }

        private final void fillRelevantTopics(AID aid, List relevantTopics) {
            String topicName = this.getTopicName();
            if (this.interestedAgents.contains(aid)) {
                relevantTopics.add(TopicUtility.createTopic(topicName));
            }
            if (this.templateInterestedAgents.contains(aid)) {
                String templateTopicName = topicName.length() > 0 ? topicName + '.' + "*" : "*";
                relevantTopics.add(TopicUtility.createTopic(templateTopicName));
            }
            for (TTNode childNode : this.children.values()) {
                childNode.fillRelevantTopics(aid, relevantTopics);
            }
        }

        private final void removeIfEmpty() {
            if (this.interestedAgents.isEmpty() && this.templateInterestedAgents.isEmpty() && this.children.isEmpty()) {
                this.parent.children.remove(this.name);
                if (this.parent != TopicTable.this.root) {
                    this.parent.removeIfEmpty();
                }
            }
        }

        private final String getTopicName() {
            if (this == TopicTable.this.root) {
                return "";
            }
            if (this.parent == TopicTable.this.root) {
                return this.name;
            }
            return this.parent.getTopicName() + "." + this.name;
        }
    }

    private class RegistrationInfo {
        private AID aid;
        private boolean template = false;
        private StringTokenizer st;

        private RegistrationInfo(AID aid, AID topic) {
            this.st = new StringTokenizer(topic.getLocalName(), ".");
            this.aid = aid;
        }

        private String nextName() {
            String name = null;
            if (this.st.hasMoreTokens() && (name = this.st.nextToken()).equals("*")) {
                this.template = true;
                name = null;
            }
            return name;
        }

        private AID getAID() {
            return this.aid;
        }

        private boolean isTemplate() {
            return this.template;
        }
    }
}

