/*
 * Decompiled with CFR 0.152.
 */
package jade.core.nodeMonitoring;

import jade.core.Node;
import jade.core.NodeEventListener;
import jade.core.NodeFailureMonitor;
import jade.core.nodeMonitoring.UDPMonitorServer;
import jade.core.nodeMonitoring.UDPNodeMonitoringService;
import jade.util.Logger;
import jade.util.leap.Collection;

class UDPNodeFailureMonitor
extends NodeFailureMonitor {
    public static final int STATE_CONNECTED = 0;
    public static final int STATE_UNREACHABLE = 1;
    public static final int STATE_FINAL = 2;
    private long deadlineId = -1L;
    private long lastPing = -1L;
    private int state = -1;
    private long key = 0L;
    private UDPMonitorServer server;
    private UDPNodeMonitoringService service;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());

    UDPNodeFailureMonitor(UDPMonitorServer s, UDPNodeMonitoringService svc) {
        this.server = s;
        this.service = svc;
    }

    public void start(Node n, NodeEventListener nel) {
        super.start(n, nel);
        this.setState(0);
        this.key = System.currentTimeMillis();
        this.service.activateUDP(this.target, this.key);
        this.server.register(this);
    }

    public void stop() {
        this.server.deregister(this);
        this.service.deactivateUDP(this.target, this.key);
    }

    public Collection getChildNodes() {
        return this.childNodes.values();
    }

    public long getLastPing() {
        return this.lastPing;
    }

    public long getDeadlineID() {
        return this.deadlineId;
    }

    void setDeadlineID(long time) {
        this.deadlineId = time;
    }

    public int getState() {
        return this.state;
    }

    void setState(int newState) {
        if (this.logger.isLoggable(Logger.FINEST)) {
            this.logger.log(Logger.FINEST, "Transition to state " + newState + " for node '" + this.target.getName() + "'");
        }
        if (this.state == -1 && newState == 0) {
            this.fireNodeAdded();
        } else if (this.state == 0 && newState == 1) {
            this.fireNodeUnreachable();
        } else if (this.state == 1 && newState == 0) {
            this.fireNodeReachable();
        } else if (newState == 2) {
            this.fireNodeRemoved();
            this.server.deregister(this);
        }
        this.state = newState;
    }

    void setLastPing(long time) {
        this.lastPing = time;
    }
}

