/*
 * Decompiled with CFR 0.152.
 */
package jade.gui;

import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.gui.VisualPropertiesList;
import jade.gui.VisualStringList;
import jade.lang.acl.ISO8601;
import jade.util.leap.Iterator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ServiceDscDlg
extends JDialog {
    JTextField txtName;
    JTextField txtType;
    JTextField txtOwner;
    VisualStringList ontologiesListPanel;
    VisualStringList protocolsListPanel;
    VisualStringList languagesListPanel;
    VisualPropertiesList propertiesListPanel;
    ServiceDescription serviceDesc;
    ServiceDescription out;
    boolean editable;
    boolean checkSlots;

    ServiceDscDlg(Frame parent) {
        super(parent);
    }

    ServiceDscDlg(Dialog parent) {
        super(parent);
    }

    ServiceDescription viewSD(ServiceDescription dsc, boolean ed, boolean checkMandatorySlots) {
        this.setTitle("Service");
        this.out = null;
        this.editable = ed;
        this.checkSlots = checkMandatorySlots;
        this.serviceDesc = dsc != null ? dsc : new ServiceDescription();
        JPanel main = new JPanel();
        main.setLayout(new BoxLayout(main, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JLabel l = new JLabel("Name");
        l.setPreferredSize(new Dimension(130, 20));
        p.add(l);
        p.add(Box.createHorizontalGlue());
        this.txtName = new JTextField();
        this.txtName.setPreferredSize(new Dimension(200, 20));
        this.txtName.setText(this.serviceDesc.getName());
        this.txtName.setEditable(this.editable);
        p.add(this.txtName);
        main.add(p);
        main.add(Box.createRigidArea(new Dimension(0, 3)));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        l = new JLabel("Type");
        l.setPreferredSize(new Dimension(130, 20));
        p.add(l);
        p.add(Box.createHorizontalGlue());
        this.txtType = new JTextField();
        this.txtType.setPreferredSize(new Dimension(200, 20));
        this.txtType.setText(this.serviceDesc.getType());
        this.txtType.setEditable(this.editable);
        p.add(this.txtType);
        main.add(p);
        main.add(Box.createRigidArea(new Dimension(0, 3)));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        l = new JLabel("Ownership");
        l.setPreferredSize(new Dimension(130, 20));
        p.add(l);
        p.add(Box.createHorizontalGlue());
        this.txtOwner = new JTextField();
        this.txtOwner.setPreferredSize(new Dimension(200, 20));
        this.txtOwner.setText(this.serviceDesc.getOwnership());
        this.txtOwner.setEditable(this.editable);
        p.add(this.txtOwner);
        main.add(p);
        main.add(Box.createRigidArea(new Dimension(0, 3)));
        p = new JPanel();
        p.setLayout(new BorderLayout());
        p.setBorder(BorderFactory.createTitledBorder("Languages"));
        this.languagesListPanel = new VisualStringList(this.serviceDesc.getAllLanguages(), this.getOwner());
        this.languagesListPanel.setDimension(new Dimension(350, 40));
        this.languagesListPanel.setEnabled(this.editable);
        p.add(this.languagesListPanel);
        main.add(p);
        main.add(Box.createRigidArea(new Dimension(0, 3)));
        p = new JPanel();
        p.setLayout(new BorderLayout());
        p.setBorder(BorderFactory.createTitledBorder("Ontologies"));
        this.ontologiesListPanel = new VisualStringList(this.serviceDesc.getAllOntologies(), this.getOwner());
        this.ontologiesListPanel.setDimension(new Dimension(350, 40));
        this.ontologiesListPanel.setEnabled(this.editable);
        p.add(this.ontologiesListPanel);
        main.add(p);
        main.add(Box.createRigidArea(new Dimension(0, 3)));
        p = new JPanel();
        p.setLayout(new BorderLayout());
        p.setBorder(BorderFactory.createTitledBorder("Protocols"));
        this.protocolsListPanel = new VisualStringList(this.serviceDesc.getAllProtocols(), this.getOwner());
        this.protocolsListPanel.setDimension(new Dimension(350, 40));
        this.protocolsListPanel.setEnabled(this.editable);
        p.add(this.protocolsListPanel);
        main.add(p);
        p = new JPanel();
        p.setLayout(new BorderLayout());
        p.setBorder(BorderFactory.createTitledBorder("Properties"));
        Iterator temp = this.serviceDesc.getAllProperties();
        Properties props = new Properties();
        while (temp.hasNext()) {
            Property singleProp = (Property)temp.next();
            props.setProperty(singleProp.getName(), singleProp.getValue().toString());
        }
        this.propertiesListPanel = new VisualPropertiesList(props, (Component)this.getOwner());
        this.propertiesListPanel.setDimension(new Dimension(350, 40));
        this.propertiesListPanel.setEnabled(this.editable);
        p.add(this.propertiesListPanel);
        main.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JButton bOK = new JButton("OK");
        bOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String param = e.getActionCommand();
                if (param.equals("OK")) {
                    if (ServiceDscDlg.this.editable) {
                        if (ServiceDscDlg.this.checkSlots) {
                            if (ServiceDscDlg.this.getSaveText(ServiceDscDlg.this.txtName) == null) {
                                JOptionPane.showMessageDialog(null, "The name must not be empty !", "Error Message", 0);
                                return;
                            }
                            if (ServiceDscDlg.this.getSaveText(ServiceDscDlg.this.txtType) == null) {
                                JOptionPane.showMessageDialog(null, "The type must not be empty !", "Error Message", 0);
                                return;
                            }
                        }
                        ServiceDscDlg.this.out = new ServiceDescription();
                        ServiceDscDlg.this.out.setName(ServiceDscDlg.this.getSaveText(ServiceDscDlg.this.txtName));
                        ServiceDscDlg.this.out.setType(ServiceDscDlg.this.getSaveText(ServiceDscDlg.this.txtType));
                        ServiceDscDlg.this.out.setOwnership(ServiceDscDlg.this.getSaveText(ServiceDscDlg.this.txtOwner));
                        Enumeration lang = ServiceDscDlg.this.languagesListPanel.getContent();
                        while (lang.hasMoreElements()) {
                            ServiceDscDlg.this.out.addLanguages((String)lang.nextElement());
                        }
                        Enumeration onto = ServiceDscDlg.this.ontologiesListPanel.getContent();
                        while (onto.hasMoreElements()) {
                            ServiceDscDlg.this.out.addOntologies((String)onto.nextElement());
                        }
                        Enumeration proto = ServiceDscDlg.this.protocolsListPanel.getContent();
                        while (proto.hasMoreElements()) {
                            ServiceDscDlg.this.out.addProtocols((String)proto.nextElement());
                        }
                        Properties ps = ServiceDscDlg.this.propertiesListPanel.getContentProperties();
                        Enumeration<?> keys = ps.propertyNames();
                        while (keys.hasMoreElements()) {
                            Property tp = new Property();
                            String key = (String)keys.nextElement();
                            tp.setName(key);
                            Object val = ps.getProperty(key);
                            try {
                                val = Long.valueOf(val.toString());
                            }
                            catch (NumberFormatException e1) {
                                try {
                                    val = Double.valueOf(val.toString());
                                }
                                catch (NumberFormatException e2) {
                                    try {
                                        val = ISO8601.toDate(val.toString());
                                    }
                                    catch (Exception e3) {
                                        // empty catch block
                                    }
                                }
                            }
                            tp.setValue((Serializable)val);
                            ServiceDscDlg.this.out.addProperties(tp);
                        }
                    } else {
                        ServiceDscDlg.this.out = ServiceDscDlg.this.serviceDesc;
                    }
                    ServiceDscDlg.this.dispose();
                }
            }
        });
        p.add(bOK);
        if (this.editable) {
            JButton bCancel = new JButton("Cancel");
            p.add(bCancel);
            bCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String param = e.getActionCommand();
                    if (param.equals("Cancel")) {
                        ServiceDscDlg.this.out = null;
                        ServiceDscDlg.this.dispose();
                    }
                }
            });
            p.add(bCancel);
        }
        main.add(p);
        this.getContentPane().add((Component)main, "Center");
        this.setModal(true);
        this.setResizable(false);
        try {
            int x = this.getOwner().getX() + (this.getOwner().getWidth() - this.getWidth()) / 2;
            int y = this.getOwner().getY() + (this.getOwner().getHeight() - this.getHeight()) / 2;
            this.setLocation(x > 0 ? x : 0, y > 0 ? y : 0);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.pack();
        this.show();
        return this.out;
    }

    private String getSaveText(JTextField field) {
        try {
            String out = field.getText().trim();
            return out.length() == 0 ? null : out;
        }
        catch (Exception e) {
            return null;
        }
    }
}

