/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.IMTPException;
import jade.imtp.leap.Command;
import jade.imtp.leap.Dispatcher;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.LEAPSerializationException;
import jade.imtp.leap.SerializationEngine;
import jade.util.Logger;
import java.util.Vector;

public class MicroStub {
    protected Dispatcher myDispatcher;
    protected Vector pendingCommands = new Vector();
    private int activeCnt = 0;
    private boolean flushing = false;
    private Thread flusher;
    protected Logger logger;

    public MicroStub(Dispatcher d) {
        this.myDispatcher = d;
        this.logger = Logger.getMyLogger(this.getClass().getName());
    }

    protected Command executeRemotely(Command c, long timeout) throws IMTPException {
        try {
            Command r;
            this.disableFlush();
            byte[] cmd = SerializationEngine.serialize(c);
            byte[] rsp = this.myDispatcher.dispatch(cmd, this.flushing);
            if (this.pendingCommands.size() > 0) {
                System.out.println("############# Dispatch succeeded with " + this.pendingCommands.size() + " pending commands.");
            }
            if ((r = SerializationEngine.deserialize(rsp)).getCode() == 2) {
                if (!((Boolean)r.getParamAt(0)).booleanValue()) {
                    String msg = new String("Exception " + (String)r.getParamAt(1) + " occurred in remote site processing command " + c.getCode() + ". " + (String)r.getParamAt(2));
                    this.logger.log(Logger.SEVERE, msg);
                    throw new IMTPException(msg);
                }
                if (((String)r.getParamAt(1)).equals("jade.core.IMTPException")) {
                    throw new IMTPException((String)r.getParamAt(2));
                }
            }
            Command command = r;
            return command;
        }
        catch (ICPException icpe) {
            if (timeout == 0L) {
                throw new IMTPException("Destination unreachable", icpe);
            }
            this.logger.log(Logger.WARNING, "Dispatch failed. Command postponed. " + icpe.getMessage());
            this.postpone(c);
            Command command = null;
            return command;
        }
        catch (LEAPSerializationException lse) {
            throw new IMTPException("Serialization error", lse);
        }
        finally {
            this.enableFlush();
        }
    }

    private void postpone(Command c) {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, Thread.currentThread().toString() + ": Command " + c.getCode() + " postponed");
        }
        this.pendingCommands.addElement(c);
        int size = this.pendingCommands.size();
        if (size > 100 && size < 110) {
            this.logger.log(Logger.WARNING, size + " postponed commands");
        }
    }

    public boolean flush() {
        if (this.pendingCommands.size() > 0) {
            this.flusher = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Vector vector = MicroStub.this.pendingCommands;
                    synchronized (vector) {
                        while (MicroStub.this.activeCnt > 0) {
                            try {
                                MicroStub.this.pendingCommands.wait();
                            }
                            catch (InterruptedException ie) {}
                        }
                        MicroStub.this.flushing = true;
                    }
                    MicroStub.this.logger.log(Logger.INFO, "Start flushing");
                    int flushedCnt = 0;
                    Command c = null;
                    while ((c = MicroStub.this.removeFirst()) != null) {
                        try {
                            if (MicroStub.this.logger.isLoggable(Logger.FINE)) {
                                MicroStub.this.logger.log(Logger.FINE, "Flushing command: code = " + c.getCode());
                            }
                            Command r = MicroStub.this.executeRemotely(c, 0L);
                            ++flushedCnt;
                            if (r.getCode() != 2) continue;
                            MicroStub.this.logger.log(Logger.SEVERE, "Remote exception in command asynchronous delivery. " + r.getParamAt(2));
                        }
                        catch (Exception ex) {
                            MicroStub.this.logger.log(Logger.WARNING, "Exception in command asynchronous delivery. " + ex);
                            MicroStub.this.pendingCommands.insertElementAt(c, 0);
                            break;
                        }
                    }
                    System.out.println("########## " + MicroStub.this.pendingCommands.size() + " pending commands after flush");
                    Vector vector2 = MicroStub.this.pendingCommands;
                    synchronized (vector2) {
                        MicroStub.this.flushing = false;
                        MicroStub.this.pendingCommands.notifyAll();
                    }
                    MicroStub.this.logger.log(Logger.INFO, "Flushing thread terminated (" + flushedCnt + ")");
                }
            };
            this.flusher.start();
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.pendingCommands.size() == 0 && !this.flushing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableFlush() {
        if (Thread.currentThread() != this.flusher) {
            Vector vector = this.pendingCommands;
            synchronized (vector) {
                while (this.flushing) {
                    try {
                        this.pendingCommands.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ++this.activeCnt;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableFlush() {
        if (Thread.currentThread() != this.flusher) {
            Vector vector = this.pendingCommands;
            synchronized (vector) {
                --this.activeCnt;
                if (this.activeCnt == 0) {
                    this.pendingCommands.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Command removeFirst() {
        Vector vector = this.pendingCommands;
        synchronized (vector) {
            Command c = null;
            if (this.pendingCommands.size() > 0) {
                c = (Command)this.pendingCommands.elementAt(0);
                this.pendingCommands.removeElementAt(0);
            }
            return c;
        }
    }
}

