/*
 * Decompiled with CFR 0.152.
 */
package jade.lang.acl;

import jade.core.AID;
import jade.core.CaseInsensitiveString;
import jade.core.messaging.TopicUtility;
import jade.lang.acl.ACLMessage;
import jade.util.leap.Iterator;
import jade.util.leap.Serializable;
import java.util.Date;

public class MessageTemplate
implements Serializable {
    private static final int CONVERSATION_ID = 0;
    private static final int ENCODING = 1;
    private static final int IN_REPLY_TO = 2;
    private static final int LANGUAGE = 3;
    private static final int ONTOLOGY = 4;
    private static final int PROTOCOL = 5;
    private static final int REPLY_BY = 6;
    private static final int REPLY_WITH = 7;
    private static final int RECEIVER = 9;
    private static final int REPLY_TO = 10;
    private static final int PERFORMATIVE = 11;
    private static final int CONTENT = 12;
    private static final int SENDER = 13;
    private static final int REPLY_BY_DATE = 14;
    private MatchExpression toMatch;

    public MessageTemplate(MatchExpression e) {
        this.toMatch = e;
    }

    public static MessageTemplate MatchAll() {
        return new MessageTemplate(new MatchAllLiteral());
    }

    public static MessageTemplate MatchSender(AID value) {
        return new MessageTemplate(new Literal(value));
    }

    public static MessageTemplate MatchReceiver(AID[] values) {
        return new MessageTemplate(new Literal(values, 9));
    }

    public static MessageTemplate MatchTopic(AID topic) {
        return new MessageTemplate(new MatchTopic(topic));
    }

    public static MessageTemplate MatchContent(String value) {
        return new MessageTemplate(new Literal(value, 12));
    }

    public static MessageTemplate MatchReplyWith(String value) {
        return new MessageTemplate(new Literal(value, 7));
    }

    public static MessageTemplate MatchInReplyTo(String value) {
        return new MessageTemplate(new Literal(value, 2));
    }

    public static MessageTemplate MatchReplyTo(AID[] values) {
        return new MessageTemplate(new Literal(values, 10));
    }

    public static MessageTemplate MatchLanguage(String value) {
        return new MessageTemplate(new Literal(value, 3));
    }

    public static MessageTemplate MatchEncoding(String value) {
        return new MessageTemplate(new Literal(value, 1));
    }

    public static MessageTemplate MatchOntology(String value) {
        return new MessageTemplate(new Literal(value, 4));
    }

    public static MessageTemplate MatchReplyByDate(Date value) {
        return new MessageTemplate(new Literal(value));
    }

    public static MessageTemplate MatchProtocol(String value) {
        return new MessageTemplate(new Literal(value, 5));
    }

    public static MessageTemplate MatchConversationId(String value) {
        return new MessageTemplate(new Literal(value, 0));
    }

    public static MessageTemplate MatchPerformative(int value) {
        return new MessageTemplate(new Literal(value));
    }

    public static MessageTemplate MatchCustom(ACLMessage msg, boolean matchPerformative) {
        ACLMessage message = (ACLMessage)msg.clone();
        return new MessageTemplate(new CustomMsgLiteral(message, matchPerformative));
    }

    public static MessageTemplate and(MessageTemplate op1, MessageTemplate op2) {
        AndExpression e = new AndExpression(op1.toMatch, op2.toMatch);
        MessageTemplate result = new MessageTemplate(e);
        return result;
    }

    public static MessageTemplate or(MessageTemplate op1, MessageTemplate op2) {
        OrExpression e = new OrExpression(op1.toMatch, op2.toMatch);
        MessageTemplate result = new MessageTemplate(e);
        return result;
    }

    public static MessageTemplate not(MessageTemplate op) {
        NotExpression e = new NotExpression(op.toMatch);
        MessageTemplate result = new MessageTemplate(e);
        return result;
    }

    public boolean match(ACLMessage msg) {
        return this.toMatch.match(msg);
    }

    public String toString() {
        return this.toMatch.toString();
    }

    private static class MatchTopic
    implements MatchExpression {
        private String topicName;
        private boolean isTemplate;
        private boolean matchAll = false;

        MatchTopic(AID topic) {
            String tmp = topic.getLocalName();
            if (tmp.equals("*")) {
                this.matchAll = true;
            } else if (tmp.endsWith(".*")) {
                this.topicName = tmp.substring(0, tmp.length() - 2);
                this.isTemplate = true;
            } else {
                this.topicName = tmp;
                this.isTemplate = false;
            }
        }

        public boolean match(ACLMessage msg) {
            Iterator it = msg.getAllReceiver();
            while (it.hasNext()) {
                AID receiver = (AID)it.next();
                if (!TopicUtility.isTopic(receiver)) continue;
                if (this.matchAll) {
                    return true;
                }
                String name = receiver.getLocalName();
                if (name.equals(this.topicName)) {
                    return true;
                }
                if (!this.isTemplate || !name.startsWith(this.topicName + '.')) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            String name = this.matchAll ? "*" : (this.isTemplate ? this.topicName + '.' + "*" : this.topicName);
            return "( Topic: " + name + " )";
        }
    }

    private static class CustomMsgLiteral
    implements MatchExpression {
        ACLMessage messageToMatch;
        boolean matchPerformative;

        CustomMsgLiteral(ACLMessage msg, boolean matchPerformative) {
            this.messageToMatch = msg;
            this.matchPerformative = matchPerformative;
        }

        private static boolean compareByteArrays(byte[] a, byte[] a2) {
            if (a == a2) {
                return true;
            }
            if (a == null || a2 == null) {
                return false;
            }
            int length = a.length;
            if (a2.length != length) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (a[i] == a2[i]) continue;
                return false;
            }
            return true;
        }

        public boolean match(ACLMessage msg) {
            if (this.matchPerformative && this.messageToMatch.getPerformative() != msg.getPerformative()) {
                return false;
            }
            if (this.messageToMatch.hasByteSequenceContent()) {
                if (!CustomMsgLiteral.compareByteArrays(this.messageToMatch.getByteSequenceContent(), msg.getByteSequenceContent())) {
                    return false;
                }
                if (!this.match(this.messageToMatch.getContent(), msg.getContent())) {
                    return false;
                }
            }
            if (!this.match(this.messageToMatch.getConversationId(), msg.getConversationId())) {
                return false;
            }
            if (!this.match(this.messageToMatch.getEncoding(), msg.getEncoding())) {
                return false;
            }
            if (!this.match(this.messageToMatch.getInReplyTo(), msg.getInReplyTo())) {
                return false;
            }
            if (!this.match(this.messageToMatch.getLanguage(), msg.getLanguage())) {
                return false;
            }
            if (!this.match(this.messageToMatch.getOntology(), msg.getOntology())) {
                return false;
            }
            if (!this.match(this.messageToMatch.getProtocol(), msg.getProtocol())) {
                return false;
            }
            if (!this.match(this.messageToMatch.getReplyWith(), msg.getReplyWith())) {
                return false;
            }
            if (!this.match(this.messageToMatch.getReplyByDate(), msg.getReplyByDate())) {
                return false;
            }
            Iterator it1 = this.messageToMatch.getAllReceiver();
            while (it1.hasNext()) {
                boolean found = false;
                AID rec = (AID)it1.next();
                Iterator it2 = msg.getAllReceiver();
                while (it2.hasNext()) {
                    if (!rec.equals((AID)it2.next())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            Iterator it3 = this.messageToMatch.getAllReceiver();
            while (it3.hasNext()) {
                boolean found = false;
                AID rec = (AID)it3.next();
                Iterator it2 = msg.getAllReceiver();
                while (it2.hasNext()) {
                    if (!rec.equals((AID)it2.next())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return this.messageToMatch.getSender() == null || this.messageToMatch.getSender().equals(msg.getSender());
        }

        private boolean match(String template, String actualValue) {
            if (template == null) {
                return true;
            }
            return CaseInsensitiveString.equalsIgnoreCase(template, actualValue);
        }

        private boolean match(Date template, Date actualValue) {
            if (template == null) {
                return true;
            }
            return template.equals(actualValue);
        }

        public String toString() {
            String output = this.matchPerformative ? "match the performative " : "no match on performative ";
            return output + this.messageToMatch.toString();
        }
    }

    private static class MatchAllLiteral
    implements MatchExpression {
        MatchAllLiteral() {
        }

        public boolean match(ACLMessage msg) {
            return true;
        }

        public String toString() {
            return "Match ALL Template";
        }
    }

    private static class Literal
    implements MatchExpression {
        Object matchValue;
        int perfValue;
        int slotName;

        Literal(String matchValue, int slotName) {
            this.matchValue = matchValue;
            this.slotName = slotName;
        }

        Literal(AID matchValue) {
            this.matchValue = matchValue;
            this.slotName = 13;
        }

        Literal(AID[] matchValue, int slotName) {
            this.matchValue = matchValue;
            this.slotName = slotName;
        }

        Literal(int matchValue) {
            this.perfValue = matchValue;
            this.slotName = 11;
        }

        Literal(Date matchValue) {
            this.matchValue = matchValue;
            this.slotName = 14;
        }

        public boolean match(ACLMessage msg) {
            switch (this.slotName) {
                case 0: {
                    return CaseInsensitiveString.equalsIgnoreCase((String)this.matchValue, msg.getConversationId());
                }
                case 7: {
                    return CaseInsensitiveString.equalsIgnoreCase((String)this.matchValue, msg.getReplyWith());
                }
                case 11: {
                    return this.perfValue == msg.getPerformative();
                }
                case 3: {
                    return CaseInsensitiveString.equalsIgnoreCase((String)this.matchValue, msg.getLanguage());
                }
                case 4: {
                    return CaseInsensitiveString.equalsIgnoreCase((String)this.matchValue, msg.getOntology());
                }
                case 5: {
                    return CaseInsensitiveString.equalsIgnoreCase((String)this.matchValue, msg.getProtocol());
                }
                case 1: {
                    return CaseInsensitiveString.equalsIgnoreCase((String)this.matchValue, msg.getEncoding());
                }
                case 2: {
                    return CaseInsensitiveString.equalsIgnoreCase((String)this.matchValue, msg.getInReplyTo());
                }
                case 14: {
                    return ((Date)this.matchValue).equals(msg.getReplyByDate());
                }
                case 9: {
                    if (this.matchValue != null) {
                        AID[] receivers = (AID[])this.matchValue;
                        for (int i = 0; i < receivers.length; ++i) {
                            AID recToMatch = receivers[i];
                            Iterator rec = msg.getAllReceiver();
                            boolean found = false;
                            while (rec.hasNext()) {
                                if (!recToMatch.equals((AID)rec.next())) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                case 10: {
                    if (this.matchValue != null) {
                        AID[] receivers = (AID[])this.matchValue;
                        for (int i = 0; i < receivers.length; ++i) {
                            AID recToMatch = receivers[i];
                            Iterator rec = msg.getAllReplyTo();
                            boolean found = false;
                            while (rec.hasNext()) {
                                if (!recToMatch.equals((AID)rec.next())) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                case 12: {
                    return CaseInsensitiveString.equalsIgnoreCase((String)this.matchValue, msg.getContent());
                }
                case 13: {
                    if (this.matchValue != null) {
                        return ((AID)this.matchValue).equals(msg.getSender());
                    }
                    return false;
                }
            }
            return false;
        }

        public String toString() {
            switch (this.slotName) {
                case 0: {
                    return "(ConversationId: " + (String)this.matchValue + ")";
                }
                case 1: {
                    return "( Encoding: " + (String)this.matchValue + " )";
                }
                case 2: {
                    return "( InReplyTo: " + (String)this.matchValue + " )";
                }
                case 3: {
                    return "( Language: " + (String)this.matchValue + " )";
                }
                case 4: {
                    return "( Ontology: " + (String)this.matchValue + " )";
                }
                case 5: {
                    return "( Protocol: " + (String)this.matchValue + " )";
                }
                case 14: {
                    return "( ReplyByDate: " + (Date)this.matchValue + " )";
                }
                case 7: {
                    return "( ReplyWith: " + (String)this.matchValue + " )";
                }
                case 9: {
                    if (this.matchValue != null) {
                        AID[] receivers = (AID[])this.matchValue;
                        String output = "( Receivers: ";
                        for (int i = 0; i < receivers.length; ++i) {
                            AID recToMatch = receivers[i];
                            output = output + recToMatch.toString();
                        }
                        return output + ")";
                    }
                    return "(Receivers: null)";
                }
                case 10: {
                    if (this.matchValue != null) {
                        AID[] receivers = (AID[])this.matchValue;
                        String output = "( ReplyTo: ";
                        for (int i = 0; i < receivers.length; ++i) {
                            AID recToMatch = receivers[i];
                            output = output + recToMatch.toString();
                        }
                        return output + " )";
                    }
                    return "(ReplyTo: null)";
                }
                case 11: {
                    return "( Perfomative: " + ACLMessage.getPerformative(this.perfValue) + " )";
                }
                case 12: {
                    return "( Content: " + (String)this.matchValue + ")";
                }
                case 13: {
                    if (this.matchValue != null) {
                        return "( Sender AID: " + ((AID)this.matchValue).toString() + ")";
                    }
                    return "(Sender AID: null)";
                }
            }
            return "No slot. This casa should never occur !!!";
        }
    }

    private static class NotExpression
    implements MatchExpression {
        private MatchExpression op;

        public NotExpression(MatchExpression e) {
            this.op = e;
        }

        public boolean match(ACLMessage msg) {
            return !this.op.match(msg);
        }

        public String toString() {
            return "(NOT " + this.op.toString() + ")";
        }
    }

    private static class OrExpression
    implements MatchExpression {
        private MatchExpression op1;
        private MatchExpression op2;

        public OrExpression(MatchExpression e1, MatchExpression e2) {
            this.op1 = e1;
            this.op2 = e2;
        }

        public boolean match(ACLMessage msg) {
            return this.op1.match(msg) || this.op2.match(msg);
        }

        public String toString() {
            return "(" + this.op1.toString() + " OR " + this.op2.toString() + ")";
        }
    }

    private static class AndExpression
    implements MatchExpression {
        private MatchExpression op1;
        private MatchExpression op2;

        public AndExpression(MatchExpression e1, MatchExpression e2) {
            this.op1 = e1;
            this.op2 = e2;
        }

        public boolean match(ACLMessage msg) {
            return this.op1.match(msg) && this.op2.match(msg);
        }

        public String toString() {
            return "(" + this.op1.toString() + " AND " + this.op2.toString() + ")";
        }
    }

    public static interface MatchExpression
    extends Serializable {
        public boolean match(ACLMessage var1);
    }
}

