/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.SimpleBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.states.MsgReceiver;
import jade.proto.states.ReplySender;
import java.util.Date;

abstract class SSResponder
extends FSMBehaviour {
    public final String INITIATION_KEY = "__Initiation_key" + this.hashCode();
    public final String RECEIVED_KEY = "__Received_key" + this.hashCode();
    public final String REPLY_KEY = "__Reply_key" + this.hashCode();
    private static final int OUT_OF_SEQUENCE_EXIT_CODE = -98765;
    protected static final String RECEIVE_NEXT = "Receive-Next";
    protected static final String CHECK_IN_SEQ = "Check-In-seq";
    protected static final String HANDLE_OUT_OF_SEQUENCE = "Handle-Out-of-seq";
    protected static final String SEND_REPLY = "Send-Reply";
    protected static final String DUMMY_FINAL = "Dummy-Final";
    private ACLMessage initiation;
    private String initiationKey;

    public SSResponder(Agent a, ACLMessage initiation, DataStore store, boolean useInitiationKey) {
        super(a);
        this.setDataStore(store);
        this.initiation = initiation;
        this.initiationKey = useInitiationKey ? this.INITIATION_KEY : this.RECEIVED_KEY;
        this.registerDefaultTransition(RECEIVE_NEXT, CHECK_IN_SEQ);
        this.registerTransition(CHECK_IN_SEQ, HANDLE_OUT_OF_SEQUENCE, -98765);
        this.registerDefaultTransition(HANDLE_OUT_OF_SEQUENCE, RECEIVE_NEXT, new String[]{HANDLE_OUT_OF_SEQUENCE});
        this.registerDefaultTransition(SEND_REPLY, DUMMY_FINAL);
        SimpleBehaviour b = new NextMsgReceiver(this.myAgent, this.getDataStore(), this.RECEIVED_KEY);
        this.registerState(b, RECEIVE_NEXT);
        b = new SeqChecker(this.myAgent);
        this.registerDSState(b, CHECK_IN_SEQ);
        b = new OutOfSeqHandler(this.myAgent);
        this.registerDSState(b, HANDLE_OUT_OF_SEQUENCE);
        b = new NextReplySender(this.myAgent, this.REPLY_KEY, this.initiationKey);
        this.registerDSState(b, SEND_REPLY);
        b = new DummyFinal(this.myAgent);
        this.registerLastState(b, DUMMY_FINAL);
        b.setDataStore(this.getDataStore());
    }

    public void onStart() {
        this.getDataStore().put(this.initiationKey, this.initiation);
        super.onStart();
    }

    protected void handleOutOfSequence(ACLMessage msg) {
    }

    public void registerHandleOutOfSequence(Behaviour b) {
        this.registerDSState(b, HANDLE_OUT_OF_SEQUENCE);
    }

    public void reset() {
        this.reinit();
        super.reset();
    }

    protected void reinit() {
        DataStore ds = this.getDataStore();
        ds.remove(this.RECEIVED_KEY);
        ds.remove(this.REPLY_KEY);
        this.setMessageToReplyKey(this.initiationKey);
    }

    protected boolean checkInSequence(ACLMessage received) {
        return false;
    }

    protected void beforeReply(ACLMessage reply) {
    }

    protected void afterReply(ACLMessage reply) {
    }

    protected void sessionTerminated() {
    }

    protected void registerDSState(Behaviour b, String name) {
        b.setDataStore(this.getDataStore());
        this.registerState(b, name);
    }

    private void setMessageToReplyKey(String key) {
        ReplySender rs = (ReplySender)this.getState(SEND_REPLY);
        rs.setMsgKey(key);
    }

    private static class DummyFinal
    extends OneShotBehaviour {
        private static final long serialVersionUID = 4487495895818005L;

        public DummyFinal(Agent a) {
            super(a);
        }

        public void action() {
            SSResponder parent = (SSResponder)this.getParent();
            parent.sessionTerminated();
        }
    }

    private static class NextReplySender
    extends ReplySender {
        private static final long serialVersionUID = 4487495895818004L;

        public NextReplySender(Agent a, String replyKey, String msgKey) {
            super(a, replyKey, msgKey);
        }

        public void onStart() {
            SSResponder parent = (SSResponder)this.getParent();
            ACLMessage reply = (ACLMessage)this.getDataStore().get(parent.REPLY_KEY);
            parent.beforeReply(reply);
        }

        public int onEnd() {
            int ret = super.onEnd();
            SSResponder parent = (SSResponder)this.getParent();
            ACLMessage reply = (ACLMessage)this.getDataStore().get(parent.REPLY_KEY);
            if (reply != null) {
                MsgReceiver mr = (MsgReceiver)parent.getState(SSResponder.RECEIVE_NEXT);
                mr.setTemplate(this.createNextMsgTemplate(reply));
                Date d = reply.getReplyByDate();
                if (d != null && d.getTime() > System.currentTimeMillis()) {
                    mr.setDeadline(d.getTime());
                } else {
                    mr.setDeadline(-1L);
                }
            }
            parent.afterReply(reply);
            return ret;
        }

        private MessageTemplate createNextMsgTemplate(ACLMessage reply) {
            return MessageTemplate.and(MessageTemplate.MatchConversationId(reply.getConversationId()), MessageTemplate.not(MessageTemplate.MatchCustom(reply, true)));
        }
    }

    private static class OutOfSeqHandler
    extends OneShotBehaviour {
        private static final long serialVersionUID = 4487495895818003L;

        public OutOfSeqHandler(Agent a) {
            super(a);
        }

        public void action() {
            SSResponder parent = (SSResponder)this.getParent();
            parent.handleOutOfSequence((ACLMessage)this.getDataStore().get(parent.RECEIVED_KEY));
        }
    }

    private static class SeqChecker
    extends OneShotBehaviour {
        private int ret;
        private static final long serialVersionUID = 4487495895818002L;

        public SeqChecker(Agent a) {
            super(a);
        }

        public void action() {
            SSResponder parent = (SSResponder)this.getParent();
            ACLMessage received = (ACLMessage)this.getDataStore().get(parent.RECEIVED_KEY);
            this.ret = received != null && parent.checkInSequence(received) ? received.getPerformative() : -98765;
        }

        public int onEnd() {
            return this.ret;
        }
    }

    private static class NextMsgReceiver
    extends MsgReceiver {
        private static final long serialVersionUID = 4487495895818001L;

        public NextMsgReceiver(Agent a, DataStore ds, String key) {
            super(a, null, -1L, ds, key);
        }

        public int onEnd() {
            SSResponder parent = (SSResponder)this.getParent();
            parent.setMessageToReplyKey((String)this.receivedMsgKey);
            return super.onEnd();
        }
    }
}

