/*
 * Decompiled with CFR 0.152.
 */
package jade.wrapper.gateway;

import jade.core.AID;
import jade.core.Agent;
import jade.core.ProfileImpl;
import jade.core.Runtime;
import jade.util.Event;
import jade.util.Logger;
import jade.util.leap.Properties;
import jade.wrapper.AgentController;
import jade.wrapper.ContainerController;
import jade.wrapper.ControllerException;
import jade.wrapper.StaleProxyException;
import jade.wrapper.gateway.GatewayAgent;
import jade.wrapper.gateway.GatewayListener;
import java.util.ArrayList;
import java.util.List;

public class DynamicJadeGateway {
    private static final int UNKNOWN = -1;
    private static final int ACTIVE = 1;
    private static final int NOT_ACTIVE = 2;
    private ContainerController myContainer = null;
    private AgentController myAgent = null;
    private String agentType;
    private ProfileImpl profile;
    private Properties jadeProps;
    private Object[] agentArguments;
    private int gatewayAgentState = -1;
    private List<GatewayListener> listeners = new ArrayList<GatewayListener>();
    private volatile GatewayListener[] listenersArray = new GatewayListener[0];
    private static Logger myLogger = Logger.getMyLogger(DynamicJadeGateway.class.getName());

    public final String getProfileProperty(String key, String defaultValue) {
        return this.profile.getParameter(key, defaultValue);
    }

    public final void execute(Object command) throws StaleProxyException, ControllerException, InterruptedException {
        this.execute(command, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(Object command, long timeout) throws StaleProxyException, ControllerException, InterruptedException {
        Event e = null;
        DynamicJadeGateway dynamicJadeGateway = this;
        synchronized (dynamicJadeGateway) {
            this.checkJADE();
            e = new Event(-1, command);
            try {
                if (myLogger.isLoggable(Logger.INFO)) {
                    myLogger.log(Logger.INFO, "Requesting execution of command " + command);
                }
                this.myAgent.putO2AObject(e, false);
            }
            catch (StaleProxyException exc) {
                exc.printStackTrace();
                this.restartJADE();
                this.myAgent.putO2AObject(e, false);
            }
        }
        e.waitUntilProcessed(timeout);
    }

    public final void checkJADE() throws StaleProxyException, ControllerException {
        if (this.myContainer == null) {
            this.initProfile();
            this.myContainer = Runtime.instance().createAgentContainer(this.profile);
            if (this.myContainer == null) {
                throw new ControllerException("JADE startup failed.");
            }
        }
        if (this.myAgent == null) {
            try {
                Agent a = (Agent)Class.forName(this.agentType).newInstance();
                if (a instanceof GatewayAgent) {
                    ((GatewayAgent)a).setListener(new GatewayListenerImpl());
                    this.gatewayAgentState = 2;
                }
                a.setArguments(this.agentArguments);
                this.myAgent = this.myContainer.acceptNewAgent("Control" + this.myContainer.getContainerName(), a);
                if (this.gatewayAgentState == 2) {
                    this.gatewayAgentState = 1;
                }
                this.myAgent.start();
            }
            catch (StaleProxyException spe) {
                throw spe;
            }
            catch (Exception e) {
                throw new ControllerException("Error creating GatewayAgent [" + e + "]");
            }
        }
    }

    final void restartJADE() throws StaleProxyException, ControllerException {
        this.shutdown();
        this.checkJADE();
    }

    public final void init(String agentClassName, Object[] agentArgs, Properties jadeProfile) {
        this.agentType = agentClassName;
        if (this.agentType == null) {
            this.agentType = GatewayAgent.class.getName();
        }
        this.jadeProps = jadeProfile;
        if (this.jadeProps != null) {
            this.jadeProps.setProperty("main", "false");
        }
        this.agentArguments = agentArgs;
    }

    public final void init(String agentClassName, Properties jadeProfile) {
        this.init(agentClassName, null, jadeProfile);
    }

    final void initProfile() {
        this.profile = this.jadeProps == null ? new ProfileImpl(false) : new ProfileImpl(this.jadeProps);
    }

    public final void shutdown() {
        try {
            if (this.myAgent != null) {
                this.myAgent.kill();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.myContainer != null) {
                this.myContainer.kill();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myAgent = null;
        this.myContainer = null;
    }

    public final boolean isGatewayActive() {
        if (this.gatewayAgentState != -1) {
            return this.gatewayAgentState == 1;
        }
        return this.myContainer != null && this.myAgent != null;
    }

    public AID createAID(String localName) {
        return new AID(localName + '@' + this.myContainer.getPlatformName(), true);
    }

    public void addListener(GatewayListener l) {
        this.listeners.add(l);
        this.listenersArray = this.listeners.toArray(new GatewayListener[0]);
    }

    public void removeListener(GatewayListener l) {
        if (this.listeners.remove(l)) {
            this.listenersArray = this.listeners.toArray(new GatewayListener[0]);
        }
    }

    private class GatewayListenerImpl
    implements GatewayListener {
        private GatewayListenerImpl() {
        }

        public void handleGatewayConnected() {
            Thread t = new Thread(){

                public void run() {
                    for (GatewayListener listener : DynamicJadeGateway.this.listenersArray) {
                        try {
                            listener.handleGatewayConnected();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            t.start();
        }

        public void handleGatewayDisconnected() {
            DynamicJadeGateway.this.gatewayAgentState = 2;
            Thread t = new Thread(){

                public void run() {
                    for (GatewayListener listener : DynamicJadeGateway.this.listenersArray) {
                        try {
                            listener.handleGatewayDisconnected();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            t.start();
        }
    }
}

