/*
 * Decompiled with CFR 0.152.
 */
package jade.content.schema.facets;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsTerm;
import jade.content.abs.AbsVariable;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.Facet;
import jade.content.schema.ObjectSchema;
import jade.util.leap.Iterator;

public class TypedAggregateFacet
implements Facet {
    private ObjectSchema type;

    public TypedAggregateFacet(ObjectSchema s) {
        this.type = s;
    }

    public ObjectSchema getType() {
        return this.type;
    }

    public void validate(AbsObject value, Ontology onto) throws OntologyException {
        if (value instanceof AbsVariable) {
            return;
        }
        if (!(value instanceof AbsAggregate)) {
            throw new OntologyException(value + " is not an AbsAggregate");
        }
        AbsAggregate agg = (AbsAggregate)value;
        Iterator it = agg.iterator();
        while (it.hasNext()) {
            AbsTerm el = (AbsTerm)it.next();
            ObjectSchema s = onto.getSchema(el.getTypeName());
            if (s.isCompatibleWith(this.type)) continue;
            throw new OntologyException("Schema " + s + " for element " + el + " is not compatible with type " + this.type);
        }
    }
}

