/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.Concept;
import jade.content.Predicate;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.ServiceException;
import jade.domain.FIPAAgentManagement.UnsupportedFunction;
import jade.domain.FIPAException;
import jade.domain.JADEAgentManagement.CreateAgent;
import jade.domain.JADEAgentManagement.DebugOff;
import jade.domain.JADEAgentManagement.DebugOn;
import jade.domain.JADEAgentManagement.InstallMTP;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.domain.JADEAgentManagement.KillAgent;
import jade.domain.JADEAgentManagement.KillContainer;
import jade.domain.JADEAgentManagement.QueryAgentsOnLocation;
import jade.domain.JADEAgentManagement.QueryPlatformLocationsAction;
import jade.domain.JADEAgentManagement.ShutdownPlatform;
import jade.domain.JADEAgentManagement.SniffOff;
import jade.domain.JADEAgentManagement.SniffOn;
import jade.domain.JADEAgentManagement.UninstallMTP;
import jade.domain.JADEAgentManagement.WhereIsAgentAction;
import jade.domain.RequestManagementBehaviour;
import jade.domain.ams;
import jade.domain.mobility.CloneAction;
import jade.domain.mobility.MoveAction;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.mtp.MTPDescriptor;
import jade.security.Credentials;
import jade.security.CredentialsHelper;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.leap.Serializable;

class AMSJadeAgentManagementBehaviour
extends RequestManagementBehaviour {
    private ams theAMS;

    protected AMSJadeAgentManagementBehaviour(ams a, MessageTemplate mt) {
        super(a, mt);
        this.theAMS = a;
    }

    protected ACLMessage performAction(Action slAction, ACLMessage request) throws JADESecurityException, FIPAException {
        Concept action = slAction.getAction();
        Object result = null;
        boolean resultNeeded = false;
        Serializable asynchNotificationKey = null;
        JADEPrincipal requesterPrincipal = null;
        Credentials requesterCredentials = null;
        try {
            CredentialsHelper ch = (CredentialsHelper)((Object)this.myAgent.getHelper("jade.core.security.Security"));
            requesterPrincipal = ch.getPrincipal(request);
            requesterCredentials = ch.getCredentials(request);
        }
        catch (ServiceException se) {
            // empty catch block
        }
        if (action instanceof CreateAgent) {
            this.theAMS.createAgentAction((CreateAgent)action, request.getSender(), requesterPrincipal, requesterCredentials);
            String agentName = JADEManagementOntology.adjustAgentName(((CreateAgent)action).getAgentName(), new String[]{((CreateAgent)action).getContainer().getName()});
            asynchNotificationKey = new AID(agentName, false);
        } else if (action instanceof KillAgent) {
            this.theAMS.killAgentAction((KillAgent)action, request.getSender(), requesterPrincipal, requesterCredentials);
            asynchNotificationKey = ((KillAgent)action).getAgent();
        } else if (action instanceof CloneAction) {
            this.theAMS.cloneAgentAction((CloneAction)action, request.getSender());
            asynchNotificationKey = new AID(((CloneAction)action).getNewName(), false);
        } else if (action instanceof MoveAction) {
            this.theAMS.moveAgentAction((MoveAction)action, request.getSender());
            asynchNotificationKey = ((MoveAction)action).getMobileAgentDescription().getName();
        } else if (action instanceof KillContainer) {
            this.theAMS.killContainerAction((KillContainer)action, request.getSender(), requesterPrincipal, requesterCredentials);
            asynchNotificationKey = ((KillContainer)action).getContainer();
        } else if (action instanceof ShutdownPlatform) {
            this.theAMS.shutdownPlatformAction((ShutdownPlatform)action, request.getSender(), requesterPrincipal, requesterCredentials);
        } else if (action instanceof InstallMTP) {
            MTPDescriptor dsc = this.theAMS.installMTPAction((InstallMTP)action, request.getSender());
            result = dsc.getAddresses()[0];
            resultNeeded = true;
        } else if (action instanceof UninstallMTP) {
            this.theAMS.uninstallMTPAction((UninstallMTP)action, request.getSender());
        } else if (action instanceof SniffOn) {
            this.theAMS.sniffOnAction((SniffOn)action, request.getSender());
        } else if (action instanceof SniffOff) {
            this.theAMS.sniffOffAction((SniffOff)action, request.getSender());
        } else if (action instanceof DebugOn) {
            this.theAMS.debugOnAction((DebugOn)action, request.getSender());
        } else if (action instanceof DebugOff) {
            this.theAMS.debugOffAction((DebugOff)action, request.getSender());
        } else if (action instanceof WhereIsAgentAction) {
            result = this.theAMS.whereIsAgentAction((WhereIsAgentAction)action, request.getSender());
            resultNeeded = true;
        } else if (action instanceof QueryPlatformLocationsAction) {
            result = this.theAMS.queryPlatformLocationsAction((QueryPlatformLocationsAction)action, request.getSender());
            resultNeeded = true;
        } else if (action instanceof QueryAgentsOnLocation) {
            result = this.theAMS.queryAgentsOnLocationAction((QueryAgentsOnLocation)action, request.getSender());
            resultNeeded = true;
        } else {
            throw new UnsupportedFunction();
        }
        ACLMessage notification = request.createReply();
        notification.setPerformative(7);
        Predicate p = null;
        p = resultNeeded ? new Result(slAction, result) : new Done(slAction);
        try {
            this.theAMS.getContentManager().fillContent(notification, p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (asynchNotificationKey != null) {
            this.theAMS.storeNotification(action, asynchNotificationKey, notification);
            return null;
        }
        return notification;
    }
}

