/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.nio;

import jade.core.BEConnectionManager;
import jade.core.BackEnd;
import jade.core.BackEndContainer;
import jade.core.FrontEnd;
import jade.core.IMTPException;
import jade.core.ProfileException;
import jade.core.Runtime;
import jade.core.Timer;
import jade.core.TimerListener;
import jade.imtp.leap.BackEndSkel;
import jade.imtp.leap.Dispatcher;
import jade.imtp.leap.FrontEndStub;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPMediatorManager;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.MicroSkeleton;
import jade.imtp.leap.nio.NIOMediator;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.io.IOException;
import java.net.InetAddress;

public class NIOHTTPBEDispatcher
implements NIOMediator,
Dispatcher,
BEConnectionManager {
    private static final int ACTIVE = 0;
    private static final int NOT_ACTIVE = 1;
    private static final int CONNECTED = 0;
    private static final int CONNECTING = 1;
    private static final int DISCONNECTED = 2;
    private static final int TERMINATED = 3;
    private static final long OUTGOING_COMMANDS_CONNECTION_TIMEOUT = 30000L;
    private static final long RESPONSE_TIMEOUT = 30000L;
    private static final long RESPONSE_TIMEOUT_INCREMENT = 100L;
    private static final int MAX_SID = 15;
    private JICPMediatorManager myMediatorManager;
    private String myID;
    private MicroSkeleton mySkel = null;
    private FrontEndStub myStub = null;
    private BackEndContainer myContainer = null;
    private int status = 0;
    private int frontEndStatus = 1;
    private long maxDisconnectionTime;
    private Timer maxDisconnectionTimer = null;
    private long keepAliveTime;
    private Timer keepAliveTimer = null;
    private JICPPacket lastResponse = null;
    private byte lastIncomingCommandSid;
    private boolean waitingForFlush = false;
    private Connection outgoingCommandsConnection = null;
    private Object outgoingCommandsConnectionLock = new Object();
    private int nextOutgoingCommandSid;
    private JICPPacket responseToLastOutgoingCommand = null;
    private Object responseToLastOutgoingCommandLock = new Object();
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    public String getID() {
        return this.myID;
    }

    public void init(JICPMediatorManager mgr, String id, Properties props) throws ICPException {
        this.myMediatorManager = mgr;
        this.myID = id;
        this.maxDisconnectionTime = 600000L;
        try {
            this.maxDisconnectionTime = Long.parseLong(props.getProperty("max-disconnection-time"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.keepAliveTime = 60000L;
        try {
            this.keepAliveTime = Long.parseLong(props.getProperty("keep-alive-time"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.nextOutgoingCommandSid = 0;
        try {
            this.nextOutgoingCommandSid = this.increment(Integer.parseInt(props.getProperty("lastsid")));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.lastIncomingCommandSid = (byte)16;
        try {
            this.lastIncomingCommandSid = (byte)this.decrement(Integer.parseInt(props.getProperty("outcnt")));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.myLogger.log(Logger.INFO, "Created NIOHTTPBEDispatcher V1.0. ID = " + this.myID + "\n- Max-disconnection-time = " + this.maxDisconnectionTime + "\n- Keep-alive-time = " + this.keepAliveTime);
        this.myLogger.log(Logger.CONFIG, this.myID + " - Next outgoing command SID = " + this.nextOutgoingCommandSid + ", Last incoming command SID = " + this.lastIncomingCommandSid);
        this.myStub = new FrontEndStub(this);
        this.mySkel = this.startBackEndContainer(props);
    }

    private final BackEndSkel startBackEndContainer(Properties props) throws ICPException {
        try {
            String nodeName = this.myID.replace(':', '_');
            props.setProperty("container-name", nodeName);
            this.myContainer = new BackEndContainer(props, this);
            if (!this.myContainer.connect()) {
                throw new ICPException("BackEnd container failed to join the platform");
            }
            this.myID = this.myContainer.here().getName();
            this.myLogger.log(Logger.CONFIG, this.myID + " - BackEndContainer " + this.myID + " successfully joined the platform.");
            return new BackEndSkel(this.myContainer);
        }
        catch (ProfileException pe) {
            pe.printStackTrace();
            throw new ICPException("Error creating profile");
        }
    }

    public void kill() {
        this.status = 1;
        this.myContainer.shutDown();
    }

    public void tick(long time) {
    }

    public synchronized boolean handleIncomingConnection(Connection c, JICPPacket pkt, InetAddress addr, int port) {
        this.myLogger.log(Logger.INFO, this.myID + " - Front-end connecting [" + addr + ":" + port + "]");
        this.setFrontEndConnecting();
        return false;
    }

    public JICPPacket handleJICPPacket(Connection c, JICPPacket pkt, InetAddress addr, int port) throws ICPException {
        JICPPacket response = null;
        if (this.status == 0 && this.frontEndStatus != 3) {
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, this.myID + " - Incoming packet. Type = " + pkt.getType() + ", SID = " + pkt.getSessionID() + ", terminated-info = " + ((pkt.getInfo() & 0x40) != 0));
            }
            String from = " [" + addr + ":" + port + "]";
            if (pkt.getType() == 0) {
                if ((pkt.getInfo() & 0x40) != 0) {
                    this.myLogger.log(Logger.INFO, this.myID + " - Peer termination notification received");
                    this.handlePeerSelfTermination();
                    return this.createTerminationNotificationAck();
                }
                byte sid = pkt.getSessionID();
                if (sid == this.lastIncomingCommandSid) {
                    this.myLogger.log(Logger.WARNING, this.myID + " - Duplicated command received. SID = " + sid);
                    response = this.lastResponse;
                } else {
                    if (this.myLogger.isLoggable(Logger.FINE)) {
                        this.myLogger.log(Logger.FINE, this.myID + " - Incoming command received. SID = " + sid);
                    }
                    byte[] rspData = this.mySkel.handleCommand(pkt.getData());
                    if (this.myLogger.isLoggable(Logger.FINE)) {
                        this.myLogger.log(Logger.FINE, this.myID + " - Incoming command served. SID = " + sid);
                    }
                    response = new JICPPacket(1, 0, rspData);
                    response.setSessionID(sid);
                    this.lastIncomingCommandSid = sid;
                    this.lastResponse = response;
                }
            } else {
                this.handleResponse(c, pkt, from);
                if ((pkt.getInfo() & 0x40) != 0) {
                    this.setFrontEndTerminated();
                    this.shutdown();
                    return this.createTerminationNotificationAck();
                }
            }
        } else {
            this.myLogger.log(Logger.FINE, "Unexpected packet received after termination. Type = " + pkt.getType() + ", SID = " + pkt.getSessionID() + ", terminated-info = " + ((pkt.getInfo() & 0x40) != 0));
        }
        return response;
    }

    public JICPPacket handleJICPPacket(JICPPacket pkt, InetAddress addr, int port) throws ICPException {
        throw new ICPException("Unexpected call");
    }

    public void handleConnectionError(Connection c, Exception e) {
        if (this.status == 0 && this.frontEndStatus != 3) {
            this.myLogger.log(Logger.WARNING, this.myID + " - Exception reading from the connection", e);
        }
    }

    public Properties getProperties() {
        return new Properties();
    }

    private void handlePeerSelfTermination() {
        this.setFrontEndTerminated();
        this.kill();
    }

    public FrontEnd getFrontEnd(BackEnd be, Properties props) throws IMTPException {
        return this.myStub;
    }

    public void shutdown() {
        this.myLogger.log(Logger.INFO, this.myID + " - Initiate NIOHTTPBEDispatcher shutdown");
        this.status = 1;
        if (this.myID != null) {
            this.myMediatorManager.deregisterMediator(this.myID);
            this.myID = null;
        }
        this.clean();
    }

    public synchronized byte[] dispatch(byte[] payload, boolean flush) throws ICPException {
        if (this.status == 0) {
            if (this.frontEndStatus == 0) {
                if (this.waitingForFlush && !flush) {
                    throw new ICPException("Upsetting dispatching order");
                }
                this.waitingForFlush = false;
                Connection c = this.getOutgoingCommandsConnection();
                JICPPacket cmd = new JICPPacket(0, 0, payload);
                int sid = this.nextOutgoingCommandSid;
                this.nextOutgoingCommandSid = this.increment(this.nextOutgoingCommandSid);
                if (this.myLogger.isLoggable(Logger.FINE)) {
                    this.myLogger.log(Logger.FINE, this.myID + " - Delivering outgoing command to front-end. SID = " + sid);
                }
                cmd.setSessionID((byte)sid);
                boolean deliverOK = false;
                try {
                    c.writePacket(cmd);
                    this.close(c);
                    JICPPacket response = this.getResponse(30000L + 100L * (long)(cmd.getLength() / 1024));
                    deliverOK = true;
                    if (this.myLogger.isLoggable(Logger.FINE)) {
                        this.myLogger.log(Logger.FINE, this.myID + " - Response got. SID = " + sid);
                    }
                    if (response.getType() == 100) {
                        throw new ICPException(new String(response.getData()));
                    }
                    byte[] byArray = response.getData();
                    return byArray;
                }
                catch (IOException ioe) {
                    this.setFrontEndDisconnected();
                    throw new ICPException("Error delivering outgoing command to front-end. ", ioe);
                }
                catch (ICPException icpe) {
                    throw icpe;
                }
                finally {
                    if (!deliverOK) {
                        this.nextOutgoingCommandSid = this.decrement(this.nextOutgoingCommandSid);
                    }
                }
            }
            throw new ICPException("Front-end not connected");
        }
        throw new ICPException("Not-active");
    }

    private synchronized void dispatchKeepAlive() {
        block8: {
            if (this.status == 0 && this.frontEndStatus == 0) {
                try {
                    Connection c = this.getOutgoingCommandsConnection();
                    if (this.myLogger.isLoggable(Logger.FINER)) {
                        this.myLogger.log(Logger.FINER, this.myID + " - Delivering keep-alive to front-end");
                    }
                    JICPPacket cmd = new JICPPacket(2, 0, null);
                    c.writePacket(cmd);
                    this.close(c);
                    JICPPacket response = this.getResponse(30000L + 100L * (long)(cmd.getLength() / 1024));
                    if (this.isKeepAliveResponse(response)) {
                        if (this.myLogger.isLoggable(Logger.FINER)) {
                            this.myLogger.log(Logger.FINER, this.myID + " - Keep-alive response got");
                        }
                    } else {
                        this.myLogger.log(Logger.WARNING, "Unexpected response received while waiting for Keep-alive response");
                    }
                }
                catch (IOException ioe) {
                    this.myLogger.log(Logger.WARNING, this.myID + " - Error delivering keep-alive packet to the front-end", ioe);
                    this.setFrontEndDisconnected();
                }
                catch (ICPException icpe) {
                    if (this.frontEndStatus == 3) break block8;
                    this.myLogger.log(Logger.WARNING, this.myID + " - Keep-alive error. " + icpe.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getOutgoingCommandsConnection() throws ICPException {
        try {
            Object object = this.outgoingCommandsConnectionLock;
            synchronized (object) {
                while (this.outgoingCommandsConnection == null) {
                    this.outgoingCommandsConnectionLock.wait(30000L);
                    if (this.outgoingCommandsConnection != null) continue;
                    if (this.frontEndStatus == 3) {
                        throw new ICPException("Terminated");
                    }
                    this.setFrontEndDisconnected();
                    throw new ICPException("Response timeout");
                }
                Connection c = this.outgoingCommandsConnection;
                this.outgoingCommandsConnection = null;
                return c;
            }
        }
        catch (InterruptedException ie) {
            throw new ICPException("Interrupted while waiting for outgoing-commands-connection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JICPPacket getResponse(long timeout) throws ICPException {
        try {
            Object object = this.responseToLastOutgoingCommandLock;
            synchronized (object) {
                while (this.responseToLastOutgoingCommand == null) {
                    this.responseToLastOutgoingCommandLock.wait(timeout);
                    if (this.responseToLastOutgoingCommand != null) continue;
                    if (this.frontEndStatus == 3) {
                        throw new ICPException("Terminated");
                    }
                    this.setFrontEndDisconnected();
                    throw new ICPException("Response timeout");
                }
                JICPPacket response = this.responseToLastOutgoingCommand;
                this.responseToLastOutgoingCommand = null;
                return response;
            }
        }
        catch (InterruptedException ie) {
            throw new ICPException("Interrupted while waiting for response to outgoing command");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponse(Connection c, JICPPacket response, String from) {
        Object object;
        if (this.frontEndStatus != 0) {
            if (this.frontEndStatus == 1) {
                this.myLogger.log(Logger.INFO, this.myID + " - Initial dummy response received.");
            } else {
                this.myLogger.log(Logger.WARNING, this.myID + " - Unexpected (likely out of time) response received.", new Exception("DUMMY!!!!"));
            }
            this.setFrontEndConnected();
        } else {
            if (this.isKeepAliveResponse(response)) {
                if (this.myLogger.isLoggable(Logger.FINER)) {
                    this.myLogger.log(Logger.FINER, this.myID + " - Keep-alive response received");
                }
            } else if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, this.myID + " - Response received. SID = " + response.getSessionID());
            }
            object = this.responseToLastOutgoingCommandLock;
            synchronized (object) {
                this.responseToLastOutgoingCommand = response;
                this.responseToLastOutgoingCommandLock.notifyAll();
            }
        }
        object = this.outgoingCommandsConnectionLock;
        synchronized (object) {
            this.outgoingCommandsConnection = c;
            this.outgoingCommandsConnectionLock.notifyAll();
        }
        this.updateKeepAliveTimer();
    }

    private void close(Connection c) {
        try {
            c.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int increment(int val) {
        return val + 1 & 0xF;
    }

    private int decrement(int val) {
        if (--val < 0) {
            val = 15;
        }
        return val;
    }

    private boolean isKeepAliveResponse(JICPPacket response) {
        return (response.getInfo() & 0x20) != 0;
    }

    private void setFrontEndConnecting() {
        this.frontEndStatus = 1;
        this.resetMaxDisconnectionTimer();
        this.outgoingCommandsConnection = null;
        this.responseToLastOutgoingCommand = null;
    }

    private void setFrontEndConnected() {
        this.frontEndStatus = 0;
        this.resetMaxDisconnectionTimer();
        this.waitingForFlush = this.myStub.flush();
    }

    private void setFrontEndDisconnected() {
        this.frontEndStatus = 2;
        this.activateMaxDisconnectionTimer();
    }

    private void setFrontEndTerminated() {
        this.frontEndStatus = 3;
    }

    private synchronized void updateKeepAliveTimer() {
        if (this.keepAliveTime > 0L) {
            if (this.keepAliveTimer != null) {
                Runtime.instance().getTimerDispatcher().remove(this.keepAliveTimer);
            }
            long now = System.currentTimeMillis();
            this.keepAliveTimer = new Timer(now + this.keepAliveTime, new TimerListener(){

                public void doTimeOut(Timer t) {
                    NIOHTTPBEDispatcher.this.dispatchKeepAlive();
                }
            });
            this.keepAliveTimer = Runtime.instance().getTimerDispatcher().add(this.keepAliveTimer);
            if (this.myLogger.isLoggable(Logger.FINEST)) {
                this.myLogger.log(Logger.FINEST, this.myID + " - Keep-alive timer activated.");
            }
        }
    }

    private void activateMaxDisconnectionTimer() {
        long now = System.currentTimeMillis();
        this.maxDisconnectionTimer = new Timer(now + this.maxDisconnectionTime, new TimerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doTimeOut(Timer t) {
                NIOHTTPBEDispatcher nIOHTTPBEDispatcher = NIOHTTPBEDispatcher.this;
                synchronized (nIOHTTPBEDispatcher) {
                    if (NIOHTTPBEDispatcher.this.frontEndStatus != 0) {
                        NIOHTTPBEDispatcher.this.myLogger.log(Logger.WARNING, NIOHTTPBEDispatcher.this.myID + " - Max disconnection timeout expired.");
                        NIOHTTPBEDispatcher.this.handlePeerSelfTermination();
                    }
                }
            }
        });
        this.maxDisconnectionTimer = Runtime.instance().getTimerDispatcher().add(this.maxDisconnectionTimer);
        this.myLogger.log(Logger.INFO, this.myID + " - Max-disconnection-timer activated.");
    }

    private void resetMaxDisconnectionTimer() {
        if (this.maxDisconnectionTimer != null) {
            Runtime.instance().getTimerDispatcher().remove(this.maxDisconnectionTimer);
            this.maxDisconnectionTimer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean() {
        this.resetMaxDisconnectionTimer();
        Object object = this.responseToLastOutgoingCommandLock;
        synchronized (object) {
            this.responseToLastOutgoingCommand = null;
            this.responseToLastOutgoingCommandLock.notifyAll();
        }
        object = this.outgoingCommandsConnectionLock;
        synchronized (object) {
            this.outgoingCommandsConnection = null;
            this.outgoingCommandsConnectionLock.notifyAll();
        }
    }

    private JICPPacket createTerminationNotificationAck() {
        return new JICPPacket(0, 64, null);
    }
}

