/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp.http;

import jade.domain.FIPAAgentManagement.Envelope;
import jade.mtp.InChannel;
import jade.mtp.http.HTTPIO;
import jade.mtp.http.HTTPSocketFactory;
import jade.mtp.http.XMLCodec;
import jade.util.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;

public class HTTPServer
extends Thread {
    static String CODEC = "org.apache.crimson.parser.XMLReaderImpl";
    private int port;
    private InChannel.Dispatcher dispatcher;
    private int maxKA;
    private int timeout;
    private ServerSocket server;
    private static Logger logger = Logger.getMyLogger(HTTPServer.class.getName());
    private Vector threads;
    private static Object lock = new Object();
    boolean active = true;

    public HTTPServer(int p, InChannel.Dispatcher d, int m, String s, int t, boolean changePortIfBusy) throws IOException {
        this.port = p;
        this.dispatcher = d;
        this.maxKA = m;
        this.threads = new Vector(this.maxKA);
        CODEC = this.getSaxParserName(s);
        if (CODEC == null) {
            throw new IOException("NO XML Parser specified");
        }
        logger.log(Logger.INFO, "HTTP-MTP Using XML parser " + CODEC);
        this.timeout = t;
        try {
            this.server = HTTPSocketFactory.getInstance().createServerSocket(this.port);
        }
        catch (IOException ioe) {
            if (changePortIfBusy) {
                this.server = HTTPSocketFactory.getInstance().createServerSocket(0);
                if (logger.isLoggable(Logger.WARNING)) {
                    logger.log(Logger.WARNING, "Port " + p + " is already in used, selected another one");
                }
            }
            throw ioe;
        }
    }

    public synchronized void desactivate() {
        for (int i = 0; i < this.threads.size(); ++i) {
            ((ServerThread)this.threads.elementAt(i)).shutdown();
        }
        this.active = false;
        try {
            this.server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getSaxParserName(String s) {
        if (s != null) {
            return s;
        }
        String saxFactory = System.getProperty("org.xml.sax.driver");
        if (saxFactory != null) {
            return saxFactory;
        }
        try {
            return SAXParserFactory.newInstance().newSAXParser().getXMLReader().getClass().getName();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    int getLocalPort() {
        return this.server.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addThread(ServerThread st) {
        Object object = lock;
        synchronized (object) {
            this.threads.addElement(st);
            if (logger.isLoggable(Logger.CONFIG)) {
                logger.log(Logger.CONFIG, " Added Ka threads: " + this.threads.size() + "/" + this.maxKA);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeThread(ServerThread st) {
        Object object = lock;
        synchronized (object) {
            this.threads.removeElement(st);
            if (logger.isLoggable(Logger.CONFIG)) {
                logger.log(Logger.CONFIG, " Removed Ka threads: " + this.threads.size() + "/" + this.maxKA);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSpaceLeft() {
        Object object = lock;
        synchronized (object) {
            return this.threads.size() < this.maxKA;
        }
    }

    public void run() {
        block3: {
            try {
                while (this.active) {
                    Socket client = this.server.accept();
                    client.setSoTimeout(this.timeout);
                    new ServerThread(this, client, this.dispatcher).start();
                }
            }
            catch (Exception e) {
                if (!this.active || !logger.isLoggable(Logger.WARNING)) break block3;
                logger.log(Logger.WARNING, "HTTP Server closed on port " + this.port);
            }
        }
    }

    public static class ServerThread
    extends Thread {
        private HTTPServer father;
        private Socket client;
        private InputStream input;
        private OutputStream output;
        private InChannel.Dispatcher dispatcher;
        private XMLCodec codec;
        private boolean keepAlive = false;
        private boolean active = false;

        public ServerThread(HTTPServer f, Socket s, InChannel.Dispatcher d) {
            this.father = f;
            this.client = s;
            this.dispatcher = d;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.codec = new XMLCodec(CODEC);
                this.input = new BufferedInputStream(this.client.getInputStream());
                this.output = new BufferedOutputStream(this.client.getOutputStream());
                do {
                    StringBuffer envelope = new StringBuffer(40);
                    ByteArrayOutputStream payload = new ByteArrayOutputStream(40);
                    StringBuffer connection = new StringBuffer();
                    String responseMsg = HTTPIO.readAll(this.input, envelope, payload, connection);
                    String type = connection.toString();
                    if ("200 OK".equals(responseMsg)) {
                        StringReader sr = new StringReader(envelope.toString());
                        Envelope env = this.codec.parse(sr);
                        InChannel.Dispatcher dispatcher = this.dispatcher;
                        synchronized (dispatcher) {
                            if (logger.isLoggable(Logger.WARNING) && env.getPayloadLength() != null && env.getPayloadLength().intValue() >= 0 && env.getPayloadLength().intValue() != payload.size()) {
                                logger.log(Logger.WARNING, "Payload size does not match envelope information");
                            }
                            this.dispatcher.dispatchMessage(env, payload.toByteArray());
                        }
                        if ("Keep-Alive".equalsIgnoreCase(type)) {
                            if (!this.keepAlive) {
                                if (this.father.isSpaceLeft()) {
                                    this.active = true;
                                    this.keepAlive = true;
                                    this.father.addThread(this);
                                } else {
                                    type = "close";
                                }
                            }
                        } else {
                            this.active = false;
                        }
                    }
                    HTTPIO.writeAll(this.output, HTTPIO.createHTTPResponse(responseMsg, type));
                } while (this.active);
            }
            catch (SocketException se) {
            }
            catch (IOException ioe) {
            }
            catch (Exception e) {
                if (logger.isLoggable(Logger.WARNING)) {
                    logger.log(Logger.WARNING, "HTTPServer error : " + e);
                }
            }
            finally {
                if (this.keepAlive) {
                    this.father.removeThread(this);
                }
            }
            this.shutdown();
        }

        void shutdown() {
            this.active = false;
            this.keepAlive = false;
            try {
                this.client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

