/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.instance.node;

import java.util.HashMap;
import java.util.Map;
import org.drools.definition.process.Connection;
import org.drools.process.instance.context.variable.VariableScopeInstance;
import org.drools.runtime.process.NodeInstance;
import org.drools.workflow.core.node.Join;
import org.drools.workflow.instance.impl.NodeInstanceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinInstance
extends NodeInstanceImpl {
    private static final long serialVersionUID = 510L;
    private Map<Long, Integer> triggers = new HashMap<Long, Integer>();

    protected Join getJoin() {
        return (Join)this.getNode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void internalTrigger(NodeInstance from, String type) {
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("An ActionNode only accepts default incoming connections!");
        }
        Join join = this.getJoin();
        switch (join.getType()) {
            case 2: {
                this.triggerCompleted();
                return;
            }
            case 1: {
                Integer count = this.triggers.get(from.getNodeId());
                if (count == null) {
                    this.triggers.put(from.getNodeId(), 1);
                } else {
                    this.triggers.put(from.getNodeId(), count + 1);
                }
                if (!this.checkAllActivated()) return;
                this.decreaseAllTriggers();
                this.triggerCompleted();
                return;
            }
            case 3: {
                boolean triggerCompleted = this.triggers.isEmpty();
                this.triggers.put(from.getNodeId(), new Integer(1));
                if (this.checkAllActivated()) {
                    this.resetAllTriggers();
                }
                if (!triggerCompleted) return;
                this.triggerCompleted();
                return;
            }
            case 4: {
                Integer count = this.triggers.get(from.getNodeId());
                if (count == null) {
                    this.triggers.put(from.getNodeId(), 1);
                } else {
                    this.triggers.put(from.getNodeId(), count + 1);
                }
                int counter = 0;
                for (Connection connection : this.getJoin().getDefaultIncomingConnections()) {
                    if (this.triggers.get(connection.getFrom().getId()) == null) continue;
                    ++counter;
                }
                String n = join.getN();
                Integer number = null;
                if (n.startsWith("#{") && n.endsWith("}")) {
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", n = n.substring(2, n.length() - 1));
                    if (variableScopeInstance == null) {
                        throw new IllegalArgumentException("Could not find variable " + n + " when executing join.");
                    }
                    Object value = variableScopeInstance.getVariable(n);
                    if (!(value instanceof Number)) throw new IllegalArgumentException("Variable " + n + " did not return a number when executing join: " + value);
                    number = ((Number)value).intValue();
                } else {
                    number = new Integer(n);
                }
                if (counter < number) return;
                this.resetAllTriggers();
                this.triggerCompleted();
                return;
            }
            default: {
                throw new IllegalArgumentException("Illegal join type " + join.getType());
            }
        }
    }

    private boolean checkAllActivated() {
        for (Connection connection : this.getJoin().getDefaultIncomingConnections()) {
            if (this.triggers.get(connection.getFrom().getId()) != null) continue;
            return false;
        }
        return true;
    }

    private void decreaseAllTriggers() {
        for (Connection connection : this.getJoin().getDefaultIncomingConnections()) {
            Integer count = this.triggers.get(connection.getFrom().getId());
            if (count == 1) {
                this.triggers.remove(connection.getFrom().getId());
                continue;
            }
            this.triggers.put(connection.getFrom().getId(), count - 1);
        }
    }

    private void resetAllTriggers() {
        this.triggers.clear();
    }

    public void triggerCompleted() {
        this.triggerCompleted("DROOLS_DEFAULT", this.triggers.isEmpty());
    }

    public Map<Long, Integer> getTriggers() {
        return this.triggers;
    }

    public void internalSetTriggers(Map<Long, Integer> triggers) {
        this.triggers = triggers;
    }
}

