/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.AgentManager;
import jade.core.AgentState;
import jade.core.AgentToolkit;
import jade.core.BaseNode;
import jade.core.BehaviourID;
import jade.core.CaseInsensitiveString;
import jade.core.Command;
import jade.core.CommandProcessor;
import jade.core.ContainerID;
import jade.core.GenericCommand;
import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.LADT;
import jade.core.Location;
import jade.core.MainContainer;
import jade.core.MainContainerImpl;
import jade.core.MainDetectionManager;
import jade.core.MessageQueue;
import jade.core.MulticastMainDetectionListener;
import jade.core.NameClashException;
import jade.core.NodeDescriptor;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.ProfileImpl;
import jade.core.ResourceManager;
import jade.core.Runtime;
import jade.core.Scheduler;
import jade.core.Service;
import jade.core.ServiceDescriptor;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.ServiceHelper;
import jade.core.ServiceManager;
import jade.core.ServiceNotActiveException;
import jade.core.SliceProxy;
import jade.core.Specifier;
import jade.core.behaviours.Behaviour;
import jade.core.management.AgentManagementSlice;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessagingSlice;
import jade.core.mobility.AgentMobilitySlice;
import jade.domain.AMSEventQueueFeeder;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.lang.acl.ACLMessage;
import jade.mtp.MTPDescriptor;
import jade.mtp.TransportAddress;
import jade.security.Credentials;
import jade.security.CredentialsHelper;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Properties;
import jade.wrapper.ContainerProxy;

class AgentContainerImpl
implements AgentContainer,
AgentToolkit {
    public static final String ENABLE_MONITOR = "jade_core_AgentContainerImpl_enablemonitor";
    public static final String MONITOR_AGENT_NAME = "monitor-%C";
    public static final String MONITOR_AGENT_CLASS = "jade.core.ContainerMonitorAgent";
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    protected LADT localAgents;
    protected Profile myProfile;
    protected CommandProcessor myCommandProcessor;
    protected MainContainerImpl myMainContainer;
    private MulticastMainDetectionListener mainDetectionListener;
    protected IMTPManager myIMTPManager;
    private ServiceManager myServiceManager;
    private ServiceFinder myServiceFinder;
    private ResourceManager myResourceManager;
    protected ContainerID myID;
    protected NodeDescriptor myNodeDescriptor;
    protected JADEPrincipal ownerPrincipal;
    protected Credentials ownerCredentials;
    private AID theAMS;
    private AID theDefaultDF;
    private long creationTime = -1L;

    AgentContainerImpl() {
    }

    AgentContainerImpl(Profile p) {
        this.myProfile = p;
        this.localAgents = new LADT(16);
    }

    jade.wrapper.AgentContainer getContainerController() {
        return this.getContainerController(this.myNodeDescriptor.getOwnerPrincipal(), this.myNodeDescriptor.getOwnerCredentials());
    }

    public jade.wrapper.AgentContainer getContainerController(JADEPrincipal principal, Credentials credentials) {
        return new jade.wrapper.AgentContainer(this.getContainerProxy(principal, credentials), this, this.getPlatformID());
    }

    private ContainerProxy getContainerProxy(final JADEPrincipal principal, final Credentials credentials) {
        return new ContainerProxy(){
            GenericCommand dummyCmd = new GenericCommand(null, null, null);
            {
                this.dummyCmd.setPrincipal(principal);
                this.dummyCmd.setCredentials(credentials);
            }

            public void createAgent(AID id, String className, Object[] args) throws Throwable {
                AgentManagementSlice target = (AgentManagementSlice)((Object)this.getProxyToLocalSlice("jade.core.management.AgentManagement"));
                target.createAgent(id, className, args, principal, null, false, this.dummyCmd);
            }

            public void killContainer() throws Throwable {
                AgentManagementSlice target = (AgentManagementSlice)((Object)this.getProxyToLocalSlice("jade.core.management.AgentManagement"));
                target.exitContainer();
            }

            public MTPDescriptor installMTP(String address, String className) throws Throwable {
                MessagingSlice target = (MessagingSlice)((Object)this.getProxyToLocalSlice("jade.core.messaging.Messaging"));
                return target.installMTP(address, className);
            }

            public void uninstallMTP(String address) throws Throwable {
                MessagingSlice target = (MessagingSlice)((Object)this.getProxyToLocalSlice("jade.core.messaging.Messaging"));
                target.uninstallMTP(address);
            }

            public void suspendAgent(AID id) throws Throwable {
                AgentManagementSlice target = (AgentManagementSlice)((Object)this.getProxyToLocalSlice("jade.core.management.AgentManagement"));
                target.changeAgentState(id, 4);
            }

            public void activateAgent(AID id) throws Throwable {
                AgentManagementSlice target = (AgentManagementSlice)((Object)this.getProxyToLocalSlice("jade.core.management.AgentManagement"));
                target.changeAgentState(id, 2);
            }

            public void killAgent(AID id) throws Throwable {
                AgentManagementSlice target = (AgentManagementSlice)((Object)this.getProxyToLocalSlice("jade.core.management.AgentManagement"));
                target.killAgent(id, this.dummyCmd);
            }

            public void moveAgent(AID id, Location where) throws Throwable {
                AgentMobilitySlice target = (AgentMobilitySlice)((Object)this.getProxyToLocalSlice("jade.core.mobility.AgentMobility"));
                target.moveAgent(id, where);
            }

            public void cloneAgent(AID id, Location where, String newName) throws Throwable {
                AgentMobilitySlice target = (AgentMobilitySlice)((Object)this.getProxyToLocalSlice("jade.core.mobility.AgentMobility"));
                target.copyAgent(id, where, newName);
            }

            private SliceProxy getProxyToLocalSlice(String serviceName) throws Throwable {
                Service svc = AgentContainerImpl.this.myServiceFinder.findService(serviceName);
                return (SliceProxy)AgentContainerImpl.this.myIMTPManager.createSliceProxy(serviceName, svc.getHorizontalInterface(), AgentContainerImpl.this.myIMTPManager.getLocalNode());
            }
        };
    }

    public void initAgent(AID agentID, Agent instance, JADEPrincipal ownerPrincipal, Credentials initialCredentials) throws NameClashException, IMTPException, NotFoundException, JADESecurityException {
        agentID.setName(JADEManagementOntology.adjustAgentName(agentID.getName(), new String[]{this.myID.getName()}));
        instance.setAID(agentID);
        instance.setToolkit(this);
        GenericCommand cmd = new GenericCommand("Inform-Created", "jade.core.management.AgentManagement", null);
        cmd.addParam(agentID);
        cmd.addParam(instance);
        cmd.addParam(ownerPrincipal);
        cmd.addParam(initialCredentials);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null) {
            if (ret instanceof NameClashException) {
                throw (NameClashException)ret;
            }
            if (ret instanceof IMTPException) {
                throw (IMTPException)ret;
            }
            if (ret instanceof NotFoundException) {
                throw (NotFoundException)ret;
            }
            if (ret instanceof JADESecurityException) {
                throw (JADESecurityException)ret;
            }
            if (ret instanceof Throwable) {
                ((Throwable)ret).printStackTrace();
                throw new IMTPException("Unexpected error initializing agent " + agentID.getName(), (Throwable)ret);
            }
        }
    }

    public NodeDescriptor getNodeDescriptor() {
        return this.myNodeDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws IMTPException, ProfileException {
        this.myCommandProcessor = this.myProfile.getCommandProcessor();
        if (this.myProfile.getBooleanProperty("detect-main", false) && !this.myProfile.getBooleanProperty("host", false)) {
            MainDetectionManager.detect((ProfileImpl)this.myProfile);
        }
        try {
            this.myIMTPManager = this.myProfile.getIMTPManager();
            this.myIMTPManager.initialize(this.myProfile);
            this.mainDetectionListener = null;
            if (this.myProfile.getBooleanProperty("detect-main", true) && ((ProfileImpl)this.myProfile).isMain()) {
                try {
                    this.mainDetectionListener = MainDetectionManager.createListener((ProfileImpl)this.myProfile, this.myIMTPManager);
                }
                catch (ProfileException pe) {
                    if ("true".equalsIgnoreCase(this.myProfile.getBootProperties().getProperty("detect-main"))) {
                        throw pe;
                    }
                    this.myLogger.log(Logger.WARNING, "Automatic main-detection mechanism initialization failed (" + pe.getMessage() + "). Mechanism disabled!");
                }
            }
        }
        finally {
            if (this.myProfile.getBooleanProperty("dump-options", false)) {
                this.myLogger.log(Logger.INFO, "Startup options dump:\n" + this.myProfile);
            }
        }
        this.myServiceManager = this.myProfile.getServiceManager();
        this.myServiceFinder = this.myProfile.getServiceFinder();
        BaseNode localNode = (BaseNode)this.myIMTPManager.getLocalNode();
        localNode.setCommandProcessor(this.myCommandProcessor);
        localNode.setServiceManager(this.myServiceManager);
        this.myMainContainer = this.myProfile.getMain();
        AID.setPlatformID(this.myServiceManager.getPlatformName());
        this.theAMS = new AID("ams", false);
        this.theDefaultDF = new AID("df", false);
        this.myResourceManager = this.myProfile.getResourceManager();
        if (!this.myProfile.getBooleanProperty("no-display", false)) {
            this.myResourceManager.initGraphicResources();
        }
        TransportAddress addr = (TransportAddress)this.myIMTPManager.getLocalAddresses().get(0);
        this.myID = new ContainerID(this.myProfile.getParameter("container-name", "No-Name"), addr);
        this.myNodeDescriptor = new NodeDescriptor(this.myID, this.myIMTPManager.getLocalNode());
    }

    protected void startNode() throws IMTPException, ProfileException, ServiceException, JADESecurityException, NotFoundException {
        boolean isMaster;
        ArrayList services = new ArrayList();
        this.initMandatoryServices(services);
        List l = this.myProfile.getSpecifiers("services");
        this.myProfile.setSpecifiers("services", l);
        this.initAdditionalServices(l.iterator(), services);
        ServiceDescriptor[] descriptors = new ServiceDescriptor[services.size()];
        for (int i = 0; i < descriptors.length; ++i) {
            descriptors[i] = (ServiceDescriptor)services.get(i);
        }
        this.myServiceManager.addNode(this.myNodeDescriptor, descriptors);
        this.creationTime = System.currentTimeMillis();
        boolean bl = isMaster = !this.myProfile.getBooleanProperty("backupmain", false);
        if (this.myMainContainer != null && isMaster) {
            this.myMainContainer.initSystemAgents(this, false);
        }
        this.bootAllServices(services);
        if (this.myMainContainer != null && isMaster) {
            this.myMainContainer.startSystemAgents(this, null);
        }
    }

    void initMandatoryServices(List services) throws ServiceException {
        ServiceDescriptor dsc = this.startService("jade.core.management.AgentManagementService", false);
        dsc.setMandatory(true);
        services.add(dsc);
        dsc = this.startService("jade.core.messaging.MessagingService", false);
        dsc.setMandatory(true);
        services.add(dsc);
    }

    void initAdditionalServices(Iterator serviceSpecifiers, List services) throws ServiceException {
        while (serviceSpecifiers.hasNext()) {
            Specifier s = (Specifier)serviceSpecifiers.next();
            String serviceClass = s.getClassName();
            boolean isMandatory = false;
            if (s.getArgs() != null) {
                isMandatory = CaseInsensitiveString.equalsIgnoreCase((String)s.getArgs()[0], "true");
            }
            try {
                ServiceDescriptor dsc = this.startService(serviceClass, false);
                dsc.setMandatory(isMandatory);
                services.add(dsc);
            }
            catch (ServiceException se) {
                if (isMandatory) {
                    throw se;
                }
                this.myLogger.log(Logger.WARNING, "Exception initializing service " + serviceClass, se);
            }
        }
    }

    void bootAllServices(List services) throws ServiceException {
        Iterator it = services.iterator();
        while (it.hasNext()) {
            ServiceDescriptor dsc = (ServiceDescriptor)it.next();
            try {
                dsc.getService().boot(this.myProfile);
            }
            catch (Throwable t) {
                if (dsc.isMandatory()) {
                    throw new ServiceException("An error occurred during service booting", t);
                }
                this.myLogger.log(Logger.WARNING, "Exception booting service " + dsc.getName(), t);
            }
        }
    }

    boolean joinPlatform() {
        this.checkLocalHostAddress();
        try {
            this.init();
            this.startNode();
        }
        catch (IMTPException imtpe) {
            this.myLogger.log(Logger.SEVERE, "Communication failure while joining agent platform: " + imtpe.getMessage());
            imtpe.printStackTrace();
            this.endContainer();
            this.cleanIMTPManager();
            return false;
        }
        catch (JADESecurityException ae) {
            this.myLogger.log(Logger.SEVERE, "Authentication or authorization failure while joining agent platform.");
            ae.printStackTrace();
            this.endContainer();
            this.cleanIMTPManager();
            return false;
        }
        catch (Exception e) {
            this.myLogger.log(Logger.SEVERE, "Some problem occurred while joining agent platform.");
            e.printStackTrace();
            this.endContainer();
            this.cleanIMTPManager();
            return false;
        }
        this.startBootstrapAgents();
        this.myLogger.log(Logger.INFO, "--------------------------------------\nAgent container " + this.myID + " is ready.\n--------------------------------------------");
        return true;
    }

    private void checkLocalHostAddress() {
        String address = Profile.getDefaultNetworkName();
        if (address.equals("localhost") || address.equals("127.0.0.1")) {
            this.myLogger.log(Logger.WARNING, "\n***************************************************************\nJAVA is not able to detect the local host address.\nIf this container is part of a distributed platform, use the\n-local-host option to explicitly specify the local host address\n***************************************************************\n");
        }
    }

    private void cleanIMTPManager() {
        if (this.myIMTPManager != null) {
            this.myIMTPManager.shutDown();
        }
    }

    private void startBootstrapAgents() {
        try {
            List l = this.myProfile.getSpecifiers("agents");
            Iterator agentSpecifiers = l.iterator();
            while (agentSpecifiers.hasNext()) {
                Specifier s = (Specifier)agentSpecifiers.next();
                if (s.getName() != null) {
                    AID agentID = new AID(s.getName(), false);
                    try {
                        this.getContainerProxy(this.myNodeDescriptor.getOwnerPrincipal(), this.myNodeDescriptor.getOwnerCredentials()).createAgent(agentID, s.getClassName(), s.getArgs());
                    }
                    catch (Throwable t) {
                        this.myLogger.log(Logger.SEVERE, "Cannot create agent " + s.getName() + ": " + t.getMessage());
                    }
                    continue;
                }
                this.myLogger.log(Logger.WARNING, "Cannot create an agent with no name. Class was " + s.getClassName());
            }
            AID[] allLocalNames = this.localAgents.keys();
            for (int i = 0; i < allLocalNames.length; ++i) {
                AID id = allLocalNames[i];
                if (id.equals(this.theAMS) || id.equals(this.theDefaultDF)) continue;
                try {
                    this.powerUpLocalAgent(id);
                    continue;
                }
                catch (NotFoundException nfe) {
                    nfe.printStackTrace();
                }
            }
            if (this.myProfile.getBooleanProperty(ENABLE_MONITOR, true)) {
                AID monitorId = new AID(MONITOR_AGENT_NAME, false);
                try {
                    this.getContainerProxy(this.myNodeDescriptor.getOwnerPrincipal(), this.myNodeDescriptor.getOwnerCredentials()).createAgent(monitorId, MONITOR_AGENT_CLASS, new Object[]{this, this.localAgents});
                    this.powerUpLocalAgent(monitorId);
                    this.myLogger.log(Logger.INFO, "Container-Monitor agent activated");
                }
                catch (Throwable t) {}
            }
        }
        catch (ProfileException pe) {
            this.myLogger.log(Logger.WARNING, "Error reading initial agents. " + pe);
            pe.printStackTrace();
        }
    }

    public void shutDown() {
        this.checkCreationTime();
        Agent[] allLocalAgents = this.localAgents.values();
        for (int i = 0; i < allLocalAgents.length; ++i) {
            Agent a = allLocalAgents[i];
            AID id = a.getAID();
            if (id.equals(this.getAMS()) || id.equals(this.getDefaultDF())) continue;
            a.doDelete();
            a.join();
            a.resetToolkit();
        }
        try {
            this.myServiceManager.removeNode(this.myNodeDescriptor);
            if (this.mainDetectionListener != null) {
                this.mainDetectionListener.stop();
            }
            this.myIMTPManager.shutDown();
        }
        catch (IMTPException imtpe) {
            imtpe.printStackTrace();
        }
        catch (ServiceException se) {
            se.printStackTrace();
        }
        this.myResourceManager.releaseResources();
        this.endContainer();
    }

    private void checkCreationTime() {
        long time = System.currentTimeMillis();
        if (time - this.creationTime < 3000L) {
            try {
                Thread.sleep(3000L - (time - this.creationTime));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void endContainer() {
        try {
            Runtime.instance().endContainer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Location here() {
        return this.myID;
    }

    public void handleSend(ACLMessage msg, AID sender, boolean needClone) {
        Iterator it = msg.getAllIntendedReceiver();
        boolean isFirst = true;
        while (it.hasNext()) {
            AID receiver = (AID)it.next();
            if (isFirst) {
                needClone = needClone || it.hasNext();
                isFirst = false;
            }
            GenericCommand cmd = new GenericCommand("Send-Message", "jade.core.messaging.Messaging", null);
            cmd.addParam(sender);
            ACLMessage toBeSent = null;
            toBeSent = needClone ? (ACLMessage)msg.clone() : msg;
            GenericMessage gmsg = new GenericMessage(toBeSent);
            cmd.addParam(gmsg);
            cmd.addParam(receiver);
            this.initCredentials(cmd, sender);
            Object ret = this.myCommandProcessor.processOutgoing(cmd);
            if (ret == null || !(ret instanceof Throwable)) continue;
            cmd = new GenericCommand("Notify-Failure", "jade.core.messaging.Messaging", null);
            cmd.addParam(gmsg);
            cmd.addParam(receiver);
            cmd.addParam(new InternalError("Message blocked: " + ret));
            ret = this.myCommandProcessor.processOutgoing(cmd);
            if (ret == null || !(ret instanceof Throwable)) continue;
            ((Throwable)ret).printStackTrace();
        }
    }

    public void handlePosted(AID agentID, ACLMessage msg) {
        GenericCommand cmd = new GenericCommand("Notify-Posted", "jade.core.event.Notification", null);
        cmd.addParam(msg);
        cmd.addParam(agentID);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null && ret instanceof Throwable) {
            ((Throwable)ret).printStackTrace();
        }
    }

    public void handleReceived(AID agentID, ACLMessage msg) {
        GenericCommand cmd = new GenericCommand("Notify-Received", "jade.core.event.Notification", null);
        cmd.addParam(msg);
        cmd.addParam(agentID);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null && ret instanceof Throwable) {
            ((Throwable)ret).printStackTrace();
        }
    }

    public void handleBehaviourAdded(AID agentID, Behaviour b) {
        GenericCommand cmd = new GenericCommand("Notify-BehaviourAdded", "jade.core.event.Notification", null);
        cmd.addParam(agentID);
        cmd.addParam(b);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null && ret instanceof Throwable) {
            ((Throwable)ret).printStackTrace();
        }
    }

    public void handleBehaviourRemoved(AID agentID, Behaviour b) {
        GenericCommand cmd = new GenericCommand("Notify-Behaviour-Removed", "jade.core.event.Notification", null);
        cmd.addParam(agentID);
        cmd.addParam(b);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null && ret instanceof Throwable) {
            ((Throwable)ret).printStackTrace();
        }
    }

    public void handleChangeBehaviourState(AID agentID, Behaviour b, String from, String to) {
        GenericCommand cmd = new GenericCommand("Notify-Changed-Behaviour-State", "jade.core.event.Notification", null);
        cmd.addParam(agentID);
        cmd.addParam(b);
        cmd.addParam(from);
        cmd.addParam(to);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null && ret instanceof Throwable) {
            ((Throwable)ret).printStackTrace();
        }
    }

    public void handleChangedAgentPrincipal(AID agentID, JADEPrincipal oldPrincipal, Credentials creds) {
    }

    public void handleChangedAgentState(AID agentID, int oldState, int newState) {
        AgentState from = AgentState.getInstance(oldState);
        AgentState to = AgentState.getInstance(newState);
        GenericCommand cmd = new GenericCommand("Inform-State-Changed", "jade.core.management.AgentManagement", null);
        cmd.addParam(agentID);
        cmd.addParam(from);
        cmd.addParam(to);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null && ret instanceof Throwable) {
            ((Throwable)ret).printStackTrace();
        }
    }

    public void handleEnd(AID agentID) {
        GenericCommand cmd = new GenericCommand("Inform-Killed", "jade.core.management.AgentManagement", null);
        cmd.addParam(agentID);
        this.initCredentials(cmd, agentID);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null && ret instanceof Throwable) {
            ((Throwable)ret).printStackTrace();
        }
    }

    public void setPlatformAddresses(AID id) {
        GenericCommand cmd = new GenericCommand("Set-Platform-Addresses", "jade.core.messaging.Messaging", null);
        cmd.addParam(id);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret != null && ret instanceof Throwable) {
            ((Throwable)ret).printStackTrace();
        }
    }

    public AID getAMS() {
        return (AID)this.theAMS.clone();
    }

    public AID getDefaultDF() {
        return (AID)this.theDefaultDF.clone();
    }

    public String getProperty(String key, String aDefault) {
        return this.myProfile.getParameter(key, aDefault);
    }

    public Properties getBootProperties() {
        return this.myProfile.getBootProperties();
    }

    public ServiceHelper getHelper(Agent a, String serviceName) throws ServiceException {
        try {
            Service s = this.myServiceFinder.findService(serviceName);
            if (s == null) {
                throw new ServiceNotActiveException(serviceName);
            }
            return s.getHelper(a);
        }
        catch (IMTPException imtpe) {
            throw new ServiceException(" ServiceHelper could not be created for: " + serviceName, imtpe);
        }
    }

    public String getPlatformID() {
        return AID.getPlatformID();
    }

    public Agent addLocalAgent(AID id, Agent a) {
        a.setToolkit(this);
        a.initMessageQueue();
        return this.localAgents.put(id, a);
    }

    public void powerUpLocalAgent(AID agentID) throws NotFoundException {
        Agent instance = this.localAgents.acquire(agentID);
        if (instance == null) {
            throw new NotFoundException("powerUpLocalAgent() failed to find agent " + agentID.getName());
        }
        int type = agentID.equals(this.theAMS) || agentID.equals(this.theDefaultDF) ? 1 : 0;
        Thread t = this.myResourceManager.getThread(type, agentID.getLocalName(), instance);
        instance.powerUp(agentID, t);
        this.localAgents.release(agentID);
    }

    public void removeLocalAgent(AID id) {
        this.localAgents.remove(id);
    }

    public Agent acquireLocalAgent(AID id) {
        return this.localAgents.acquire(id);
    }

    public void releaseLocalAgent(AID id) {
        this.localAgents.release(id);
    }

    public boolean isLocalAgent(AID id) {
        return this.localAgents.contains(id);
    }

    public AID[] agentNames() {
        return this.localAgents.keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillListFromMessageQueue(List messages, Agent a) {
        MessageQueue mq;
        MessageQueue messageQueue = mq = a.getMessageQueue();
        synchronized (messageQueue) {
            mq.copyTo(messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillListFromReadyBehaviours(List behaviours, Agent a) {
        Scheduler s;
        Scheduler scheduler = s = a.getScheduler();
        synchronized (scheduler) {
            Iterator it = s.readyBehaviours.iterator();
            while (it.hasNext()) {
                Behaviour b = (Behaviour)it.next();
                behaviours.add(new BehaviourID(b));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillListFromBlockedBehaviours(List behaviours, Agent a) {
        Scheduler s;
        Scheduler scheduler = s = a.getScheduler();
        synchronized (scheduler) {
            Iterator it = s.blockedBehaviours.iterator();
            while (it.hasNext()) {
                Behaviour b = (Behaviour)it.next();
                behaviours.add(new BehaviourID(b));
            }
        }
    }

    public void addAddressToLocalAgents(String address) {
        Agent[] allLocalAgents = this.localAgents.values();
        for (int j = 0; j < allLocalAgents.length; ++j) {
            allLocalAgents[j].addPlatformAddress(address);
        }
        this.theAMS.addAddresses(address);
        this.theDefaultDF.addAddresses(address);
    }

    public void removeAddressFromLocalAgents(String address) {
        Agent[] allLocalAgents = this.localAgents.values();
        for (int j = 0; j < allLocalAgents.length; ++j) {
            allLocalAgents[j].removePlatformAddress(address);
        }
        this.theAMS.removeAddresses(address);
        this.theDefaultDF.removeAddresses(address);
    }

    public boolean postMessageToLocalAgent(ACLMessage msg, AID receiverID) {
        Agent receiver = this.localAgents.acquire(receiverID);
        if (receiver == null) {
            return false;
        }
        receiver.postMessage(msg);
        this.localAgents.release(receiverID);
        return true;
    }

    public ContainerID getID() {
        return this.myID;
    }

    public MainContainer getMain() {
        return this.myMainContainer;
    }

    public ServiceManager getServiceManager() {
        return this.myServiceManager;
    }

    public ServiceFinder getServiceFinder() {
        return this.myServiceFinder;
    }

    protected ServiceDescriptor startService(String name, boolean activateIt) throws ServiceException {
        try {
            Class<?> svcClass = Class.forName(name);
            Service svc = (Service)svcClass.newInstance();
            svc.init(this, this.myProfile);
            ServiceDescriptor dsc = new ServiceDescriptor(svc.getName(), svc);
            if (activateIt) {
                this.myServiceManager.activateService(dsc);
                svc.boot(this.myProfile);
            }
            return dsc;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ServiceException("An error occurred during service activation", t);
        }
    }

    protected void stopService(String name) throws ServiceException {
        try {
            this.myServiceManager.deactivateService(name);
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ServiceException("An error occurred during service deactivation", t);
        }
    }

    public void becomeLeader(AMSEventQueueFeeder feeder) {
        try {
            this.myMainContainer.initSystemAgents(this, true);
            this.myMainContainer.startSystemAgents(this, feeder);
            this.myMainContainer.restartReplicatedAgents(this);
            this.myProfile.setParameter("backupmain", "false");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addPlatformListener(AgentManager.Listener l) throws ClassCastException {
        MainContainerImpl m = this.myMainContainer;
        m.addListener(l);
    }

    public void removePlatformListener(AgentManager.Listener l) throws ClassCastException {
        MainContainerImpl m = this.myMainContainer;
        m.removeListener(l);
    }

    private void initCredentials(Command cmd, AID id) {
        Agent agent = this.localAgents.acquire(id);
        if (agent != null) {
            try {
                CredentialsHelper ch = (CredentialsHelper)((Object)agent.getHelper("jade.core.security.Security"));
                cmd.setPrincipal(ch.getPrincipal());
                cmd.setCredentials(ch.getCredentials());
            }
            catch (ServiceException se) {
                // empty catch block
            }
        }
        this.localAgents.release(id);
    }
}

