/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Filter;
import jade.core.ServiceException;
import jade.core.Sink;
import jade.core.VerticalCommand;
import java.util.Hashtable;

class CommandProcessor {
    private Filter firstDownFilter;
    private Filter firstUpFilter;
    private final Hashtable downSinks = new Hashtable(4);
    private final Hashtable upSinks = new Hashtable(4);
    private SinksFilter lastDownFilter = new SinksFilter(this.downSinks);
    private SinksFilter lastUpFilter = new SinksFilter(this.upSinks);

    public CommandProcessor() {
        this.firstDownFilter = this.lastDownFilter;
        this.firstUpFilter = this.lastUpFilter;
    }

    public void addFilter(Filter f, boolean direction) {
        if (!direction) {
            this.firstUpFilter = this.insertFilter(f, this.firstUpFilter);
        } else {
            this.firstDownFilter = this.insertFilter(f, this.firstDownFilter);
        }
    }

    private synchronized Filter insertFilter(Filter f, Filter first) {
        if (f != null) {
            if (f.getPreferredPosition() < first.getPreferredPosition()) {
                f.setNext(first);
                return f;
            }
            Filter current = first;
            Filter next = current.getNext();
            while (true) {
                if (f.getPreferredPosition() < next.getPreferredPosition()) {
                    f.setNext(next);
                    current.setNext(f);
                    break;
                }
                current = next;
                next = current.getNext();
            }
        }
        return first;
    }

    public void removeFilter(Filter f, boolean direction) {
        if (!direction) {
            this.firstUpFilter = this.removeFilter(f, this.firstUpFilter);
        } else {
            this.firstDownFilter = this.removeFilter(f, this.firstDownFilter);
        }
    }

    private synchronized Filter removeFilter(Filter f, Filter first) {
        if (first != null && f != null) {
            if (f.equals(first)) {
                return first.getNext();
            }
            Filter current = first;
            Filter next = current.getNext();
            while (true) {
                if (f.equals(next)) {
                    current.setNext(next.getNext());
                    break;
                }
                current = next;
                next = current.getNext();
            }
        }
        return first;
    }

    public synchronized void registerSink(Sink snk, boolean side, String serviceName) throws ServiceException {
        Hashtable sinks = !side ? this.downSinks : this.upSinks;
        sinks.put(serviceName, snk);
    }

    public synchronized void deregisterSink(boolean side, String serviceName) throws ServiceException {
        Hashtable sinks = !side ? this.downSinks : this.upSinks;
        sinks.remove(serviceName);
    }

    public Object processOutgoing(VerticalCommand cmd) {
        this.firstDownFilter.filter(cmd);
        return cmd.getReturnValue();
    }

    public Object processIncoming(VerticalCommand cmd) {
        this.firstUpFilter.filter(cmd);
        return cmd.getReturnValue();
    }

    private class SinksFilter
    extends Filter {
        private Hashtable mySinks;

        private SinksFilter(Hashtable ht) {
            this.mySinks = ht;
            this.preferredPosition = 101;
        }

        protected boolean accept(VerticalCommand cmd) {
            Sink s;
            String service = cmd.getService();
            if (service != null && (s = (Sink)this.mySinks.get(service)) != null) {
                s.consume(cmd);
            }
            return false;
        }
    }
}

