/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessageManager;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import jade.util.leap.HashMap;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import jade.util.leap.Map;
import jade.util.leap.RoundList;

class OutBox {
    private int size = 0;
    private int maxSize;
    private boolean overMaxSize = false;
    private final Map messagesByReceiver = new HashMap();
    private final RoundList messagesByOrder = new RoundList();
    private long submittedCnt = 0L;
    private long servedCnt = 0L;
    private Logger myLogger;

    OutBox(int s) {
        this.maxSize = s;
        this.myLogger = Logger.getMyLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLast(AID receiverID, GenericMessage msg, MessageManager.Channel ch) {
        ACLMessage acl;
        boolean logActivated = this.myLogger.isLoggable(Logger.FINER);
        if (logActivated) {
            this.myLogger.log(Logger.FINER, "Entering addLast for receiver " + receiverID.getName());
        }
        if (msg.getPayload() != null && msg.isModifiable() && (acl = msg.getACLMessage()) != null) {
            acl.setContent(null);
        }
        this.increaseSize(msg.length());
        OutBox outBox = this;
        synchronized (outBox) {
            Box b = (Box)this.messagesByReceiver.get(receiverID);
            if (logActivated) {
                String msgDebug = b == null ? "No box for receiver " + receiverID.getName() : "Box for receiver " + receiverID.getName() + " busy ?  " + b.isBusy();
                this.myLogger.log(Logger.FINER, msgDebug);
            }
            if (b == null) {
                b = new Box(receiverID);
                this.messagesByReceiver.put(receiverID, b);
                this.messagesByOrder.add(b);
                if (logActivated) {
                    this.myLogger.log(Logger.FINER, "Box created for receiver " + receiverID.getName());
                }
            }
            if (logActivated) {
                this.myLogger.log(Logger.FINER, "Message entered in box for receiver " + receiverID.getName());
            }
            b.addLast(new MessageManager.PendingMsg(msg, receiverID, ch, -1L));
            ++this.submittedCnt;
            this.notifyAll();
        }
        if (logActivated) {
            this.myLogger.log(Logger.FINER, "Exiting addLast for receiver " + receiverID.getName());
        }
    }

    final synchronized MessageManager.PendingMsg get() {
        Box b = null;
        while ((b = this.getNextIdle()) == null) {
            try {
                if (this.myLogger.isLoggable(Logger.FINER)) {
                    this.myLogger.log(Logger.FINER, "Deliverer " + Thread.currentThread() + " go to sleep...");
                }
                this.wait();
                if (!this.myLogger.isLoggable(Logger.FINER)) continue;
                this.myLogger.log(Logger.FINER, "Deliverer " + Thread.currentThread() + " wake up");
            }
            catch (InterruptedException ie) {}
        }
        MessageManager.PendingMsg pm = b.removeFirst();
        this.decreaseSize(pm.getMessage().length());
        return pm;
    }

    private final Box getNextIdle() {
        for (int i = 0; i < this.messagesByOrder.size(); ++i) {
            Box b = (Box)this.messagesByOrder.get();
            if (b.isBusy()) continue;
            b.setBusy(true);
            if (this.myLogger.isLoggable(Logger.FINER)) {
                this.myLogger.log(Logger.FINER, "Setting box busy for receiver " + b.getReceiver().getName());
            }
            return b;
        }
        return null;
    }

    final synchronized void handleServed(AID receiverID) {
        Box b;
        ++this.servedCnt;
        boolean logActivated = this.myLogger.isLoggable(Logger.FINER);
        if (logActivated) {
            this.myLogger.log(Logger.FINER, "Entering handleServed for " + receiverID.getName());
        }
        if ((b = (Box)this.messagesByReceiver.get(receiverID)).isEmpty()) {
            this.messagesByReceiver.remove(receiverID);
            this.messagesByOrder.remove(b);
            if (logActivated) {
                this.myLogger.log(Logger.FINER, "Removed box for receiver " + receiverID.getName());
            }
        } else {
            b.setBusy(false);
            if (logActivated) {
                this.myLogger.log(Logger.FINER, "Freeing box for receiver " + receiverID.getName());
            }
        }
        if (logActivated) {
            this.myLogger.log(Logger.FINER, "Exiting handleServed for " + receiverID.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseSize(int k) {
        long sleepTime = 0L;
        OutBox outBox = this;
        synchronized (outBox) {
            this.size += k;
            if (this.size > this.maxSize) {
                if (!this.overMaxSize) {
                    this.myLogger.log(Logger.WARNING, "MessageManager queue size > " + this.maxSize);
                    this.overMaxSize = true;
                }
                sleepTime = (1 + (this.size - this.maxSize) / 1000000) * 100;
            }
        }
        if (sleepTime > 0L) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    private void decreaseSize(int k) {
        this.size -= k;
        if (this.size < this.maxSize && this.overMaxSize) {
            this.myLogger.log(Logger.INFO, "MessageManager queue size < " + this.maxSize);
            this.overMaxSize = false;
        }
    }

    synchronized String[] getStatus() {
        Object[] boxes = this.messagesByOrder.toArray();
        String[] status = new String[boxes.length];
        for (int i = 0; i < boxes.length; ++i) {
            status[i] = boxes[i].toString();
        }
        return status;
    }

    int getSize() {
        return this.size;
    }

    long getSubmittedCnt() {
        return this.submittedCnt;
    }

    long getServedCnt() {
        return this.servedCnt;
    }

    private class Box {
        private final AID receiver;
        private boolean busy;
        private String owner;
        private final List messages;

        public Box(AID r) {
            this.receiver = r;
            this.busy = false;
            this.messages = new LinkedList();
        }

        private AID getReceiver() {
            return this.receiver;
        }

        private void setBusy(boolean b) {
            this.busy = b;
            this.owner = this.busy ? Thread.currentThread().getName() : null;
        }

        private boolean isBusy() {
            return this.busy;
        }

        private void addLast(MessageManager.PendingMsg pm) {
            this.messages.add(pm);
        }

        private MessageManager.PendingMsg removeFirst() {
            return (MessageManager.PendingMsg)this.messages.remove(0);
        }

        private boolean isEmpty() {
            return this.messages.isEmpty();
        }

        public String toString() {
            return "(" + this.receiver.getName() + " :busy " + this.busy + (this.owner != null ? " :owner " + this.owner : "") + " :message-cnt " + this.messages.size() + ")";
        }
    }
}

