/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.AID;
import jade.core.ContainerID;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.Node;
import jade.core.NodeDescriptor;
import jade.core.PlatformManager;
import jade.core.Service;
import jade.core.ServiceDescriptor;
import jade.core.SliceProxy;
import jade.core.messaging.GenericMessage;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ReceivedObject;
import jade.imtp.leap.Command;
import jade.imtp.leap.JICP.JICPAddress;
import jade.imtp.leap.LEAPSerializationException;
import jade.imtp.leap.NodeStub;
import jade.imtp.leap.PlatformManagerStub;
import jade.imtp.leap.Serializer;
import jade.imtp.leap.Stub;
import jade.imtp.leap.StubHelper;
import jade.imtp.leap.http.HTTPAddress;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.LEAPACLCodec;
import jade.mtp.MTPDescriptor;
import jade.mtp.TransportAddress;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.Properties;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

class DeliverableDataOutputStream
extends DataOutputStream {
    private StubHelper myStubHelper;

    public DeliverableDataOutputStream(StubHelper sh) {
        super(new ByteArrayOutputStream());
        this.myStubHelper = sh;
    }

    public byte[] getSerializedByteArray() {
        return ((ByteArrayOutputStream)this.out).toByteArray();
    }

    public void writeObject(Object o) throws LEAPSerializationException {
        try {
            if (o != null) {
                this.writeBoolean(true);
                if (o instanceof HorizontalCommand) {
                    this.writeByte(28);
                    this.serializeHorizontalCommand((HorizontalCommand)o);
                } else if (o instanceof ACLMessage) {
                    this.writeByte(0);
                    this.serializeACL((ACLMessage)o);
                } else if (o instanceof AID) {
                    this.writeByte(1);
                    this.serializeAID((AID)o);
                } else if (o instanceof AID[]) {
                    this.writeByte(2);
                    this.serializeAIDArray((AID[])o);
                } else if (o instanceof GenericMessage) {
                    this.writeByte(35);
                    this.serializeGenericMessage((GenericMessage)o);
                } else if (o instanceof String) {
                    this.writeByte(11);
                    this.writeUTF((String)o);
                } else if (o instanceof NodeDescriptor) {
                    this.writeByte(10);
                    this.serializeNodeDescriptor((NodeDescriptor)o);
                } else if (o instanceof ContainerID) {
                    this.writeByte(5);
                    this.serializeContainerID((ContainerID)o);
                } else if (o instanceof ContainerID[]) {
                    this.writeByte(6);
                    this.serializeContainerIDArray((ContainerID[])o);
                } else if (o instanceof Boolean) {
                    this.writeByte(3);
                    this.writeBoolean((Boolean)o);
                } else if (o instanceof Integer) {
                    this.writeByte(9);
                    this.writeInt((Integer)o);
                } else if (o instanceof Date) {
                    this.writeByte(7);
                    this.serializeDate((Date)o);
                } else if (o instanceof String[]) {
                    this.writeByte(12);
                    this.serializeStringArray((String[])o);
                } else if (o instanceof Vector) {
                    this.writeByte(13);
                    this.serializeVector((Vector)o);
                } else if (o instanceof MTPDescriptor) {
                    this.writeByte(14);
                    this.serializeMTPDescriptor((MTPDescriptor)o);
                } else if (o instanceof Node) {
                    this.writeByte(15);
                    this.serializeNode((Node)o);
                } else if (o instanceof PlatformManager) {
                    this.writeByte(34);
                    this.serializePlatformManager((PlatformManager)o);
                } else if (o instanceof Node[]) {
                    this.writeByte(16);
                    this.serializeNodeArray((Node[])o);
                } else if (o instanceof ArrayList) {
                    this.writeByte(18);
                    this.serializeArrayList((ArrayList)o);
                } else if (o instanceof byte[]) {
                    this.writeByte(19);
                    this.serializeByteArray((byte[])o);
                } else if (o instanceof Envelope) {
                    this.writeByte(17);
                    this.serializeEnvelope((Envelope)o);
                } else if (o instanceof JICPAddress) {
                    this.writeByte(22);
                    this.serializeTransportAddress((JICPAddress)o);
                } else if (o instanceof HTTPAddress) {
                    this.writeByte(23);
                    this.serializeTransportAddress((HTTPAddress)o);
                } else if (o instanceof Properties) {
                    this.writeByte(20);
                    this.serializeProperties((Properties)o);
                } else if (o instanceof ReceivedObject) {
                    this.writeByte(21);
                    this.serializeReceivedObject((ReceivedObject)o);
                } else if (o instanceof ServiceDescriptor) {
                    this.writeByte(32);
                    this.serializeServiceDescriptor((ServiceDescriptor)o);
                } else if (o instanceof SliceProxy) {
                    this.writeByte(36);
                    this.serializeSliceProxy((SliceProxy)o);
                } else if (o instanceof Service.SliceProxy) {
                    this.writeByte(33);
                    this.serializeServiceSliceProxy((Service.SliceProxy)o);
                } else if (o instanceof Property) {
                    this.writeByte(30);
                    this.serializeProperty((Property)o);
                } else if (o instanceof Serializable) {
                    this.writeByte(31);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ObjectOutputStream encoder = new ObjectOutputStream(out);
                    encoder.writeObject(o);
                    byte[] bytes = out.toByteArray();
                    this.serializeByteArray(bytes);
                } else {
                    Serializer s = this.getSerializer(o);
                    this.writeByte(8);
                    this.writeUTF(s.getClass().getName());
                    s.serialize(o, this);
                }
            } else {
                this.writeBoolean(false);
            }
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error Serializing object " + o);
        }
    }

    public void writeAID(AID id) throws LEAPSerializationException {
        try {
            if (id != null) {
                this.writeBoolean(true);
                this.serializeAID(id);
            } else {
                this.writeBoolean(false);
            }
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error serializing AID");
        }
    }

    public void writeString(String s) throws LEAPSerializationException {
        try {
            if (s != null) {
                this.writeBoolean(true);
                this.writeUTF(s);
            } else {
                this.writeBoolean(false);
            }
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error serializing String");
        }
    }

    public void writeDate(Date d) throws LEAPSerializationException {
        try {
            if (d != null) {
                this.writeBoolean(true);
                this.serializeDate(d);
            } else {
                this.writeBoolean(false);
            }
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error serializing Date");
        }
    }

    public void writeStringBuffer(StringBuffer s) throws LEAPSerializationException {
        try {
            if (s != null) {
                this.writeBoolean(true);
                this.serializeStringBuffer(s);
            } else {
                this.writeBoolean(false);
            }
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error serializing String");
        }
    }

    public void writeVector(Vector v) throws LEAPSerializationException {
        try {
            if (v != null) {
                this.writeBoolean(true);
                this.serializeVector(v);
            } else {
                this.writeBoolean(false);
            }
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error serializing Vector");
        }
    }

    public void writeStringArray(String[] sa) throws LEAPSerializationException {
        try {
            if (sa != null) {
                this.writeBoolean(true);
                this.serializeStringArray(sa);
            } else {
                this.writeBoolean(false);
            }
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error serializing String[]");
        }
    }

    private void serializeDate(Date d) throws IOException {
        this.writeLong(d.getTime());
    }

    private void serializeStringBuffer(StringBuffer sb) throws IOException {
        this.writeUTF(sb.toString());
    }

    private void serializeVector(Vector v) throws IOException, LEAPSerializationException {
        this.writeInt(v.size());
        for (int i = 0; i < v.size(); ++i) {
            this.writeObject(v.elementAt(i));
        }
    }

    private void serializeStringArray(String[] sa) throws IOException, LEAPSerializationException {
        this.writeInt(sa.length);
        for (int i = 0; i < sa.length; ++i) {
            this.writeString(sa[i]);
        }
    }

    private void serializeNodeDescriptor(NodeDescriptor desc) throws IOException, LEAPSerializationException {
        this.serializeNode(desc.getNode());
        this.writeContainerID(desc.getContainer());
        this.writeNode(desc.getParentNode());
        this.writeString(desc.getUsername());
        this.writeObject(desc.getPassword());
        this.writeObject(desc.getPrincipal());
        this.writeObject(desc.getOwnerPrincipal());
        this.writeObject(desc.getOwnerCredentials());
    }

    private void serializeHorizontalCommand(HorizontalCommand cmd) throws LEAPSerializationException {
        try {
            this.writeUTF(cmd.getName());
            this.writeUTF(cmd.getService());
            this.writeString(cmd.getInteraction());
            Object[] params = cmd.getParams();
            int sz = params.length;
            this.writeInt(sz);
            for (int i = 0; i < sz; ++i) {
                this.writeObject(params[i]);
            }
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error serializing horizontal command");
        }
    }

    private void serializeACL(ACLMessage msg) throws IOException, LEAPSerializationException {
        LEAPACLCodec.serializeACL(msg, this);
        Envelope env = msg.getEnvelope();
        if (env != null) {
            this.writeBoolean(true);
            this.serializeEnvelope(env);
        } else {
            this.writeBoolean(false);
        }
    }

    void serializeAID(AID id) throws IOException, LEAPSerializationException {
        LEAPACLCodec.serializeAID(id, this);
    }

    private void serializeAIDArray(AID[] aida) throws IOException, LEAPSerializationException {
        this.writeInt(aida.length);
        for (int i = 0; i < aida.length; ++i) {
            this.writeAID(aida[i]);
        }
    }

    private void serializeGenericMessage(GenericMessage gm) throws IOException, LEAPSerializationException {
        byte[] payload = gm.getPayload();
        if (payload == null) {
            payload = new LEAPACLCodec().encode(gm.getACLMessage(), null);
        }
        this.serializeByteArray(payload);
        this.writeObject(gm.getEnvelope());
        this.writeBoolean(gm.isAMSFailure());
        this.writeObject(gm.getTraceID());
    }

    void serializeCommand(Command cmd) throws LEAPSerializationException {
        try {
            this.writeInt(cmd.getCode());
            this.writeInt(cmd.getObjectID());
            int paramCnt = cmd.getParamCnt();
            this.writeInt(paramCnt);
            for (int i = 0; i < paramCnt; ++i) {
                this.writeObject(cmd.getParamAt(i));
            }
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error serializing Command");
        }
    }

    public void serializeContainerID(ContainerID cid) throws LEAPSerializationException {
        try {
            this.writeUTF(cid.getName());
            this.writeUTF(cid.getAddress());
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error serializing ContainerID");
        }
    }

    public void writeContainerID(ContainerID id) throws LEAPSerializationException {
        try {
            if (id != null) {
                this.writeBoolean(true);
                this.serializeContainerID(id);
            } else {
                this.writeBoolean(false);
            }
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error serializing ContainerID");
        }
    }

    private void serializeContainerIDArray(ContainerID[] cida) throws IOException, LEAPSerializationException {
        this.writeInt(cida.length);
        for (int i = 0; i < cida.length; ++i) {
            this.writeContainerID(cida[i]);
        }
    }

    public void serializeMTPDescriptor(MTPDescriptor dsc) throws LEAPSerializationException {
        try {
            this.writeUTF(dsc.getName());
            this.writeUTF(dsc.getClassName());
            this.writeStringArray(dsc.getAddresses());
            this.writeStringArray(dsc.getSupportedProtocols());
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error serializing MTPDescriptor");
        }
    }

    private void serializeServiceDescriptor(ServiceDescriptor dsc) throws LEAPSerializationException {
        try {
            this.writeUTF(dsc.getName());
            Service svc = dsc.getService();
            this.writeUTF(svc.getClass().getName());
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error serializing ServiceDescriptor");
        }
    }

    private void serializeSliceProxy(SliceProxy proxy) throws LEAPSerializationException {
        try {
            this.writeUTF(proxy.getClass().getName());
            this.writeNode(proxy.getNode());
        }
        catch (Throwable t) {
            throw new LEAPSerializationException("Error serializing SliceProxy");
        }
    }

    private void serializeServiceSliceProxy(Service.SliceProxy proxy) throws LEAPSerializationException {
        try {
            this.writeUTF(proxy.getClass().getName());
            this.writeNode(proxy.getNode());
        }
        catch (Throwable t) {
            throw new LEAPSerializationException("Error serializing Service.SliceProxy");
        }
    }

    private void serializeNode(Node n) throws LEAPSerializationException {
        try {
            this.writeString(n.getName());
            this.writeBoolean(n.hasPlatformManager());
            NodeStub stub = null;
            stub = n instanceof NodeStub ? (NodeStub)n : (NodeStub)this.myStubHelper.buildLocalStub(n);
            this.serializeStub(stub);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new LEAPSerializationException("Error building a Node stub");
        }
        catch (IMTPException imtpe) {
            imtpe.printStackTrace();
            throw new LEAPSerializationException("Error building a Node stub");
        }
    }

    private void writeNode(Node n) throws LEAPSerializationException {
        try {
            if (n != null) {
                this.writeBoolean(true);
                this.serializeNode(n);
            } else {
                this.writeBoolean(false);
            }
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error serializing Node[]");
        }
    }

    private void serializePlatformManager(PlatformManager pm) throws LEAPSerializationException {
        try {
            this.writeString(pm.getLocalAddress());
            PlatformManagerStub stub = null;
            stub = pm instanceof PlatformManagerStub ? (PlatformManagerStub)pm : (PlatformManagerStub)this.myStubHelper.buildLocalStub(pm);
            this.serializeStub(stub);
        }
        catch (IMTPException imtpe) {
            imtpe.printStackTrace();
            throw new LEAPSerializationException("Error building a PlatformManager stub");
        }
    }

    private void serializeStub(Stub stub) throws LEAPSerializationException {
        try {
            this.writeUTF(stub.getClass().getName());
            this.writeInt(stub.remoteID);
            this.writeString(stub.platformName);
            this.serializeArrayList((ArrayList)stub.remoteTAs);
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("I/O Error during stub serialization");
        }
    }

    private void serializeNodeArray(Node[] nodes) throws LEAPSerializationException {
        try {
            this.writeInt(nodes.length);
            for (int i = 0; i < nodes.length; ++i) {
                this.writeNode(nodes[i]);
            }
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("IO error serializing node array");
        }
    }

    public void writeNodeArray(Node[] nodes) throws LEAPSerializationException {
        try {
            if (nodes != null) {
                this.writeBoolean(true);
                this.serializeNodeArray(nodes);
            } else {
                this.writeBoolean(false);
            }
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("Error serializing Node[]");
        }
    }

    private void serializeArrayList(ArrayList l) throws LEAPSerializationException {
        try {
            int size = l.size();
            this.writeInt(size);
            for (int i = 0; i < size; ++i) {
                this.writeObject(l.get(i));
            }
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("I/O error serializing ArrayList " + l);
        }
    }

    private void serializeByteArray(byte[] ba) throws LEAPSerializationException {
        try {
            this.writeInt(ba.length);
            this.write(ba, 0, ba.length);
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("IO error serializing byte[] " + ba);
        }
    }

    private void serializeEnvelope(Envelope e) throws LEAPSerializationException {
        try {
            Iterator it = e.getAllTo();
            while (it.hasNext()) {
                this.writeBoolean(true);
                this.serializeAID((AID)it.next());
            }
            this.writeBoolean(false);
            this.writeAID(e.getFrom());
            this.writeString(e.getComments());
            this.writeString(e.getAclRepresentation());
            this.writeLong(e.getPayloadLength());
            this.writeString(e.getPayloadEncoding());
            this.writeDate(e.getDate());
            it = e.getAllIntendedReceiver();
            while (it.hasNext()) {
                this.writeBoolean(true);
                this.serializeAID((AID)it.next());
            }
            this.writeBoolean(false);
            this.writeObject(e.getReceived());
            it = e.getAllProperties();
            while (it.hasNext()) {
                this.writeBoolean(true);
                this.serializeProperty((Property)it.next());
            }
            this.writeBoolean(false);
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("IO error serializing Envelope " + e);
        }
    }

    private void serializeTransportAddress(TransportAddress addr) throws LEAPSerializationException {
        this.writeString(addr.getProto());
        this.writeString(addr.getHost());
        this.writeString(addr.getPort());
        this.writeString(addr.getFile());
        this.writeString(addr.getAnchor());
    }

    private void serializeProperties(Properties p) throws LEAPSerializationException {
        try {
            int size = p.size();
            this.writeInt(size);
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                this.writeObject(key);
                this.writeObject(p.getProperty((String)key));
            }
        }
        catch (IOException ioe) {
            throw new LEAPSerializationException("I/O error serializing Properties " + p);
        }
    }

    private void serializeReceivedObject(ReceivedObject r) throws LEAPSerializationException {
        this.writeString(r.getBy());
        this.writeString(r.getFrom());
        this.writeDate(r.getDate());
        this.writeString(r.getId());
        this.writeString(r.getVia());
    }

    private void serializeProperty(Property p) throws LEAPSerializationException {
        this.writeString(p.getName());
        this.writeObject(p.getValue());
    }

    private void serializeThrowable(Throwable t) throws LEAPSerializationException {
        this.writeString(t.getClass().getName());
        this.writeString(t.getMessage());
    }

    private Serializer getSerializer(Object o) throws LEAPSerializationException {
        String fullName = o.getClass().getName();
        int index = fullName.lastIndexOf(46);
        String name = fullName.substring(index + 1);
        String serName = new String("jade.imtp.leap." + name + "Serializer");
        try {
            Serializer s = (Serializer)Class.forName(serName).newInstance();
            return s;
        }
        catch (Exception e) {
            throw new LEAPSerializationException("Error creating Serializer for object " + o);
        }
    }
}

