/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.core.Profile;
import jade.imtp.leap.FrontEndStub;
import jade.imtp.leap.ICP;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.ConnectionFactory;
import jade.imtp.leap.JICP.JICPMediator;
import jade.imtp.leap.JICP.JICPMediatorManager;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.JICP.JICPPeer;
import jade.imtp.leap.JICP.PDPContextManager;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JICPServer
extends Thread
implements PDPContextManager.Listener,
JICPMediatorManager {
    private static final int INIT = 0;
    private static final int REQUEST_READ = 1;
    private static final int REQUEST_SERVED = 2;
    private static final int RESPONSE_SENT = 3;
    public static final String ACCEPT_LOCAL_HOST_ONLY = "jade_imtp_leap_JICP_JICPServer_acceptlocalhostonly";
    public static final String UNCHECK_LOCAL_HOST = "jade_imtp_leap_JICP_JICPServer_unchecklocalhost";
    private static final int LISTENING = 0;
    private static final int TERMINATING = 1;
    private int state = 0;
    private String host;
    private ServerSocket server;
    private ICP.Listener cmdListener;
    private int mediatorCnt = 1;
    private Hashtable mediators = new Hashtable();
    public static final String ACCEPT_MEDIATORS = "jade_imtp_leap_JICP_JICPServer_acceptmediators";
    private boolean acceptMediators = true;
    private Properties leapProps = new Properties();
    private PDPContextManager myPDPContextManager;
    private int maxHandlers;
    private Vector connectionHandlers = new Vector();
    private ConnectionFactory connFactory;
    private Logger myLogger;

    public JICPServer(Profile p, JICPPeer myPeer, ICP.Listener l, ConnectionFactory f, int max) throws ICPException {
        int idLength;
        this.cmdListener = l;
        this.connFactory = f;
        this.maxHandlers = max;
        this.myLogger = Logger.getMyLogger(this.getClass().getName());
        StringBuffer sb = null;
        String peerID = myPeer.getID();
        if (peerID != null) {
            sb = new StringBuffer(peerID);
            sb.append('-');
            idLength = sb.length();
        } else {
            sb = new StringBuffer();
            idLength = 0;
        }
        sb.append("local-host");
        this.host = p.getParameter(sb.toString(), null);
        boolean acceptLocalHostOnly = false;
        if (this.host == null || this.host.equals("localhost")) {
            sb.setLength(idLength);
            sb.append("remote-url");
            String remoteURL = p.getParameter(sb.toString(), null);
            this.host = remoteURL != null ? myPeer.getAddress(remoteURL) : Profile.getDefaultNetworkName();
        } else {
            if (!p.getBooleanProperty(UNCHECK_LOCAL_HOST, false) && !Profile.isLocalHost(this.host)) {
                throw new ICPException("Error: Not possible to launch JADE on a remote host (" + this.host + "). Check the -host and -local-host options.");
            }
            acceptLocalHostOnly = p.getBooleanProperty(ACCEPT_LOCAL_HOST_ONLY, false);
        }
        int port = 1099;
        boolean changePortIfBusy = !p.getBooleanProperty("main", true) || p.getBooleanProperty("jade_imtp_leap_LEAPIMTPManager_changeportifbusy", false);
        sb.setLength(idLength);
        sb.append("local-port");
        String strPort = p.getParameter(sb.toString(), null);
        try {
            port = Integer.parseInt(strPort);
        }
        catch (Exception e) {
            try {
                port = Integer.parseInt(peerID);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        this.acceptMediators = p.getBooleanProperty(ACCEPT_MEDIATORS, true);
        if (this.acceptMediators) {
            sb.setLength(idLength);
            sb.append("leap-property-file");
            String fileName = p.getParameter(sb.toString(), "leap.properties");
            try {
                this.leapProps.load(fileName);
            }
            catch (Exception e) {
                this.myLogger.log(Logger.FINE, "Can't read LEAP property file " + fileName + ". " + e);
            }
            String pdpContextManagerClass = this.leapProps.getProperty("pdp-context-manager");
            if (pdpContextManagerClass != null) {
                try {
                    this.myLogger.log(Logger.INFO, "Loading PDPContextManager of class " + pdpContextManagerClass);
                    this.myPDPContextManager = (PDPContextManager)Class.forName(pdpContextManagerClass).newInstance();
                    this.myPDPContextManager.init(this.leapProps);
                    this.myPDPContextManager.registerListener(this);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.myPDPContextManager = null;
                }
            }
        }
        this.server = myPeer.getServerSocket(acceptLocalHostOnly ? this.host : null, port, changePortIfBusy);
        this.setDaemon(true);
        this.setName("JICPServer-" + this.getLocalPort());
    }

    public int getLocalPort() {
        return this.server.getLocalPort();
    }

    public String getLocalHost() {
        return this.host;
    }

    public synchronized void shutdown() {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Shutting down JICPServer...");
        }
        this.state = 1;
        try {
            this.server.close();
            this.join();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.state != 1) {
            try {
                Socket s = this.server.accept();
                InetAddress addr = s.getInetAddress();
                int port = s.getPort();
                if (this.myLogger.isLoggable(Logger.FINEST)) {
                    this.myLogger.log(Logger.FINEST, "Incoming connection from " + addr + ":" + port);
                }
                Connection c = this.connFactory.createConnection(s);
                ConnectionHandler ch = new ConnectionHandler(c, addr, port);
                if (this.myLogger.isLoggable(Logger.FINEST)) {
                    this.myLogger.log(Logger.FINEST, "Create new ConnectionHandler (" + ch + ")");
                }
                this.connectionHandlers.addElement(ch);
                ch.start();
            }
            catch (InterruptedIOException e) {
            }
            catch (Exception e) {
                if (this.state != 0) continue;
                if (this.myLogger.isLoggable(Logger.WARNING)) {
                    this.myLogger.log(Logger.WARNING, "Problems accepting a new connection");
                }
                e.printStackTrace();
                this.state = 1;
            }
        }
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "JICPServer terminated");
        }
        try {
            this.server.close();
        }
        catch (IOException io) {
            if (this.myLogger.isLoggable(Logger.WARNING)) {
                this.myLogger.log(Logger.WARNING, "I/O error closing the server socket");
            }
            io.printStackTrace();
        }
        this.server = null;
        Vector io = this.connectionHandlers;
        synchronized (io) {
            Enumeration en = this.connectionHandlers.elements();
            while (en.hasMoreElements()) {
                ConnectionHandler ch = (ConnectionHandler)en.nextElement();
                ch.close();
            }
        }
        Enumeration e = this.mediators.elements();
        while (e.hasMoreElements()) {
            JICPMediator m = (JICPMediator)e.nextElement();
            m.kill();
        }
        this.mediators.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(long currentTime) {
        Hashtable hashtable = this.mediators;
        synchronized (hashtable) {
            Enumeration e = this.mediators.elements();
            while (e.hasMoreElements()) {
                JICPMediator m = (JICPMediator)e.nextElement();
                m.tick(currentTime);
            }
        }
    }

    public void deregisterMediator(String id) {
        this.myLogger.log(Logger.FINE, "Deregistering mediator " + id);
        this.mediators.remove(id);
    }

    public void handlePDPContextClosed(String id) {
    }

    private void mergeProperties(Properties p1, Properties p2) {
        Enumeration<?> e = p2.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            p1.setProperty(key, p2.getProperty(key));
        }
    }

    private JICPMediator startMediator(String id, Properties p) throws Exception {
        String className = p.getProperty("mediator-class");
        if (className != null) {
            JICPMediator m = (JICPMediator)Class.forName(className).newInstance();
            this.mergeProperties(p, this.leapProps);
            this.myLogger.log(Logger.FINE, "Initializing mediator " + id + " with properties " + p);
            m.init(this, id, p);
            return m;
        }
        throw new ICPException("No JICPMediator class specified.");
    }

    private void waitABit(long t) {
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static /* synthetic */ Hashtable access$100(JICPServer x0) {
        return x0.mediators;
    }

    static /* synthetic */ ICP.Listener access$200(JICPServer x0) {
        return x0.cmdListener;
    }

    static /* synthetic */ Vector access$300(JICPServer x0) {
        return x0.connectionHandlers;
    }

    static /* synthetic */ int access$400(JICPServer x0) {
        return x0.maxHandlers;
    }

    static /* synthetic */ boolean access$500(JICPServer x0) {
        return x0.acceptMediators;
    }

    static /* synthetic */ PDPContextManager access$600(JICPServer x0) {
        return x0.myPDPContextManager;
    }

    static /* synthetic */ void access$700(JICPServer x0, Properties x1, Properties x2) {
        x0.mergeProperties(x1, x2);
    }

    static /* synthetic */ int access$808(JICPServer x0) {
        return x0.mediatorCnt++;
    }

    static /* synthetic */ void access$900(JICPServer x0, long x1) {
        x0.waitABit(x1);
    }

    static /* synthetic */ JICPMediator access$1000(JICPServer x0, String x1, Properties x2) throws Exception {
        return x0.startMediator(x1, x2);
    }

    class ConnectionHandler
    extends Thread {
        private Connection c;
        private InetAddress addr;
        private int port;
        private boolean loop = false;
        private int status = 0;
        private boolean closeConnection = true;

        public ConnectionHandler(Connection c, InetAddress addr, int port) {
            this.c = c;
            this.addr = addr;
            this.port = port;
        }

        public void close() {
            block6: {
                if (this.status != 3) {
                    this.loop = false;
                    this.closeConnection = true;
                    if (JICPServer.this.myLogger.isLoggable(Logger.FINEST)) {
                        JICPServer.this.myLogger.log(Logger.FINEST, "Predispose to close connection handler (" + this + ")");
                    }
                } else {
                    try {
                        if (JICPServer.this.myLogger.isLoggable(Logger.FINEST)) {
                            JICPServer.this.myLogger.log(Logger.FINEST, "Close connection socket to force exit from connection handler (" + this + ")");
                        }
                        this.c.close();
                    }
                    catch (IOException e) {
                        if (!JICPServer.this.myLogger.isLoggable(Logger.FINEST)) break block6;
                        JICPServer.this.myLogger.log(Logger.FINEST, "Exception closing connection with " + this.addr + ":" + this.port);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block71: {
                if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.FINEST)) {
                    JICPServer.access$000(JICPServer.this).log(Logger.FINEST, "CommandHandler started");
                }
                type = 0;
                try {
                    try {}
                    catch (Exception e) {
                        switch (this.status) {
                            case 0: {
                                if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.SEVERE)) {
                                    JICPServer.access$000(JICPServer.this).log(Logger.SEVERE, "Communication error reading incoming packet from " + this.addr + ":" + this.port);
                                }
                                e.printStackTrace();
                                break;
                            }
                            case 1: {
                                if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.SEVERE)) {
                                    JICPServer.access$000(JICPServer.this).log(Logger.SEVERE, "Error handling incoming packet");
                                }
                                e.printStackTrace();
                                if (type == 0 && this.c != null) {
                                    try {
                                        this.c.writePacket(new JICPPacket("Unexpected error", e));
                                    }
                                    catch (IOException ioe) {
                                        if (!JICPServer.access$000(JICPServer.this).isLoggable(Logger.WARNING)) break;
                                        JICPServer.access$000(JICPServer.this).log(Logger.WARNING, "Can't send back error indication " + ioe);
                                    }
                                }
                                break;
                            }
                            case 2: {
                                if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.SEVERE)) {
                                    JICPServer.access$000(JICPServer.this).log(Logger.SEVERE, "Communication error writing return packet to " + this.addr + ":" + this.port + " [" + e.toString() + "]");
                                }
                                break;
                            }
                            case 3: {
                                if (e instanceof EOFException) {
                                    if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.FINE)) {
                                        JICPServer.access$000(JICPServer.this).log(Logger.FINE, "Client " + this.addr + ":" + this.port + " has closed the connection.");
                                    }
                                } else if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.FINE)) {
                                    JICPServer.access$000(JICPServer.this).log(Logger.FINE, "Unexpected client " + this.addr + ":" + this.port + " termination. " + e.toString());
                                }
                                break;
                            }
                        }
                        var13_17 = null;
                        try {
                            if (this.closeConnection) {
                                if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.FINEST)) {
                                    JICPServer.access$000(JICPServer.this).log(Logger.FINEST, "Closing connection with " + this.addr + ":" + this.port);
                                }
                                this.c.close();
                            }
                        }
                        catch (IOException io) {
                            if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.INFO)) {
                                JICPServer.access$000(JICPServer.this).log(Logger.INFO, "I/O error while closing the connection");
                            }
                            io.printStackTrace();
                        }
                        JICPServer.access$300(JICPServer.this).remove(this);
                        if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.FINEST) == false) return;
                        JICPServer.access$000(JICPServer.this).log(Logger.FINEST, "ConnectionHandler closed (" + this + ")");
                        return;
                    }
                }
                catch (Throwable var12_22) {
                    block70: {
                        var13_18 = null;
                        ** try [egrp 4[TRYBLOCK] [6 : 2141->2221)] { 
lbl65:
                        // 1 sources

                        if (this.closeConnection) {
                            if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.FINEST)) {
                                JICPServer.access$000(JICPServer.this).log(Logger.FINEST, "Closing connection with " + this.addr + ":" + this.port);
                            }
                            this.c.close();
                        }
                        break block70;
lbl70:
                        // 1 sources

                        catch (IOException io) {
                            if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.INFO)) {
                                JICPServer.access$000(JICPServer.this).log(Logger.INFO, "I/O error while closing the connection");
                            }
                            io.printStackTrace();
                        }
                    }
                    JICPServer.access$300(JICPServer.this).remove(this);
                    if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.FINEST) == false) throw var12_22;
                    JICPServer.access$000(JICPServer.this).log(Logger.FINEST, "ConnectionHandler closed (" + this + ")");
                    throw var12_22;
                }
                do {
                    pkt = this.c.readPacket();
                    reply = null;
                    this.status = 1;
                    type = pkt.getType();
                    switch (type) {
                        case 0: 
                        case 1: {
                            recipientID = pkt.getRecipientID();
                            if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.FINEST)) {
                                JICPServer.access$000(JICPServer.this).log(Logger.FINEST, "Recipient: " + recipientID);
                            }
                            if (recipientID != null) {
                                m = (JICPMediator)JICPServer.access$100(JICPServer.this).get(recipientID);
                                if (m != null) {
                                    if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.FINEST)) {
                                        JICPServer.access$000(JICPServer.this).log(Logger.FINEST, "Passing incoming packet to mediator " + recipientID);
                                    }
                                    reply = m.handleJICPPacket(pkt, this.addr, this.port);
                                    break;
                                }
                                if (type != 0) break;
                                reply = new JICPPacket("Unknown recipient " + recipientID, null);
                                break;
                            }
                            this.loop = true;
                            if (type == 0) {
                                if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.FINEST)) {
                                    JICPServer.access$000(JICPServer.this).log(Logger.FINEST, "Passing incoming COMMAND to local listener");
                                }
                                rsp = JICPServer.access$200(JICPServer.this).handleCommand(pkt.getData());
                                dataInfo = 0;
                                if (JICPServer.access$300(JICPServer.this).size() >= JICPServer.access$400(JICPServer.this)) {
                                    dataInfo = (byte)(dataInfo | 64);
                                    this.loop = false;
                                }
                                reply = new JICPPacket(1, dataInfo, rsp);
                            }
                            if ((pkt.getInfo() & 64) == 0) break;
                            this.loop = false;
                            break;
                        }
                        case 21: {
                            if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.INFO)) {
                                JICPServer.access$000(JICPServer.this).log(Logger.INFO, "Received a GET_ADDRESS request from " + this.addr + ":" + this.port);
                            }
                            reply = new JICPPacket(21, 0, this.addr.getHostAddress().getBytes());
                            break;
                        }
                        case 22: {
                            if (JICPServer.access$500(JICPServer.this)) {
                                if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.INFO)) {
                                    JICPServer.access$000(JICPServer.this).log(Logger.INFO, "Received a CREATE_MEDIATOR request from " + this.addr + ":" + this.port);
                                }
                                if ((pn = (p = FrontEndStub.parseCreateMediatorRequest(s = new String(pkt.getData()))).getProperty("platform-id")) != null) {
                                    JICPServer.access$000(JICPServer.this).log(Logger.WARNING, "CREATE_MEDIATOR request with specified platform-name: " + pn);
                                    reply = new JICPPacket("Not-authorized", new JADESecurityException("Platform-name specified"));
                                    break;
                                }
                                if (JICPServer.access$600(JICPServer.this) != null) {
                                    try {
                                        pdpContextInfo = JICPServer.access$600(JICPServer.this).getPDPContextInfo(this.addr, p.getProperty("owner"));
                                        JICPServer.access$000(JICPServer.this).log(Logger.FINE, "PDPContext properties = " + pdpContextInfo);
                                        JICPServer.access$700(JICPServer.this, p, pdpContextInfo);
                                    }
                                    catch (JADESecurityException jse) {
                                        if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.WARNING)) {
                                            JICPServer.access$000(JICPServer.this).log(Logger.WARNING, "CREATE_MEDIATOR request from non authorized address: " + this.addr);
                                        }
                                        reply = new JICPPacket("Not-authorized", jse);
                                        break;
                                    }
                                }
                                id = p.getProperty("mediator-id");
                                msisdn = p.getProperty("msisdn");
                                if (id != null) {
                                    if (msisdn != null && !msisdn.equals(id)) {
                                        if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.WARNING)) {
                                            JICPServer.access$000(JICPServer.this).log(Logger.WARNING, "CREATE_MEDIATOR request with mediator-id != MSISDN. Address is: " + this.addr);
                                        }
                                        reply = new JICPPacket("Not-authorized", new JADESecurityException("Inconsistent mediator-id and msisdn"));
                                        break;
                                    }
                                    p.setProperty("jade_core_BackEndContainer_resynch", "true");
                                } else {
                                    id = msisdn;
                                    if (id == null) {
                                        id = "BE-" + JICPServer.this.getLocalHost() + ':' + JICPServer.this.getLocalPort() + '-' + String.valueOf(JICPServer.access$808(JICPServer.this));
                                    }
                                }
                                if (id.equals(msisdn) && (old = (JICPMediator)JICPServer.access$100(JICPServer.this).get(id)) != null) {
                                    JICPServer.access$000(JICPServer.this).log(Logger.INFO, "Replacing old mediator " + id);
                                    old.kill();
                                    JICPServer.access$900(JICPServer.this, 1000L);
                                }
                                this.closeConnection = (m = JICPServer.access$1000(JICPServer.this, id, p)).handleIncomingConnection(this.c, pkt, this.addr, this.port) == false;
                                JICPServer.access$100(JICPServer.this).put(m.getID(), m);
                                p.setProperty("mediator-id", m.getID());
                                p.setProperty("local-host", this.addr.getHostAddress());
                                replyMsg = FrontEndStub.encodeCreateMediatorResponse(p);
                                reply = new JICPPacket(1, 0, replyMsg.getBytes());
                                reply.setSessionID((byte)31);
                                break;
                            }
                            JICPServer.access$000(JICPServer.this).log(Logger.WARNING, "CREATE_MEDIATOR request received with accept-mediator option set to false. Address is: " + this.addr);
                            reply = new JICPPacket("Not-authorized", null);
                            break;
                        }
                        case 23: {
                            if (JICPServer.access$500(JICPServer.this)) {
                                recipientID = pkt.getRecipientID();
                                if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.INFO)) {
                                    JICPServer.access$000(JICPServer.this).log(Logger.INFO, "Received a CONNECT_MEDIATOR request from " + this.addr + ":" + this.port + ". Mediator ID is " + recipientID);
                                }
                                if ((m = (JICPMediator)JICPServer.access$100(JICPServer.this).get(recipientID)) != null) {
                                    this.closeConnection = m.handleIncomingConnection(this.c, pkt, this.addr, this.port) == false;
                                    reply = new JICPPacket(1, 0, this.addr.getHostAddress().getBytes());
                                    break;
                                }
                                if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.INFO)) {
                                    JICPServer.access$000(JICPServer.this).log(Logger.INFO, "Mediator " + recipientID + " not found");
                                }
                                reply = new JICPPacket("Not-found", null);
                                break;
                            }
                            JICPServer.access$000(JICPServer.this).log(Logger.WARNING, "CONNECT_MEDIATOR request received with accept-mediator option set to false. Address is: " + this.addr);
                            reply = new JICPPacket("Not-authorized", null);
                            break;
                        }
                        default: {
                            if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.WARNING)) {
                                JICPServer.access$000(JICPServer.this).log(Logger.WARNING, "Uncorrect JICP data type: " + pkt.getType());
                            }
                            reply = new JICPPacket("Uncorrect JICP data type: " + pkt.getType(), null);
                        }
                    }
                    this.status = 2;
                    if (reply != null) {
                        this.c.writePacket(reply);
                    }
                    this.status = 3;
                } while (this.loop);
                var13_16 = null;
                ** try [egrp 4[TRYBLOCK] [6 : 2141->2221)] { 
lbl199:
                // 1 sources

                if (this.closeConnection) {
                    if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.FINEST)) {
                        JICPServer.access$000(JICPServer.this).log(Logger.FINEST, "Closing connection with " + this.addr + ":" + this.port);
                    }
                    this.c.close();
                }
                break block71;
lbl204:
                // 1 sources

                catch (IOException io) {
                    if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.INFO)) {
                        JICPServer.access$000(JICPServer.this).log(Logger.INFO, "I/O error while closing the connection");
                    }
                    io.printStackTrace();
                }
            }
            JICPServer.access$300(JICPServer.this).remove(this);
            if (JICPServer.access$000(JICPServer.this).isLoggable(Logger.FINEST) == false) return;
            JICPServer.access$000(JICPServer.this).log(Logger.FINEST, "ConnectionHandler closed (" + this + ")");
        }
    }
}

