/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling;

import org.drools.KnowledgeBase;
import org.drools.marshalling.Marshaller;
import org.drools.marshalling.MarshallerProvider;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.marshalling.ObjectMarshallingStrategyAcceptor;

public class MarshallerFactory {
    private static volatile MarshallerProvider provider;

    public static ObjectMarshallingStrategyAcceptor newClassFilterAcceptor(String[] patterns) {
        return MarshallerFactory.getMarshallerProvider().newClassFilterAcceptor(patterns);
    }

    public static ObjectMarshallingStrategy newIdentityMarshallingStrategy() {
        return MarshallerFactory.getMarshallerProvider().newIdentityMarshallingStrategy();
    }

    public static ObjectMarshallingStrategy newIdentityMarshallingStrategy(ObjectMarshallingStrategyAcceptor acceptor) {
        return MarshallerFactory.getMarshallerProvider().newIdentityMarshallingStrategy(acceptor);
    }

    public static ObjectMarshallingStrategy newSerializeMarshallingStrategy() {
        return MarshallerFactory.getMarshallerProvider().newSerializeMarshallingStrategy();
    }

    public static ObjectMarshallingStrategy newSerializeMarshallingStrategy(ObjectMarshallingStrategyAcceptor acceptor) {
        return MarshallerFactory.getMarshallerProvider().newSerializeMarshallingStrategy(acceptor);
    }

    public static Marshaller newMarshaller(KnowledgeBase kbase) {
        return MarshallerFactory.getMarshallerProvider().newMarshaller(kbase);
    }

    public static Marshaller newMarshaller(KnowledgeBase kbase, ObjectMarshallingStrategy[] strategies) {
        return MarshallerFactory.getMarshallerProvider().newMarshaller(kbase, strategies);
    }

    private static synchronized void setMarshallerProvider(MarshallerProvider provider) {
        MarshallerFactory.provider = provider;
    }

    private static synchronized MarshallerProvider getMarshallerProvider() {
        if (provider == null) {
            MarshallerFactory.loadProvider();
        }
        return provider;
    }

    private static void loadProvider() {
        try {
            Class<?> cls = Class.forName("org.drools.marshalling.impl.MarshallerProviderImpl");
            MarshallerFactory.setMarshallerProvider((MarshallerProvider)cls.newInstance());
        }
        catch (Exception e2) {
            throw new RuntimeException("Provider org.drools.marshalling.impl.MarshallerProviderImpl could not be set.", e2);
        }
    }
}

