/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.base.mvel.DroolsMVELFactory;
import org.drools.base.mvel.DroolsMVELShadowFactory;
import org.drools.base.mvel.LocalVariableResolver;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELCompileable;
import org.drools.common.InternalFactHandle;
import org.drools.rule.Declaration;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.Package;
import org.drools.spi.Accumulator;
import org.drools.spi.Tuple;
import org.mvel2.MVEL;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.integration.VariableResolverFactory;

public class MVELAccumulator
implements MVELCompileable,
Accumulator,
Externalizable {
    private static final long serialVersionUID = 510L;
    MVELCompilationUnit initUnit;
    MVELCompilationUnit actionUnit;
    MVELCompilationUnit reverseUnit;
    MVELCompilationUnit resultUnit;
    private DroolsMVELFactory initPrototype;
    private DroolsMVELFactory actionPrototype;
    private DroolsMVELFactory resultPrototype;
    private DroolsMVELFactory reversePrototype;
    private Serializable init;
    private Serializable action;
    private Serializable reverse;
    private Serializable result;

    public MVELAccumulator() {
    }

    public MVELAccumulator(MVELCompilationUnit initUnit, MVELCompilationUnit actionUnit, MVELCompilationUnit reverseUnit, MVELCompilationUnit resultUnit) {
        this.initUnit = initUnit;
        this.actionUnit = actionUnit;
        this.reverseUnit = reverseUnit;
        this.resultUnit = resultUnit;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.initUnit = (MVELCompilationUnit)in.readObject();
        this.actionUnit = (MVELCompilationUnit)in.readObject();
        this.reverseUnit = (MVELCompilationUnit)in.readObject();
        this.resultUnit = (MVELCompilationUnit)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.initUnit);
        out.writeObject(this.actionUnit);
        out.writeObject(this.reverseUnit);
        out.writeObject(this.resultUnit);
    }

    public void compile(ClassLoader classLoader) {
        this.init = this.initUnit.getCompiledExpression(classLoader);
        this.action = this.actionUnit.getCompiledExpression(classLoader);
        this.result = this.resultUnit.getCompiledExpression(classLoader);
        this.initPrototype = this.initUnit.getFactory();
        this.actionPrototype = this.actionUnit.getFactory();
        if (this.reverseUnit != null) {
            this.reverse = this.reverseUnit.getCompiledExpression(classLoader);
            this.reversePrototype = this.reverseUnit.getFactory();
        }
        this.resultPrototype = this.resultUnit.getFactory();
    }

    public Serializable createContext() {
        HashMap<Integer, Map<String, Object>> shadow = null;
        if (this.reverse != null) {
            shadow = new HashMap<Integer, Map<String, Object>>();
        }
        return new MVELAccumulatorContext(new HashMap(), shadow);
    }

    public void init(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, WorkingMemory workingMemory) throws Exception {
        DroolsMVELFactory factory = ((MVELFactoryContext)workingMemoryContext).initPrototype;
        Package pkg = workingMemory.getRuleBase().getPackage("MAIN");
        if (pkg != null) {
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData("mvel");
            factory.setNextFactory((VariableResolverFactory)data.getFunctionFactory());
        }
        factory.setContext(leftTuple, null, null, workingMemory, ((MVELAccumulatorContext)context).variables);
        MVEL.executeExpression((Object)this.init, null, (VariableResolverFactory)factory);
    }

    public void accumulate(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) throws Exception {
        DroolsMVELFactory factory = ((MVELFactoryContext)workingMemoryContext).actionPrototype;
        factory.setContext(leftTuple, null, handle.getObject(), workingMemory, ((MVELAccumulatorContext)context).variables);
        if (this.reverse != null) {
            this.takeSnapshot(context, factory, handle);
        }
        MVEL.executeExpression((Object)this.action, null, (VariableResolverFactory)factory);
    }

    private void takeSnapshot(Object context, DroolsMVELFactory factory, InternalFactHandle handle) {
        DroolsMVELShadowFactory shad = (DroolsMVELShadowFactory)factory;
        Map<String, Object> varsMap = ((MVELAccumulatorContext)context).shadow.get(handle.getId());
        if (varsMap == null) {
            varsMap = new HashMap<String, Object>();
            ((MVELAccumulatorContext)context).shadow.put(handle.getId(), varsMap);
        }
        for (String var : shad.getShadowVariables()) {
            varsMap.put(var, shad.getVariableResolver(var).getValue());
        }
    }

    public void reverse(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) throws Exception {
        DroolsMVELFactory factory = ((MVELFactoryContext)workingMemoryContext).reversePrototype;
        factory.setContext(leftTuple, null, handle.getObject(), workingMemory, ((MVELAccumulatorContext)context).variables);
        ((DroolsMVELShadowFactory)factory).setShadowValues(((MVELAccumulatorContext)context).shadow.get(handle.getId()));
        MVEL.executeExpression((Object)this.reverse, null, (VariableResolverFactory)factory);
        ((DroolsMVELShadowFactory)factory).setShadowValues(null);
        ((MVELAccumulatorContext)context).shadow.remove(handle.getId());
    }

    public Object getResult(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, WorkingMemory workingMemory) throws Exception {
        DroolsMVELFactory factory = ((MVELFactoryContext)workingMemoryContext).resultPrototype;
        factory.setContext(leftTuple, null, null, workingMemory, ((MVELAccumulatorContext)context).variables);
        Map vars = ((MVELAccumulatorContext)context).variables;
        Object result = MVEL.executeExpression((Object)this.result, null, (VariableResolverFactory)factory);
        return result;
    }

    public boolean supportsReverse() {
        return this.reverse != null;
    }

    public Object createWorkingMemoryContext() {
        return new MVELFactoryContext(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MVELAccumulatorContext
    implements Serializable {
        private static final long serialVersionUID = 510L;
        public final Map variables;
        public final Map<Integer, Map<String, Object>> shadow;

        public MVELAccumulatorContext(Map variables, Map<Integer, Map<String, Object>> shadow) {
            this.variables = variables;
            this.shadow = shadow;
        }
    }

    private static class MVELFactoryContext {
        public DroolsMVELFactory initPrototype;
        public DroolsMVELFactory actionPrototype;
        public DroolsMVELFactory resultPrototype;
        public DroolsMVELFactory reversePrototype;

        public MVELFactoryContext(MVELAccumulator acc) {
            this.initPrototype = (DroolsMVELFactory)acc.initPrototype.clone();
            this.actionPrototype = (DroolsMVELFactory)acc.actionPrototype.clone();
            this.resultPrototype = (DroolsMVELFactory)acc.resultPrototype.clone();
            if (acc.reversePrototype != null) {
                this.reversePrototype = (DroolsMVELFactory)acc.reversePrototype.clone();
            }
            for (Map.Entry var : ((CompiledExpression)acc.init).getParserContext().getVariables().entrySet()) {
                this.actionPrototype.addResolver((String)var.getKey(), new LocalVariableResolver(this.actionPrototype, (String)var.getKey()));
                this.resultPrototype.addResolver((String)var.getKey(), new LocalVariableResolver(this.resultPrototype, (String)var.getKey()));
                if (acc.reversePrototype == null) continue;
                this.reversePrototype.addResolver((String)var.getKey(), new LocalVariableResolver(this.reversePrototype, (String)var.getKey()));
            }
        }
    }
}

