/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.drools.SessionConfiguration;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.base.MapGlobalResolver;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalStatelessSession;
import org.drools.common.InternalWorkingMemory;
import org.drools.concurrent.AssertObject;
import org.drools.concurrent.AssertObjects;
import org.drools.concurrent.CommandExecutor;
import org.drools.concurrent.ExecutorService;
import org.drools.concurrent.FireAllRules;
import org.drools.event.AgendaEventListener;
import org.drools.event.AgendaEventSupport;
import org.drools.event.RuleBaseEventListener;
import org.drools.event.RuleFlowEventListener;
import org.drools.event.RuleFlowEventSupport;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.event.WorkingMemoryEventSupport;
import org.drools.impl.EnvironmentFactory;
import org.drools.reteoo.InitialFactImpl;
import org.drools.reteoo.ReteStatelessSessionResult;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.rule.EntryPoint;
import org.drools.spi.AgendaFilter;
import org.drools.spi.ExecutorServiceFactory;
import org.drools.spi.GlobalExporter;
import org.drools.spi.GlobalResolver;

public class ReteooStatelessSession
implements StatelessSession,
InternalStatelessSession,
Externalizable {
    private InternalRuleBase ruleBase;
    private AgendaFilter agendaFilter;
    private GlobalResolver globalResolver = new MapGlobalResolver();
    private GlobalExporter globalExporter;
    private SessionConfiguration sessionConf;
    protected WorkingMemoryEventSupport workingMemoryEventSupport = new WorkingMemoryEventSupport();
    protected AgendaEventSupport agendaEventSupport = new AgendaEventSupport();
    protected RuleFlowEventSupport ruleFlowEventSupport = new RuleFlowEventSupport();

    public ReteooStatelessSession() {
    }

    public ReteooStatelessSession(InternalRuleBase ruleBase) {
        this.ruleBase = ruleBase;
        this.sessionConf = new SessionConfiguration();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ruleBase = (InternalRuleBase)in.readObject();
        this.agendaFilter = (AgendaFilter)in.readObject();
        this.globalResolver = (GlobalResolver)in.readObject();
        this.globalExporter = (GlobalExporter)in.readObject();
        this.sessionConf = new SessionConfiguration();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ruleBase);
        out.writeObject(this.agendaFilter);
        out.writeObject(this.globalResolver);
        out.writeObject(this.globalExporter);
    }

    public InternalRuleBase getRuleBase() {
        return this.ruleBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalWorkingMemory newWorkingMemory() {
        this.ruleBase.readLock();
        try {
            ReteooWorkingMemory wm = new ReteooWorkingMemory(this.ruleBase.nextWorkingMemoryCounter(), this.ruleBase, this.sessionConf, EnvironmentFactory.newEnvironment(), this.workingMemoryEventSupport, this.agendaEventSupport, this.ruleFlowEventSupport);
            wm.setGlobalResolver(this.globalResolver);
            InternalFactHandle handle = wm.getFactHandleFactory().newFactHandle(InitialFactImpl.getInstance(), wm.getObjectTypeConfigurationRegistry().getObjectTypeConf(EntryPoint.DEFAULT, InitialFactImpl.getInstance()), wm, wm);
            wm.queueWorkingMemoryAction(new ReteooWorkingMemory.WorkingMemoryReteAssertAction(handle, false, true, null, null));
            ReteooWorkingMemory reteooWorkingMemory = wm;
            return reteooWorkingMemory;
        }
        finally {
            this.ruleBase.readUnlock();
        }
    }

    public void addEventListener(WorkingMemoryEventListener listener) {
        this.workingMemoryEventSupport.addEventListener(listener);
    }

    public void removeEventListener(WorkingMemoryEventListener listener) {
        this.workingMemoryEventSupport.removeEventListener(listener);
    }

    public List getWorkingMemoryEventListeners() {
        return this.workingMemoryEventSupport.getEventListeners();
    }

    public void addEventListener(AgendaEventListener listener) {
        this.agendaEventSupport.addEventListener(listener);
    }

    public void removeEventListener(AgendaEventListener listener) {
        this.agendaEventSupport.removeEventListener(listener);
    }

    public List getAgendaEventListeners() {
        return this.agendaEventSupport.getEventListeners();
    }

    public void addEventListener(RuleFlowEventListener listener) {
        this.ruleFlowEventSupport.addEventListener(listener);
    }

    public void removeEventListener(RuleFlowEventListener listener) {
        this.ruleFlowEventSupport.removeEventListener(listener);
    }

    public List getRuleFlowEventListeners() {
        return this.ruleFlowEventSupport.getEventListeners();
    }

    public void addEventListener(RuleBaseEventListener listener) {
        this.ruleBase.addEventListener(listener);
    }

    public List getRuleBaseEventListeners() {
        return this.ruleBase.getRuleBaseEventListeners();
    }

    public void removeEventListener(RuleBaseEventListener listener) {
        this.ruleBase.removeEventListener(listener);
    }

    public void setAgendaFilter(AgendaFilter agendaFilter) {
        this.agendaFilter = agendaFilter;
    }

    public void setGlobal(String identifier, Object value) {
        this.globalResolver.setGlobal(identifier, value);
    }

    public void setGlobalResolver(GlobalResolver globalResolver) {
        this.globalResolver = globalResolver;
    }

    public void setGlobalExporter(GlobalExporter globalExporter) {
        this.globalExporter = globalExporter;
    }

    public void execute(Object object) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        wm.insert(object);
        wm.fireAllRules(this.agendaFilter);
    }

    public void execute(Object[] array) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            wm.insert(array[i]);
        }
        wm.fireAllRules(this.agendaFilter);
    }

    public void execute(Collection collection) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            wm.insert(it.next());
        }
        wm.fireAllRules(this.agendaFilter);
    }

    public void asyncExecute(Object object) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        AssertObject assertObject = new AssertObject(object);
        ExecutorService executor = ExecutorServiceFactory.createExecutorService(this.ruleBase.getConfiguration().getExecutorService());
        executor.setCommandExecutor(new CommandExecutor(wm));
        executor.submit(assertObject);
        executor.submit(new FireAllRules(this.agendaFilter));
    }

    public void asyncExecute(Object[] array) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        AssertObjects assertObjects = new AssertObjects(array);
        ExecutorService executor = ExecutorServiceFactory.createExecutorService(this.ruleBase.getConfiguration().getExecutorService());
        executor.setCommandExecutor(new CommandExecutor(wm));
        executor.submit(assertObjects);
        executor.submit(new FireAllRules(this.agendaFilter));
    }

    public void asyncExecute(Collection collection) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        AssertObjects assertObjects = new AssertObjects(collection);
        ExecutorService executor = ExecutorServiceFactory.createExecutorService(this.ruleBase.getConfiguration().getExecutorService());
        executor.setCommandExecutor(new CommandExecutor(wm));
        executor.submit(assertObjects);
        executor.submit(new FireAllRules(this.agendaFilter));
    }

    public StatelessSessionResult executeWithResults(Object object) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        wm.insert(object);
        wm.fireAllRules(this.agendaFilter);
        GlobalResolver globalResolver = null;
        if (this.globalExporter != null) {
            globalResolver = this.globalExporter.export(wm);
        }
        return new ReteStatelessSessionResult(wm, globalResolver);
    }

    public StatelessSessionResult executeWithResults(Object[] array) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            wm.insert(array[i]);
        }
        wm.fireAllRules(this.agendaFilter);
        GlobalResolver globalResolver = null;
        if (this.globalExporter != null) {
            globalResolver = this.globalExporter.export(wm);
        }
        return new ReteStatelessSessionResult(wm, globalResolver);
    }

    public StatelessSessionResult executeWithResults(Collection collection) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            wm.insert(it.next());
        }
        wm.fireAllRules(this.agendaFilter);
        GlobalResolver globalResolver = null;
        if (this.globalExporter != null) {
            globalResolver = this.globalExporter.export(wm);
        }
        return new ReteStatelessSessionResult(wm, globalResolver);
    }
}

