/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.drools.core.util.DroolsClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsCompositeClassLoader
extends ClassLoader
implements DroolsClassLoader {
    private final List<ClassLoader> classLoaders = new CopyOnWriteArrayList<ClassLoader>();
    private final boolean hasParent;

    public DroolsCompositeClassLoader(ClassLoader parentClassLoader, boolean cacheParentCalls) {
        super(parentClassLoader);
        this.hasParent = parentClassLoader != null;
    }

    public synchronized void addClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            return;
        }
        for (ClassLoader cl : this.classLoaders) {
            if (cl != classLoader) continue;
            return;
        }
        this.classLoaders.add(classLoader);
    }

    public synchronized void removeClassLoader(ClassLoader classLoader) {
        this.classLoaders.remove(classLoader);
    }

    @Override
    public Class<?> fastFindClass(String name) {
        for (ClassLoader classLoader : this.classLoaders) {
            Class<?> cls = ((DroolsClassLoader)((Object)classLoader)).fastFindClass(name);
            if (cls == null) continue;
            return cls;
        }
        return null;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cls = this.fastFindClass(name);
        if (this.hasParent && cls == null) {
            cls = Class.forName(name, true, this.getParent());
        }
        if (resolve) {
            this.resolveClass(cls);
        }
        return cls;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (ClassLoader classLoader : this.classLoaders) {
            InputStream stream = classLoader.getResourceAsStream(name);
            if (stream == null) continue;
            return stream;
        }
        if (this.hasParent) {
            return this.getParent().getResourceAsStream(name);
        }
        return null;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> cls = this.fastFindClass(name);
        if (cls == null) {
            throw new ClassNotFoundException(name);
        }
        return cls;
    }
}

