/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.drools.rule.Declaration;
import org.drools.rule.EvalCondition;
import org.drools.rule.From;
import org.drools.rule.GroupElement;
import org.drools.rule.GroupElementFactory;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.Constraint;
import org.drools.spi.DataProvider;
import org.drools.spi.DeclarationScopeResolver;

class LogicTransformer {
    private final Map orTransformations = new HashMap();
    private static LogicTransformer INSTANCE = null;

    static LogicTransformer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LogicTransformer();
        }
        return INSTANCE;
    }

    LogicTransformer() {
        this.initialize();
    }

    private void initialize() {
        this.addTransformationPair(GroupElement.NOT, new NotOrTransformation());
        this.addTransformationPair(GroupElement.EXISTS, new ExistOrTransformation());
        this.addTransformationPair(GroupElement.AND, new AndOrTransformation());
    }

    private void addTransformationPair(GroupElement.Type parent, Transformation method) {
        this.orTransformations.put(parent, method);
    }

    public GroupElement[] transform(GroupElement cloned) throws InvalidPatternException {
        int i;
        this.processTree(cloned);
        cloned.pack();
        GroupElement[] ands = null;
        if (cloned.isAnd()) {
            ands = new GroupElement[]{cloned};
        } else if (cloned.isOr()) {
            ands = new GroupElement[cloned.getChildren().size()];
            i = 0;
            for (RuleConditionElement branch : cloned.getChildren()) {
                if (branch instanceof GroupElement && ((GroupElement)branch).isAnd()) {
                    ands[i++] = (GroupElement)branch;
                    continue;
                }
                ands[i] = GroupElementFactory.newAndInstance();
                ands[i].addChild(branch);
                ++i;
            }
        } else {
            GroupElement wrapper = GroupElementFactory.newAndInstance();
            wrapper.addChild(cloned);
            ands = new GroupElement[]{wrapper};
        }
        for (i = 0; i < ands.length; ++i) {
            this.fixClonedDeclarations(ands[i]);
        }
        return ands;
    }

    private void fixClonedDeclarations(GroupElement and) {
        Stack<RuleConditionElement> contextStack = new Stack<RuleConditionElement>();
        DeclarationScopeResolver resolver = new DeclarationScopeResolver(new Map[0], contextStack);
        contextStack.push(and);
        this.processElement(resolver, contextStack, and);
        contextStack.pop();
    }

    private void processElement(DeclarationScopeResolver resolver, Stack contextStack, RuleConditionElement element) {
        if (element instanceof Pattern) {
            Pattern pattern = (Pattern)element;
            Iterator it = pattern.getNestedElements().iterator();
            while (it.hasNext()) {
                this.processElement(resolver, contextStack, (RuleConditionElement)it.next());
            }
            for (Object next : pattern.getConstraints()) {
                if (next instanceof Declaration) continue;
                Constraint constraint = (Constraint)next;
                Declaration[] decl = constraint.getRequiredDeclarations();
                for (int i = 0; i < decl.length; ++i) {
                    Pattern old;
                    Pattern current;
                    Declaration resolved = resolver.getDeclaration(null, decl[i].getIdentifier());
                    if (resolved != null && resolved != decl[i]) {
                        constraint.replaceDeclaration(decl[i], resolved);
                        continue;
                    }
                    if (resolved != null || (current = resolver.findPatternByIndex((old = decl[i].getPattern()).getIndex())) == null || old == current) continue;
                    resolved = new Declaration(decl[i].getIdentifier(), decl[i].getExtractor(), current);
                    constraint.replaceDeclaration(decl[i], resolved);
                }
            }
        } else if (element instanceof EvalCondition) {
            Declaration[] decl = ((EvalCondition)element).getRequiredDeclarations();
            for (int i = 0; i < decl.length; ++i) {
                Declaration resolved = resolver.getDeclaration(null, decl[i].getIdentifier());
                if (resolved == null || resolved == decl[i]) continue;
                ((EvalCondition)element).replaceDeclaration(decl[i], resolved);
            }
        } else if (element instanceof From) {
            DataProvider provider = ((From)element).getDataProvider();
            Declaration[] decl = provider.getRequiredDeclarations();
            for (int i = 0; i < decl.length; ++i) {
                Pattern old;
                Pattern current;
                Declaration resolved = resolver.getDeclaration(null, decl[i].getIdentifier());
                if (resolved != null && resolved != decl[i]) {
                    provider.replaceDeclaration(decl[i], resolved);
                    continue;
                }
                if (resolved != null || (current = resolver.findPatternByIndex((old = decl[i].getPattern()).getIndex())) == null || old == current) continue;
                resolved = new Declaration(decl[i].getIdentifier(), decl[i].getExtractor(), current);
                provider.replaceDeclaration(decl[i], resolved);
            }
        } else {
            contextStack.push(element);
            Iterator<RuleConditionElement> it = element.getNestedElements().iterator();
            while (it.hasNext()) {
                this.processElement(resolver, contextStack, it.next());
            }
            contextStack.pop();
        }
    }

    void processTree(GroupElement ce) throws InvalidPatternException {
        boolean hasChildOr = false;
        ce.pack();
        Object[] children = ce.getChildren().toArray();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof GroupElement)) continue;
            GroupElement child = (GroupElement)children[i];
            this.processTree(child);
            if ((child.isOr() || child.isAnd()) && child.getType() == ce.getType()) {
                child.pack(ce);
                continue;
            }
            if (!child.isOr()) continue;
            hasChildOr = true;
        }
        if (hasChildOr) {
            this.applyOrTransformation(ce);
        }
    }

    void applyOrTransformation(GroupElement parent) throws InvalidPatternException {
        Transformation transformation = (Transformation)this.orTransformations.get((Object)parent.getType());
        if (transformation == null) {
            throw new RuntimeException("applyOrTransformation could not find transformation for parent '" + (Object)((Object)parent.getType()) + "' and child 'OR'");
        }
        transformation.transform(parent);
    }

    public class NotOrTransformation
    implements Transformation {
        public void transform(GroupElement parent) throws InvalidPatternException {
            if (!(parent.getChildren().get(0) instanceof GroupElement) || !((GroupElement)parent.getChildren().get(0)).isOr()) {
                throw new RuntimeException("NotOrTransformation expected 'OR' but instead found '" + parent.getChildren().get(0).getClass().getName() + "'");
            }
            GroupElement or = (GroupElement)parent.getChildren().get(0);
            parent.setType(GroupElement.AND);
            parent.getChildren().clear();
            Iterator it = or.getChildren().iterator();
            while (it.hasNext()) {
                GroupElement newNot = GroupElementFactory.newNotInstance();
                newNot.addChild((RuleConditionElement)it.next());
                parent.addChild(newNot);
            }
            parent.pack();
        }
    }

    class ExistOrTransformation
    implements Transformation {
        ExistOrTransformation() {
        }

        public void transform(GroupElement parent) throws InvalidPatternException {
            if (!(parent.getChildren().get(0) instanceof GroupElement) || !((GroupElement)parent.getChildren().get(0)).isOr()) {
                throw new RuntimeException("ExistOrTransformation expected 'OR' but instead found '" + parent.getChildren().get(0).getClass().getName() + "'");
            }
            GroupElement or = (GroupElement)parent.getChildren().get(0);
            parent.setType(GroupElement.OR);
            parent.getChildren().clear();
            Iterator it = or.getChildren().iterator();
            while (it.hasNext()) {
                GroupElement newExists = GroupElementFactory.newExistsInstance();
                newExists.addChild((RuleConditionElement)it.next());
                parent.addChild(newExists);
            }
            parent.pack();
        }
    }

    class AndOrTransformation
    implements Transformation {
        AndOrTransformation() {
        }

        public void transform(GroupElement parent) throws InvalidPatternException {
            ArrayList orsList = new ArrayList();
            Object[] others = new Object[parent.getChildren().size()];
            int permutations = 1;
            int index = 0;
            for (Object child : parent.getChildren()) {
                if (child instanceof GroupElement && ((GroupElement)child).isOr()) {
                    permutations *= ((GroupElement)child).getChildren().size();
                    orsList.add(child);
                } else {
                    others[index] = child;
                }
                ++index;
            }
            parent.setType(GroupElement.OR);
            parent.getChildren().clear();
            GroupElement[] ors = orsList.toArray(new GroupElement[orsList.size()]);
            int[] indexes = new int[ors.length];
            for (int i = 1; i <= permutations; ++i) {
                int j;
                GroupElement and = GroupElementFactory.newAndInstance();
                int mod = 1;
                for (j = ors.length - 1; j >= 0; --j) {
                    and.getChildren().add(0, ((RuleConditionElement)ors[j].getChildren().get(indexes[j])).clone());
                    if (i % mod == 0) {
                        indexes[j] = (indexes[j] + 1) % ors[j].getChildren().size();
                    }
                    mod *= ors[j].getChildren().size();
                }
                for (j = 0; j < others.length; ++j) {
                    if (others[j] == null) continue;
                    and.getChildren().add(j, ((RuleConditionElement)others[j]).clone());
                }
                parent.addChild(and);
            }
            parent.pack();
        }
    }

    static interface Transformation {
        public void transform(GroupElement var1) throws InvalidPatternException;
    }
}

