/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.lang.Expander;
import org.drools.lang.ExpanderException;
import org.drools.lang.dsl.AntlrDSLMappingEntry;
import org.drools.lang.dsl.DSLMapping;
import org.drools.lang.dsl.DSLMappingEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExpander
implements Expander {
    private static final String rulesExpr = "(^\\s*rule.*?$.*?^\\s*when.*?)$(.*?)(^\\s*then.*?$)(.*?)(^\\s*end)";
    private static final String queryExpr = "(^\\s*query.*?)$(.*?)(^\\s*end)";
    private static final Pattern finder = Pattern.compile("((^\\s*rule.*?$.*?^\\s*when.*?)$(.*?)(^\\s*then.*?$)(.*?)(^\\s*end)|(^\\s*query.*?)$(.*?)(^\\s*end))", 40);
    private static final Pattern patternFinder = Pattern.compile("\\((.*?)\\)");
    private final Map<String, DSLMapping> mappings = new HashMap<String, DSLMapping>();
    private final List<DSLMappingEntry> keywords = new LinkedList<DSLMappingEntry>();
    private final List<DSLMappingEntry> condition = new LinkedList<DSLMappingEntry>();
    private final List<DSLMappingEntry> consequence = new LinkedList<DSLMappingEntry>();
    private final List<DSLMappingEntry> cleanup = new LinkedList<DSLMappingEntry>();
    private List<ExpanderException> errors = Collections.emptyList();

    public DefaultExpander() {
        this.cleanup.add(new AntlrDSLMappingEntry(DSLMappingEntry.KEYWORD, DSLMappingEntry.EMPTY_METADATA, "expander {name}", "", "expander (.*?)", ""));
    }

    @Override
    public void addDSLMapping(DSLMapping mapping) {
        this.mappings.put(mapping.getIdentifier(), mapping);
        for (DSLMappingEntry entry : mapping.getEntries()) {
            if (DSLMappingEntry.KEYWORD.equals((Object)entry.getSection())) {
                this.keywords.add(entry);
                continue;
            }
            if (DSLMappingEntry.CONDITION.equals((Object)entry.getSection())) {
                this.condition.add(entry);
                continue;
            }
            if (DSLMappingEntry.CONSEQUENCE.equals((Object)entry.getSection())) {
                this.consequence.add(entry);
                continue;
            }
            this.condition.add(entry);
            this.consequence.add(entry);
        }
    }

    @Override
    public String expand(Reader drlReader) throws IOException {
        return this.expand(this.loadDrlFile(drlReader));
    }

    @Override
    public String expand(String drl) {
        drl = this.expandKeywords(drl);
        drl = this.cleanupExpressions(drl);
        StringBuffer buf = this.expandConstructions(drl);
        return buf.toString();
    }

    private StringBuffer expandConstructions(String drl) {
        Matcher m = finder.matcher(drl);
        StringBuffer buf = new StringBuffer();
        while (m.find()) {
            StringBuilder expanded = new StringBuilder();
            String constr = m.group(1).trim();
            if (constr.startsWith("rule")) {
                String headerFragment = m.group(2);
                expanded.append(headerFragment);
                String lhsFragment = m.group(3);
                expanded.append(this.expandLHS(lhsFragment, this.countNewlines(headerFragment) + 1));
                String thenFragment = m.group(4);
                expanded.append(thenFragment);
                expanded.append(this.expandRHS(m.group(5), this.countNewlines(headerFragment + lhsFragment + thenFragment) + 1));
                expanded.append(m.group(6));
                expanded.append("\n");
            } else if (constr.startsWith("query")) {
                String fragment = m.group(7);
                expanded.append(fragment);
                expanded.append(this.expandLHS(m.group(8), this.countNewlines(fragment) + 1));
                expanded.append(m.group(9));
                expanded.append("\n");
            } else {
                this.addError(new ExpanderException("Unable to expand statement: " + constr, 0));
            }
            m.appendReplacement(buf, expanded.toString().replaceAll("\\$", "\\\\\\$"));
        }
        m.appendTail(buf);
        return buf;
    }

    private int countNewlines(String drl) {
        char[] cs = drl.toCharArray();
        int count = 0;
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] != '\n') continue;
            ++count;
        }
        return count;
    }

    private String cleanupExpressions(String drl) {
        for (DSLMappingEntry entry : this.cleanup) {
            drl = entry.getKeyPattern().matcher(drl).replaceAll(entry.getValuePattern());
        }
        return drl;
    }

    private String expandKeywords(String drl) {
        for (DSLMappingEntry entry : this.keywords) {
            drl = entry.getKeyPattern().matcher(drl).replaceAll(entry.getValuePattern());
        }
        return drl;
    }

    private String expandLHS(String lhs, int lineOffset) {
        int i;
        StringBuilder buf = new StringBuilder();
        String[] lines = lhs.split("\n");
        String[] expanded = new String[lines.length];
        int lastExpanded = -1;
        int lastPattern = -1;
        for (i = 0; i < lines.length; ++i) {
            String trimmed = lines[i].trim();
            expanded[++lastExpanded] = lines[i];
            if (trimmed.length() == 0 || trimmed.startsWith("#") || trimmed.startsWith("//")) continue;
            if (trimmed.startsWith(">")) {
                expanded[lastExpanded] = lines[i].replaceFirst(">", " ");
                continue;
            }
            for (DSLMappingEntry entry : this.condition) {
                String vp = entry.getValuePattern();
                expanded[lastExpanded] = entry.getKeyPattern().matcher(expanded[lastExpanded]).replaceAll(vp);
            }
            if (lines[i].equals(expanded[lastExpanded])) {
                this.addError(new ExpanderException("Unable to expand: " + lines[i].replaceAll("[\n\r]", "").trim(), i + lineOffset));
            }
            if (trimmed.startsWith("-") && !lines[i].equals(expanded[lastExpanded])) {
                int lastMatchStart = -1;
                int lastMatchEnd = -1;
                String constraints = "";
                if (lastPattern >= 0) {
                    Matcher m2 = patternFinder.matcher(expanded[lastPattern]);
                    while (m2.find()) {
                        lastMatchStart = m2.start();
                        lastMatchEnd = m2.end();
                        constraints = m2.group(1).trim();
                    }
                }
                if (lastMatchStart > -1) {
                    expanded[lastPattern] = expanded[lastPattern].substring(0, lastMatchStart) + "( " + constraints + (constraints.length() == 0 ? "" : ", ") + expanded[lastExpanded].trim() + " )" + expanded[lastPattern].substring(lastMatchEnd);
                } else {
                    this.addError(new ExpanderException("No pattern was found to add the constraint to: " + lines[i].trim(), i + lineOffset));
                }
                --lastExpanded;
                continue;
            }
            lastPattern = lastExpanded;
        }
        for (i = 0; i <= lastExpanded; ++i) {
            buf.append(expanded[i]);
            buf.append("\n");
        }
        return buf.toString();
    }

    private String expandRHS(String lhs, int lineOffset) {
        StringBuilder buf = new StringBuilder();
        String[] lines = lhs.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String trimmed = lines[i].trim();
            if (trimmed.length() == 0 || trimmed.startsWith("#") || trimmed.startsWith("//")) {
                buf.append(lines[i]);
            } else if (trimmed.startsWith(">")) {
                buf.append(lines[i].replaceFirst(">", ""));
            } else {
                String expanded = lines[i];
                for (DSLMappingEntry entry : this.consequence) {
                    expanded = entry.getKeyPattern().matcher(expanded).replaceAll(entry.getValuePattern());
                }
                buf.append(expanded);
                if (lines[i].equals(expanded)) {
                    this.addError(new ExpanderException("Unable to expand: " + lines[i], i + lineOffset));
                }
            }
            buf.append("\n");
        }
        if (lines.length == 0) {
            buf.append("\n");
        }
        return buf.toString();
    }

    private String loadDrlFile(Reader drl) throws IOException {
        StringBuilder buf = new StringBuilder();
        BufferedReader input = new BufferedReader(drl);
        String line = null;
        while ((line = input.readLine()) != null) {
            buf.append(line);
            buf.append("\n");
        }
        return buf.toString();
    }

    private void addError(ExpanderException error) {
        if (this.errors == Collections.EMPTY_LIST) {
            this.errors = new LinkedList<ExpanderException>();
        }
        this.errors.add(error);
    }

    @Override
    public List<ExpanderException> getErrors() {
        return this.errors;
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }
}

