<?php

  include('whitemouse/config.php');
  define('WHITEMOUSE_VERSION', '1.0.0');
  
  // Funciones auxiliares:
  
  function get_files($dir, $ext)
  {
    $n = 0;
    $r = array();
    
    $d = opendir($dir);
    while($f = readdir($d))
    {
      $file_ext = strrchr($f, '.');
      if($f[0] != '_' && $file_ext == '.'.$ext)
        $r[$n++] = $f;
    }
    closedir($d);
    
    return $r;
  }

  function file_age($f)
  {
	  $t = time();

	  return abs($t - $f) / (24 * 3600);
  }

  // Funciones complementarias:
  
  function print_filelist($dir, $ext)
  {
    $e=explode(' ', $ext);
	$m = count($e);
	$f = array();
	for($n = 0; $n < $m; $n++)
	{
      $f0 = get_files($dir, $e[$n]);
	  $f = array_merge($f, $f0);
	}
    usort($f, 'strcasecmp');
	echo '<ul>';
    $m = count($f);
    for($n = 0; $n < $m; $n++)
	{
  	  $tf = filemtime($dir.'/'.$f[$n]);
	  $ff = date("d.m.Y", $tf);
	  $d = file_age($tf);
	  
      $file_ext = strrchr($f[$n], '.');
      if($file_ext == '.'.LINK_EXTENSION)
	  {
	    $link = file($dir.'/'.$f[$n]);
	    echo '<li><span><a href="'.$link[0].'">'.$f[$n].'</a></span> ';	  
      }
	  else
	  {
	    echo '<li><span><a href="'.$dir.'/'.$f[$n].'">'.$f[$n].'</a></span> ';	  
	  }
	  
      if($d <= 7)
	    echo '<span class="redtext">('.$ff.')</span>';
	  else
	    echo '('.$ff.')';
	  echo '</li>';
	}
	echo '</ul>';
  }
  
  // Funciones principales:
  
  function print_menu()
  {
    if(!defined(INIT_PAGE))
      define("INIT_PAGE", "index.php");
    echo '<a href="'.INIT_PAGE.'">Inicio</a>';
    $f1 = get_files('.', 'php');
    $f2 = get_files('.', 'htm');
    $f3 = get_files('.', 'html');
    $f = array_merge($f1, $f2, $f3);
	$f = array_diff($f, array(INIT_PAGE));
    $m = count($f);
    usort($f, 'strcasecmp');
    for($n = 0; $n < $m; $n++)
    {
      //if($n > 0) echo ' | ';
      echo ' | ';
      $a = $f[$n];
      $ext = strrchr($a, '.');
      if($ext != false) $a = substr($a, 0, -strlen($ext));
      //if($a == 'index') $a = 'inicio';
      $a = ucfirst($a);
      echo '<a href="'.$f[$n].'">'.$a.'</a>';
    }
  }
  
  function print_header()
  {
    echo '<?xml version="1.0"?>';
    echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"'."\n";
    echo '  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">'."\n";
    echo '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="es" lang="es">'."\n";
    echo '<head profile="http://www.w3.org/2005/10/profile">'."\n";
	echo '<link rel="icon" type="image/png" href="imagenes/favicon.png" />';
    echo '<meta http-equiv="content-type" content="text/html; charset=UTF-8" />'."\n";
    echo '<title>'.SITE_TITLE_HEADER.'</title>'."\n";
    echo '<meta name="keywords" content="'.SITE_KEYWORDS.'" />'."\n";
    echo '<meta name="description" content="'.SITE_DESCRIPTION.'" />'."\n";
    echo '<link rel="stylesheet" href="whitemouse/whitemouse.css" type="text/css" />'."\n";
    echo '</head><body>'."\n";
    echo '<div id="title">'.SITE_TITLE.'</div>'."\n";
    echo '<div id="subtitle">'.SITE_SUBTITLE.'</div>'."\n";
    echo '<div id="menu">'."\n";
    print_menu();
    echo '</div>'."\n";
  }
  
  function print_footer()
  {
    echo '<div id="footer">';

    echo '<p>Powered by WhiteMouse '.WHITEMOUSE_VERSION.'</p>'."\n";
    echo '<p><a href="http://validator.w3.org/check?uri=referer">'."\n";
    echo '<img class="noborder" src="http://www.w3.org/Icons/valid-xhtml10"'."\n";
    echo '  alt="Valid XHTML 1.0 Strict" height="31" width="88" /></a></p>';
    echo '<p></p>';
    echo '</div>'."\n";
    
    if(URCHIN_CODE != "")
    {
      echo '<script src="http://www.google-analytics.com/urchin.js" type="text/javascript">';
      echo '</script>';
      echo '<script type="text/javascript">';
      echo '_uacct = "'.URCHIN_CODE.'";';
      echo 'urchinTracker();';
      echo '</script>';
    }
    
    echo '</body></html>'."\n";
  }

?>
