/* DOES NOT USE BUILT-IN DETECTION FUNCTION!
 *
 * base rule: alert tcp $EXTERNAL_NET any -> $HOME_NET 389 (msg:"EXPLOIT LDAP object parameter name buffer overflow attempt"; flow:to_server,established; content:"|30|"; depth:1; metadata:policy security-ips drop, service ldap; classtype:attempted-admin; sid:16375;)
 *
*/
/*
 * Use at your own risk.
 *
 * Copyright (C) 2005-2008 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */


#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

#include "so-util_ber.h"

//#define DEBUG
#ifdef DEBUG
#define DEBUG_SO(code) code
#else
#define DEBUG_SO(code)
#endif


/* declare detection functions */
int rule16375eval(void *p);

/* declare rule data structures */
/* flow:established, to_server; */
static FlowFlags rule16375flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule16375option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule16375flow0
    }
};
#ifndef CONTENT_FAST_PATTERN
#define CONTENT_FAST_PATTERN 0
#endif
// content:"0", depth 1, fast_pattern; 
static ContentInfo rule16375content1 = 
{
    (u_int8_t *) "0", /* pattern (now in snort content format) */
    1, /* depth */
    0, /* offset */
    CONTENT_FAST_PATTERN|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule16375option1 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule16375content1
    }
};

/* references for sid 16375 */
static RuleReference *rule16375refs[] =
{
    NULL
};

/* metadata for sid 16375 */
/* metadata:service ldap, policy security-ips drop; */
//static RuleMetaData rule16375service1 = 
//{
//    "service ldap"
//};
//
//
//static RuleMetaData rule16375policy1 = 
//{
//    "policy security-ips drop"
//};


static RuleMetaData *rule16375metadata[] =
{
//    &rule16375service1,
//    &rule16375policy1,
    NULL
};

RuleOption *rule16375options[] =
{
    &rule16375option0,
    &rule16375option1,
    NULL
};

Rule rule16375 = {
   /* rule header, akin to => tcp any any -> any any */
   {
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
   
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
   
       "389", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid */
       16375, /* sigid */
       3, /* revision */
       "attempted-admin", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "EXPLOIT LDAP object parameter name buffer overflow attempt",     /* message */
       rule16375refs /* ptr to references */
       ,rule16375metadata
   },
   rule16375options, /* ptr to rule options */
   &rule16375eval, /* DOES NOT use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule16375eval(void *p) {
   const u_int8_t *cursor_normal = 0, *beg_of_payload, *end_of_payload;
   SFSnortPacket *sp = (SFSnortPacket *) p;

   BER_ELEMENT ber_element;

   const u_int8_t *end_of_string;
   u_int32_t namelen = 0;

   if(sp == NULL)
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;
   
   // flow:established, to_server;
   if(checkFlow(p, rule16375options[0]->option_u.flowFlags) <= 0)
      return RULE_NOMATCH;

   // Initialize our pointer
   if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) <= 0)
      return RULE_NOMATCH;

   // Universal Sequence
   if(ber_point_to_data(sp, &cursor_normal, 0x30) < 0)
      return RULE_NOMATCH;

   // Message ID
   if(ber_skip_element(sp, &cursor_normal, 0x02) < 0)
      return RULE_NOMATCH;

   // Search Request
   if(ber_point_to_data(sp, &cursor_normal, 0x66) < 0)
      return RULE_NOMATCH;

   // Object
   if(ber_get_element(sp, cursor_normal, &ber_element) < 0)
      return RULE_NOMATCH;

   // Make sure it's a string
   if(ber_element.type != 0x04)
      return RULE_NOMATCH;

   // Move the cursor to the start of the string data
   cursor_normal = ber_element.data.data_ptr;

   end_of_string = cursor_normal + ber_element.data_len;

   // Check for end of buffer
   if(end_of_string > end_of_payload)
      end_of_string = end_of_payload;

   // Now we have cursor_normal pointing to the start of the
   // string and end_of_string set appropriately.  Now,
   // let's see how long the parameter names are.
   while(cursor_normal < end_of_string) {
      if(*cursor_normal != '=')
         namelen++;
      else {
         DEBUG_SO(printf("rule16375: namelen=%d\n", namelen));

         if(namelen > 100)
            return RULE_MATCH;

         // Length is fine.  Set back to zero.
         namelen = 0;

         // Now jump over the value
         while((cursor_normal < end_of_string) && (*cursor_normal != ','))
            cursor_normal++;
      }

      cursor_normal++;
   }

   // If we were in the middle of an overly long parameter name
   // when we ran out of data, match.
   if(namelen > 100)
      return RULE_MATCH;

   return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule16375,
    NULL
};
*/

