/* AUTOGENERATED FROM bad-traffic_dns-zero-len-rdata.rules (custom detection, base only)
XXX BASE ONLY, USES CUSTOM DETECTION FUNCTION XXX
alert tcp $EXTERNAL_NET 53 -> $HOME_NET any (msg:"BAD-TRAFFIC dns zone transfer with zero-length rdata attempt"; flow:to_client,established; content:"|00 01|"; offset:6; depth:2; content:"|00 fc 00 01|"; fast_pattern:only; content:"|00 06 00 01|"; metadata:service dns; reference:cve,2012-1667; reference:url,www.isc.org/software/bind/advisories/cve-2012-1667; classtype:attempted-dos; sid:23608;)
*/
/*
 * Vuln Title: XXXX
 *
 * Copyright (C) 2005-2010 Sourcefire, Inc. All Rights Reserved
 *
 * Written by XXXX, Sourcefire VRT <XXXX@sourcefire.com>
 *
 * Auto-generated by XXXX
 *
 * This file may contain proprietary rules that were created, tested and
 * certified by Sourcefire, Inc. (the "VRT Certified Rules") as well as
 * rules that were created by Sourcefire and other third parties and
 * distributed under the GNU General Public License (the "GPL Rules").  The
 * VRT Certified Rules contained in this file are the property of
 * Sourcefire, Inc. Copyright 2005 Sourcefire, Inc. All Rights Reserved.
 * The GPL Rules created by Sourcefire, Inc. are the property of
 * Sourcefire, Inc. Copyright 2002-2005 Sourcefire, Inc. All Rights
 * Reserved.  All other GPL Rules are owned and copyrighted by their
 * respective owners (please see www.snort.org/contributors for a list of
 * owners and their respective copyrights).  In order to determine what
 * rules are VRT Certified Rules or GPL Rules, please refer to the VRT
 * Certified Rules License Agreement.
 */

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

//#define DEBUG
#ifdef DEBUG
#define DEBUG_SO(code) code
#else
#define DEBUG_SO(code)
#endif

#define GET_BIG16_ai(val, cursor) \
   val  =  *cursor_normal++ << 8; \
   val |= *cursor_normal++;

#define GET_BIG32_ai(val, cursor) \
   val  = *cursor_normal++ << 24; \
   val |= *cursor_normal++ << 16; \
   val |= *cursor_normal++ << 8;  \
   val |= *cursor_normal++;

/* declare detection functions */
int rule23608eval(void *p);

/* declare rule data structures */
/* flow:established, to_client; */
static FlowFlags rule23608flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_CLIENT
};

static RuleOption rule23608option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule23608flow0
    }
};
#ifndef CONTENT_FAST_PATTERN_ONLY
#define CONTENT_FAST_PATTERN_ONLY CONTENT_FAST_PATTERN
#endif
// content:"|00 FC 00 01|", depth 0, fast_pattern:only; 
static ContentInfo rule23608content1 = 
{
    (u_int8_t *) "|00 FC 00 01|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_FAST_PATTERN_ONLY|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule23608option1 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule23608content1
    }
};
// content:"|00 06 00 01|", depth 0; 
static ContentInfo rule23608content2 = 
{
    (u_int8_t *) "|00 06 00 01|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule23608option2 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule23608content2
    }
};

/* references for sid 23608 */
/* reference: cve "2012-1667"; */
static RuleReference rule23608ref1 = 
{
    "cve", /* type */
    "2012-1667" /* value */
};

/* reference: url "www.isc.org/software/bind/advisories/cve-2012-1667"; */
static RuleReference rule23608ref2 = 
{
    "url", /* type */
    "www.isc.org/software/bind/advisories/cve-2012-1667" /* value */
};

static RuleReference *rule23608refs[] =
{
    &rule23608ref1,
    &rule23608ref2,
    NULL
};
/* metadata for sid 23608 */
/* metadata:service dns; */
static RuleMetaData rule23608service1 = 
{
    "service dns"
};

static RuleMetaData *rule23608metadata[] =
{
    &rule23608service1,
    NULL
};

RuleOption *rule23608options[] =
{
    &rule23608option0,
    &rule23608option1,
    &rule23608option2,
    NULL
};

Rule rule23608 = {
   /* rule header, akin to => tcp any any -> any any */
   {
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "53", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid */
       23608, /* sigid */
       1, /* revision */
       "attempted-dos", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "BAD-TRAFFIC dns zone transfer with zero-length rdata attempt",     /* message */
       rule23608refs /* ptr to references */
       ,rule23608metadata
   },
   rule23608options, /* ptr to rule options */
   &rule23608eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};

/* detection functions */
int skip_dns_name(const u_int8_t **cursor_in, const u_int8_t *end_of_payload) {
   const u_int8_t *cursor_normal = *cursor_in;

   while(cursor_normal < end_of_payload && *cursor_normal != 0 && !((*cursor_normal & 0xc0) == 0xc0))
      cursor_normal += *cursor_normal + 1;

   if(cursor_normal >= end_of_payload)
      return(-1);

   // two bytes for pointer or null byte
   cursor_normal += ((*cursor_normal & 0xc0) == 0xc0) ? 2 : 1;

   *cursor_in = cursor_normal;
   return(1);
}

int rule23608eval(void *p) {
   const u_int8_t *cursor_normal = 0;
   SFSnortPacket *sp = (SFSnortPacket *) p;
   const u_int8_t *end_of_payload;

   DEBUG_SO(char *funcname = "rule23608eval";)

   u_int16_t num_answers; //, num_auth_rr, num_addl_rr;

   // tmp values
   u_int16_t tmp_16;
   u_int32_t tmp_32;

   int i;

   if(sp == NULL)
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;
   
   // flow:established, to_client;
   if(checkFlow(p, rule23608options[0]->option_u.flowFlags) <= 0 )
      return RULE_NOMATCH;

   // Verify we are asking for an AXFR (full zone transfer).  This is our fast pattern.
   // content:"|00 FC 00 01|", depth 0, fast_pattern:only;
   // if(contentMatch(p, rule23608options[1]->option_u.content, &cursor_normal) <= 0)
   //    return RULE_NOMATCH

   // Verify we have an SOA (start of zone transfer)         
   // content:"|00 06 00 01|", depth 0;
   if(contentMatch(p, rule23608options[2]->option_u.content, &cursor_normal) <= 0) {
      DEBUG_SO(fprintf(stderr, "%s: did not find SOA\n", funcname);)
      return RULE_NOMATCH;
   }

   // Start processing the packet from the beginning.
   if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &cursor_normal, &end_of_payload) <= 0) 
      return RULE_NOMATCH;

   // Bare minimum to get to exploitation (actually may be a little short)
   if(end_of_payload - cursor_normal < 50)
      return RULE_NOMATCH;

   // We are in TCP, so first two bytes are size
   // Second two bytes are TXID
   cursor_normal += 4;

   // Get the flags
   GET_BIG16_ai(tmp_16, cursor_normal);

   // Ensure we are a response
   // response, standard query, server is an authority for domain, no error
   if((tmp_16 & 0xF60F) != 0x8400) {
      DEBUG_SO(fprintf(stderr, "%s: failed flags check (0x%04x)\n", funcname, tmp_16);)
      return RULE_NOMATCH;
   }

   // Verify there is only one query record
   GET_BIG16_ai(tmp_16, cursor_normal);
   if(tmp_16 != 0x0001) {
      DEBUG_SO(fprintf(stderr, "%s: we do not have one query\n", funcname);)
      return RULE_NOMATCH;
   }

   // Get number of answer records
   GET_BIG16_ai(num_answers, cursor_normal);

   if(num_answers < 2) { // Min answers is SOA + malicious record
      DEBUG_SO(fprintf(stderr, "%s: num_answers is less than 2\n", funcname);)
      return RULE_NOMATCH;
   }

   // Cap the number of answer records we'll process
   if(num_answers > 50)
      num_answers = 50;

   // The exploit is only in the zone transfer, so we don't care about the other records
   // Skip over num authorative records and num additional records
   cursor_normal += 4;

   DEBUG_SO(fprintf(stderr, "%s: num_answers=%d, num_auth_rr=<na>, num_addl_rr=<na>\n", funcname, num_answers);) //, num_auth_rr, num_addl_rr);)

   // Skip over the query
   if(skip_dns_name(&cursor_normal, end_of_payload) <= 0) {
      DEBUG_SO(fprintf(stderr, "%s: failed to skip name in query\n", funcname);)
      return RULE_NOMATCH;
   }

   if(cursor_normal + 4 > end_of_payload)
      return RULE_NOMATCH;

   // Verify our query is for a full zone transfer (this is our fast_pattern, but there it's position is not known)
   // This should result in "|00 fc 00 01|" as AXFR type, IN class.  Reading both at once for speed/laziness/efficiency
   GET_BIG32_ai(tmp_32, cursor_normal);
   
   if(tmp_32 != 0x00fc0001) { // 0x00fc = AXFR, 0x0001 = IN
      DEBUG_SO(fprintf(stderr, "%s: query is not for a full zone transfer (AXFR) -- 0x%08x\n", funcname, tmp_32);)
      return RULE_NOMATCH;
   }

   // Now check the answers
   // Verify the first record is an SOA (start of zone authority)
   if(skip_dns_name(&cursor_normal, end_of_payload) <= 0) {
      DEBUG_SO(fprintf(stderr, "%s: failed to skip name in SOA\n", funcname);)
      return RULE_NOMATCH;
   }

   if(cursor_normal + 10 > end_of_payload) // 4 (type and class) + 4 (TTL) + 2 (rdata len)
      return RULE_NOMATCH;

   // Read the type and class.  Should be 0x0006 SOA 0x0001 IN
   GET_BIG32_ai(tmp_32, cursor_normal);

   if(tmp_32 != 0x00060001) { // type SOA, class IN
      DEBUG_SO(fprintf(stderr, "%s: first response is not for start of zone authority (SOA) -- 0x%08x\n", funcname, tmp_32);)
      return RULE_NOMATCH;
   }

   // Skip the TTL
   cursor_normal += 4;

   // Grab the datalength and skip it 'cause we don't care
   GET_BIG16_ai(tmp_16, cursor_normal);

   cursor_normal += tmp_16; // skip over the data

   // Now we need to loop over the rest of the answer records
   // Records are all the following structure:
   //    <var len>  Name
   //    2 bytes    type
   //    2 bytes    class
   //    4 bytes    time to live
   //    2 bytes    rdata len (X)
   //    X bytes    rdata
   for(i = 1; i < num_answers; i++) { 
      // skip_dns_name does bounds checking for us
      if(skip_dns_name(&cursor_normal, end_of_payload) <= 0) {
         DEBUG_SO(fprintf(stderr, "%s: failed to skip name in answers loop\n", funcname);)
         return RULE_NOMATCH;
      }

      // Don't care about the record type (for now), class, or TTL
      cursor_normal += 2 + 2 + 4;

      if(cursor_normal + 2 > end_of_payload)
         return RULE_NOMATCH;

      // Get the rdata length
      GET_BIG16_ai(tmp_16, cursor_normal);

      if(tmp_16 == 0) {  // Exploit condition is rdata length 0
         DEBUG_SO(fprintf(stderr, "%s: found zero-length RDATA at index %d\n", funcname, i);)
         return RULE_MATCH;
      }

      DEBUG_SO(fprintf(stderr, "%s: index %d: RDATA len = %d\n", funcname, i, tmp_16);)

      // Skip over the data
      cursor_normal += tmp_16;
   }

   // No malicious answer record found      
   return RULE_NOMATCH;
}
/*
Rule *rules[] = {
    &rule23608,
    NULL
};
*/
